/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.datalayout;

import com.oracle.truffle.llvm.runtime.datalayout.DataLayoutParser;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayoutType;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VariableBitWidthType;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.IdentityHashMap;

public final class DataLayout {
    private final ArrayList<DataLayoutParser.DataTypeSpecification> dataLayout;
    private ByteOrder byteOrder;
    private final IdentityHashMap<Type, Long> sizeCache = new IdentityHashMap();
    private final IdentityHashMap<Type, Integer> alignmentCache = new IdentityHashMap();

    public DataLayout(ByteOrder byteOrder) {
        this.dataLayout = new ArrayList();
        this.byteOrder = byteOrder;
    }

    public DataLayout(String layout, String defaultLayout) {
        this.dataLayout = new ArrayList();
        this.byteOrder = DataLayoutParser.parseDataLayout(defaultLayout, this.dataLayout);
        if (!defaultLayout.equalsIgnoreCase(layout)) {
            this.byteOrder = DataLayoutParser.parseDataLayout(layout, this.dataLayout);
        }
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public long getSize(Type type) throws Type.TypeOverflowException {
        int align;
        Long cachedSize = this.sizeCache.get(type);
        if (cachedSize != null) {
            return cachedSize;
        }
        long size = type.getBitSize();
        long rem = Long.remainderUnsigned(size, align = this.getBitAlignment(type));
        if (rem != 0L) {
            size = Type.addUnsignedExact(size, Type.subUnsignedExact(align, rem));
        }
        size = Math.max(1L, Long.divideUnsigned(size, 8L));
        this.sizeCache.put(type, size);
        return size;
    }

    public int getBitAlignment(Type baseType) {
        Integer cachedAlignment = this.alignmentCache.get(baseType);
        if (cachedAlignment != null) {
            return cachedAlignment;
        }
        DataLayoutParser.DataTypeSpecification spec = this.getDataTypeSpecification(baseType);
        if (spec == null) {
            throw new IllegalStateException("No data specification found for " + String.valueOf(baseType) + ". Data layout is " + String.valueOf(this.dataLayout));
        }
        int alignment = spec.getAbiAlignment();
        this.alignmentCache.put(baseType, alignment);
        return alignment;
    }

    public DataLayout merge(DataLayout other) {
        if (other.byteOrder != this.byteOrder) {
            throw new IllegalStateException("Multiple bitcode files with incompatible byte order are used: " + this.toString() + " vs. " + other.toString());
        }
        DataLayout result = new DataLayout(this.byteOrder);
        for (DataLayoutParser.DataTypeSpecification otherEntry : other.dataLayout) {
            DataLayoutParser.DataTypeSpecification thisEntry;
            if (otherEntry.getType() == DataLayoutType.POINTER || otherEntry.getType() == DataLayoutType.INTEGER_WIDTHS) {
                thisEntry = this.getDataTypeSpecification(otherEntry.getType());
            } else if (otherEntry.getType() == DataLayoutType.INTEGER || otherEntry.getType() == DataLayoutType.FLOAT) {
                thisEntry = this.getDataTypeSpecification(otherEntry.getType(), otherEntry.getSize());
            } else {
                throw new IllegalStateException("Unknown data layout type: " + String.valueOf((Object)otherEntry.getType()));
            }
            result.dataLayout.add(otherEntry);
            if (thisEntry == null || thisEntry.equals(otherEntry)) continue;
            throw new IllegalStateException("Multiple bitcode files with incompatible layout strings are used: " + this.toString() + " vs. " + other.toString());
        }
        return result;
    }

    public String toString() {
        return this.dataLayout.toString();
    }

    private DataLayoutParser.DataTypeSpecification getDataTypeSpecification(Type baseType) {
        if (baseType instanceof PointerType || baseType instanceof FunctionType) {
            DataLayoutParser.DataTypeSpecification ptrDTSpec = this.getDataTypeSpecification(DataLayoutType.POINTER, 64);
            return ptrDTSpec == null ? this.getDataTypeSpecification(DataLayoutType.POINTER) : ptrDTSpec;
        }
        if (baseType instanceof PrimitiveType) {
            PrimitiveType primitiveType = (PrimitiveType)baseType;
            switch (primitiveType.getPrimitiveKind()) {
                case I1: 
                case I8: {
                    return this.getDataTypeSpecification(DataLayoutType.INTEGER, 8);
                }
                case I16: {
                    return this.getDataTypeSpecification(DataLayoutType.INTEGER, 16);
                }
                case I32: {
                    return this.getDataTypeSpecification(DataLayoutType.INTEGER, 32);
                }
                case I64: {
                    return this.getDataTypeSpecification(DataLayoutType.INTEGER, 64);
                }
                case HALF: {
                    return this.getDataTypeSpecification(DataLayoutType.FLOAT, 16);
                }
                case FLOAT: {
                    return this.getDataTypeSpecification(DataLayoutType.FLOAT, 32);
                }
                case DOUBLE: {
                    return this.getDataTypeSpecification(DataLayoutType.FLOAT, 64);
                }
                case X86_FP80: {
                    return this.getDataTypeSpecification(DataLayoutType.FLOAT, 80);
                }
                case F128: {
                    return this.getDataTypeSpecification(DataLayoutType.FLOAT, 128);
                }
            }
        } else if (baseType instanceof VariableBitWidthType) {
            int bits = ((VariableBitWidthType)baseType).getBitSizeInt();
            DataLayoutParser.DataTypeSpecification largest = null;
            DataLayoutParser.DataTypeSpecification smallestLarger = null;
            for (DataLayoutParser.DataTypeSpecification spec : this.dataLayout) {
                if (spec.getType() != DataLayoutType.INTEGER) continue;
                if (largest == null || largest.getSize() < spec.getSize()) {
                    largest = spec;
                }
                if (spec.getSize() < bits || smallestLarger != null && smallestLarger.getSize() <= spec.getSize()) continue;
                smallestLarger = spec;
            }
            if (smallestLarger != null) {
                return smallestLarger;
            }
            return largest;
        }
        return null;
    }

    private DataLayoutParser.DataTypeSpecification getDataTypeSpecification(DataLayoutType dataLayoutType) {
        for (DataLayoutParser.DataTypeSpecification spec : this.dataLayout) {
            if (!spec.getType().equals((Object)dataLayoutType)) continue;
            return spec;
        }
        return null;
    }

    private DataLayoutParser.DataTypeSpecification getDataTypeSpecification(DataLayoutType dataLayoutType, int size) {
        for (DataLayoutParser.DataTypeSpecification spec : this.dataLayout) {
            if (!spec.getType().equals((Object)dataLayoutType) || size != spec.getSize()) continue;
            return spec;
        }
        return null;
    }

    public long getByteSize(Type type) throws Type.TypeOverflowException {
        return type.getSize(this);
    }

    public int getBytePadding(long offset, Type type) {
        return Type.getPadding(offset, type, this);
    }

    public StructureTypeOffsets getStructureTypeOffsets(Type type) throws Type.TypeOverflowException {
        return StructureTypeOffsets.fromType(this, type);
    }

    public static final class StructureTypeOffsets {
        Type[] types;
        long[] offsets;

        private StructureTypeOffsets(Type[] retTypes, long[] retOffsets) {
            this.types = retTypes;
            this.offsets = retOffsets;
        }

        public Type[] getTypes() {
            return this.types;
        }

        public long[] getOffsets() {
            return this.offsets;
        }

        public static StructureTypeOffsets fromStructuredType(DataLayout dataLayout, StructureType retType) throws Type.TypeOverflowException {
            Type[] retTypes = null;
            long[] retOffsets = null;
            StructureType struct = retType;
            retOffsets = new long[struct.getNumberOfElementsInt()];
            retTypes = new Type[struct.getNumberOfElementsInt()];
            long currentOffset = 0L;
            int i = 0;
            while ((long)i < struct.getNumberOfElements()) {
                Type elemType = struct.getElementType(i);
                if (!struct.isPacked()) {
                    currentOffset = Type.addUnsignedExact(currentOffset, dataLayout.getBytePadding(currentOffset, elemType));
                }
                retOffsets[i] = currentOffset;
                retTypes[i] = elemType;
                currentOffset = Type.addUnsignedExact(currentOffset, dataLayout.getByteSize(elemType));
                ++i;
            }
            assert (currentOffset <= dataLayout.getByteSize(retType)) : "currentOffset " + currentOffset + " vs. byteSize " + dataLayout.getByteSize(retType);
            return new StructureTypeOffsets(retTypes, retOffsets);
        }

        public static StructureTypeOffsets fromType(DataLayout dataLayout, Type retType) throws Type.TypeOverflowException {
            if (retType instanceof StructureType) {
                return StructureTypeOffsets.fromStructuredType(dataLayout, (StructureType)retType);
            }
            return new StructureTypeOffsets(null, null);
        }
    }
}

