/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI16LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMPointerLoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public final class LLVMDebugPointer {
    private LLVMPointer pointer;

    public static LLVMDebugPointer of(LLVMPointer pointer) {
        return new LLVMDebugPointer(pointer);
    }

    public static LLVMDebugPointer of(long pointer) {
        return LLVMDebugPointer.of(LLVMNativePointer.create(pointer));
    }

    public LLVMDebugPointer(LLVMPointer pointer) {
        this.pointer = pointer;
    }

    public String readAsciiString() {
        return LLVMReadStringNodeGen.create().executeWithTarget(this.pointer);
    }

    private static char charOfByte(byte v) {
        if (v < 32 || v > 126) {
            return '.';
        }
        return (char)v;
    }

    public LLVMPointer getPointer() {
        return this.pointer;
    }

    public byte readI8() {
        return this.readI8(0L);
    }

    public byte readI8(long offset) {
        return LLVMI8LoadNodeGen.LLVMI8OffsetLoadNodeGen.getUncached().executeWithTarget(this.pointer, offset);
    }

    public short readI16() {
        return this.readI16(0L);
    }

    public short readI16(long offset) {
        return LLVMI16LoadNodeGen.LLVMI16OffsetLoadNodeGen.getUncached().executeWithTarget(this.pointer, offset);
    }

    public int readI32() {
        return this.readI32(0L);
    }

    public int readI32(long offset) {
        return LLVMI32LoadNodeGen.LLVMI32OffsetLoadNodeGen.getUncached().executeWithTarget(this.pointer, offset);
    }

    public long readI64() throws UnexpectedResultException {
        return this.readI64(0L);
    }

    public long readI64(long offset) throws UnexpectedResultException {
        return LLVMI64LoadNodeGen.LLVMI64OffsetLoadNodeGen.getUncached().executeWithTarget(this.pointer, offset);
    }

    public void writeI8(long offset, byte value) {
        LLVMI8StoreNodeGen.LLVMI8OffsetStoreNodeGen.getUncached().executeWithTarget(this.pointer, offset, value);
    }

    public void writeI8(byte value) {
        this.writeI8(0L, value);
    }

    public void writeI16(long offset, short value) {
        LLVMI16StoreNodeGen.LLVMI16OffsetStoreNodeGen.getUncached().executeWithTarget(this.pointer, offset, value);
    }

    public void writeI16(short value) {
        this.writeI16(0L, value);
    }

    public void writeI32(long offset, int value) {
        LLVMI32StoreNodeGen.LLVMI32OffsetStoreNodeGen.getUncached().executeWithTarget(this.pointer, offset, value);
    }

    public void writeI32(int value) {
        this.writeI32(0L, value);
    }

    public void writeI64(long offset, long value) {
        LLVMI64StoreNodeGen.LLVMI64OffsetStoreNodeGen.getUncached().executeWithTarget(this.pointer, offset, value);
    }

    public void writeI64(long value) {
        this.writeI64(0L, value);
    }

    public LLVMPointer readPointer() {
        return this.readPointer(0L);
    }

    public LLVMPointer readPointer(long offset) {
        return LLVMPointerLoadNodeGen.LLVMPointerOffsetLoadNodeGen.getUncached().executeWithTarget(this.pointer, offset);
    }

    public String asHex() {
        return String.format("%08x", LLVMNativePointer.cast(this.pointer).asNative());
    }

    public String readHex(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; i += 16) {
            int j;
            StringBuilder asciiOut = new StringBuilder();
            sb.append(String.format("%08x  ", i));
            int remaining = Math.min(length - i, 16);
            for (j = 0; j < remaining; ++j) {
                byte v = this.readI8(i + j);
                sb.append(String.format("%02x ", v));
                asciiOut.append(LLVMDebugPointer.charOfByte(v));
            }
            for (j = remaining; j < 16; ++j) {
                sb.append("   ");
            }
            sb.append(' ');
            sb.append(asciiOut.toString());
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    public LLVMDebugPointer deref() {
        return this.deref(0L);
    }

    public LLVMDebugPointer deref(long offset) {
        return LLVMDebugPointer.of(this.readPointer(offset));
    }

    public LLVMDebugPointer increment(long offset) {
        return LLVMDebugPointer.of(this.pointer.increment(offset));
    }

    public String toString() {
        return this.pointer.toString();
    }
}

