/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.attributes;

import com.oracle.truffle.llvm.parser.model.attributes.AttributesGroup;
import java.util.Collections;
import java.util.List;

public class AttributesCodeEntry {
    public static final AttributesCodeEntry EMPTY = new AttributesCodeEntry(Collections.emptyList());
    private final List<AttributesGroup> codeEntry;

    public AttributesCodeEntry(List<AttributesGroup> codeEntry) {
        this.codeEntry = codeEntry;
    }

    public AttributesGroup getFunctionAttributesGroup() {
        for (AttributesGroup entry : this.codeEntry) {
            if (!entry.isFunctionAttribute()) continue;
            return entry;
        }
        return null;
    }

    public AttributesGroup getReturnAttributesGroup() {
        for (AttributesGroup entry : this.codeEntry) {
            if (!entry.isReturnValueAttribute()) continue;
            return entry;
        }
        return null;
    }

    public AttributesGroup getParameterAttributesGroup(int idx) {
        for (AttributesGroup entry : this.codeEntry) {
            if (!entry.isParameterAttribute() || entry.getParamIdx() != (long)(idx + 1)) continue;
            return entry;
        }
        return null;
    }

    public String toString() {
        return "AttributesCodeEntry [codeEntry=" + String.valueOf(this.codeEntry) + "]";
    }
}

