/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.listeners.Metadata;
import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDType;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import com.oracle.truffle.llvm.parser.metadata.ParseUtil;
import com.oracle.truffle.llvm.parser.records.DwTagRecord;

public final class MDDerivedType
extends MDType
implements MDBaseNode {
    private MDBaseNode baseType;
    private MDBaseNode scope = MDVoidNode.INSTANCE;
    private MDBaseNode extraData;
    private static final int ARGINDEX_38_TAG = 1;
    private static final int ARGINDEX_38_NAME = 2;
    private static final int ARGINDEX_38_FILE = 3;
    private static final int ARGINDEX_38_LINE = 4;
    private static final int ARGINDEX_38_SCOPE = 5;
    private static final int ARGINDEX_38_BASETYPE = 6;
    private static final int ARGINDEX_38_SIZE = 7;
    private static final int ARGINDEX_38_ALIGN = 8;
    private static final int ARGINDEX_38_OFFSET = 9;
    private static final int ARGINDEX_38_FLAGS = 10;
    private static final int ARGINDEX_38_EXTRADATA = 11;
    private static final int ARGINDEX_32_TAG = 0;
    private static final int ARGINDEX_32_SCOPE = 1;
    private static final int ARGINDEX_32_NAME = 2;
    private static final int ARGINDEX_32_FILE = 3;
    private static final int ARGINDEX_32_LINE = 4;
    private static final int ARGINDEX_32_SIZE = 5;
    private static final int ARGINDEX_32_ALIGN = 6;
    private static final int ARGINDEX_32_OFFSET = 7;
    private static final int ARGINDEX_32_FLAGS = 8;
    private static final int ARGINDEX_32_BASETYPE = 9;

    private MDDerivedType(long tag, long line, long size, long align, long offset, long flags) {
        super(tag, size, align, offset, line, flags);
        this.baseType = MDVoidNode.INSTANCE;
        this.extraData = MDVoidNode.INSTANCE;
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    public MDBaseNode getBaseType() {
        return this.baseType;
    }

    public MDBaseNode getScope() {
        return this.scope;
    }

    public MDBaseNode getExtraData() {
        return this.extraData;
    }

    @Override
    public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
        super.replace(oldValue, newValue);
        if (this.baseType == oldValue) {
            this.baseType = newValue;
        }
        if (this.scope == oldValue) {
            this.scope = newValue;
        }
        if (this.extraData == oldValue) {
            this.extraData = newValue;
        }
    }

    public static MDDerivedType create38(long[] args, MetadataValueList md) {
        long tag = args[1];
        long line = args[4];
        long size = args[7];
        long align = args[8];
        long offset = args[9];
        long flags = args[10];
        MDDerivedType derivedType = new MDDerivedType(tag, line, size, align, offset, flags);
        derivedType.scope = md.getNullable(args[5], derivedType);
        derivedType.baseType = md.getNullable(args[6], derivedType);
        derivedType.extraData = md.getNullable(args[11], derivedType);
        derivedType.setFile(md.getNullable(args[3], derivedType));
        derivedType.setName(md.getNullable(args[2], derivedType));
        return derivedType;
    }

    public static MDDerivedType create32(long[] args, Metadata md) {
        long tag = DwTagRecord.decode(ParseUtil.asLong(args, 0, md)).code();
        long line = ParseUtil.asInt(args, 4, md);
        long size = ParseUtil.asLong(args, 5, md);
        long align = ParseUtil.asLong(args, 6, md);
        long offset = ParseUtil.asLong(args, 7, md);
        long flags = ParseUtil.asLong(args, 8, md);
        MDDerivedType derivedType = new MDDerivedType(tag, line, size, align, offset, flags);
        derivedType.scope = ParseUtil.resolveReference(args, 1, derivedType, md);
        derivedType.baseType = ParseUtil.resolveReference(args, 9, derivedType, md);
        derivedType.setFile(ParseUtil.resolveReference(args, 3, derivedType, md));
        derivedType.setName(ParseUtil.resolveReference(args, 2, derivedType, md));
        return derivedType;
    }
}

