/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.handles;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeChild(type=LLVMExpressionNode.class)
public abstract class GraalVMResolveFunction
extends LLVMIntrinsic {
    @Specialization
    protected Object doNativeResolve(LLVMNativePointer pointer, @Cached ConditionProfile isFunction) {
        LLVMFunctionDescriptor descriptor = this.getContext().getFunctionDescriptor(pointer);
        if (isFunction.profile(descriptor != null)) {
            return LLVMManagedPointer.create(descriptor);
        }
        return pointer;
    }

    @Specialization(guards={"pointsToFunctionDescriptor(pointer)"})
    protected Object doManagedResolve(LLVMManagedPointer pointer) {
        return pointer;
    }

    @Specialization(guards={"pointsToLong(pointer)"})
    protected Object doNativePointerResolve(LLVMPointer pointer) {
        LLVMManagedPointer object = LLVMManagedPointer.cast(pointer);
        Object pointerValue = object.getObject();
        LLVMNativePointer nativePointer = LLVMNativePointer.create((Long)pointerValue);
        return LLVMManagedPointer.create(this.getContext().getFunctionDescriptor(nativePointer));
    }

    @Fallback
    protected Object doError(Object pointer) {
        throw new LLVMPolyglotException((Node)this, "Cannot resolve pointer %s to a function.", pointer);
    }

    protected boolean pointsToFunctionDescriptor(LLVMManagedPointer pointer) {
        return pointer.getObject() instanceof LLVMFunctionDescriptor;
    }

    protected boolean pointsToLong(LLVMPointer pointer) {
        if (LLVMManagedPointer.isInstance(pointer)) {
            return LLVMManagedPointer.cast(pointer).getObject() instanceof Long;
        }
        return false;
    }
}

