/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.floating;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.memory.ByteArraySupport;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.llvm.runtime.floating.DoubleHelper;
import com.oracle.truffle.llvm.runtime.floating.FloatHelper;
import com.oracle.truffle.llvm.runtime.floating.LLVMLongDoubleFloatingPoint;
import com.oracle.truffle.nfi.api.SerializableLibrary;
import java.nio.ByteOrder;
import java.util.Arrays;

@CompilerDirectives.ValueType
@ExportLibrary(value=SerializableLibrary.class, useForAOT=false)
public final class LLVM80BitFloat
extends LLVMLongDoubleFloatingPoint {
    private static final int BIT_TO_HEX_FACTOR = 4;
    public static final int BIT_WIDTH = 80;
    public static final int BYTE_WIDTH = 10;
    private static final int EXPONENT_BIT_WIDTH = 15;
    private static final int FRACTION_BIT_WIDTH = 64;
    private static final int HEX_DIGITS_FRACTION = 16;
    private static final byte UNDEFINED_FLOAT_TO_BYTE_VALUE = 0;
    private static final short UNDEFINED_FLOAT_TO_SHORT_VALUE = 0;
    private static final int UNDEFINED_FLOAT_TO_INT_VALUE = Integer.MIN_VALUE;
    private static final long UNDEFINED_FLOAT_TO_LONG_VALUE = Long.MIN_VALUE;
    private static final long UNDEFINED_DOUBLE_VALUE = Long.MIN_VALUE;
    public static final short EXPONENT_MASK = Short.MAX_VALUE;
    public static final short SIGN_BIT = Short.MIN_VALUE;
    private static final LLVM80BitFloat DOUBLE_MINUS_INFINITY_CONVERSION_NUMBER = LLVM80BitFloat.fromRawValues(true, Short.MAX_VALUE, Long.MIN_VALUE);
    private static final LLVM80BitFloat DOUBLE_INFINITY_CONVERSION_NUMBER = LLVM80BitFloat.fromRawValues(false, Short.MAX_VALUE, Long.MIN_VALUE);
    private static final LLVM80BitFloat DOUBLE_NAN_CONVERSION_NUMBER = LLVM80BitFloat.fromRawValues(false, Short.MAX_VALUE, -4611686018427387904L);
    private static final LLVM80BitFloat POSITIVE_ZERO = LLVM80BitFloat.fromRawValues(false, 0, 0L);
    private static final LLVM80BitFloat NEGATIVE_ZERO = LLVM80BitFloat.fromRawValues(true, 0, 0L);
    private static final LLVM80BitFloat POSITIVE_INFINITY = LLVM80BitFloat.fromRawValues(false, Short.MAX_VALUE, LLVM80BitFloat.bit(63L));
    private static final LLVM80BitFloat NEGATIVE_INFINITY = LLVM80BitFloat.fromRawValues(true, Short.MAX_VALUE, LLVM80BitFloat.bit(63L));
    private static final int EXPLICIT_LEADING_ONE_BITS = 1;
    private static final int EXPONENT_BIAS = 16383;
    private static final int FLOAT_EXPONENT_BIAS = 127;
    private final short expSign;
    private final long fraction;

    public String toString() {
        return LLVM80BitFloat.toLLVMString(this);
    }

    @CompilerDirectives.TruffleBoundary
    public String toDebugString() {
        return String.format("sign: %s\nexponent: %s\nfraction: %s %s\n", this.getSign(), LLVM80BitFloat.getBinaryString(15, this.getExponent()), LLVM80BitFloat.getBinaryString(64, this.getFraction()), LLVM80BitFloat.getHexString(16, this.getFraction()));
    }

    @CompilerDirectives.TruffleBoundary
    public static String toLLVMString(LLVM80BitFloat value) {
        if (value.isQNaN()) {
            return "QNaN";
        }
        if (value.isSNaN()) {
            return "SNaN";
        }
        if (value.isInfinity()) {
            return "INF";
        }
        short exponent = value.getExponent();
        if (value.getSign()) {
            exponent = (short)(exponent | Short.MIN_VALUE);
        }
        long fraction = value.getFraction();
        return String.format("0xK%4x%16x", exponent, fraction).replace(' ', '0');
    }

    @CompilerDirectives.TruffleBoundary
    private static String getBinaryString(int bitWidth, long number) {
        return String.format("%" + bitWidth + "s", Long.toBinaryString(number)).replace(" ", "0");
    }

    @CompilerDirectives.TruffleBoundary
    private static String getHexString(int bitWidth, long number) {
        return String.format("%" + bitWidth + "x", number).replace(" ", "0");
    }

    public LLVM80BitFloat(short expSign, long fraction) {
        this.expSign = expSign;
        this.fraction = fraction;
    }

    public static LLVM80BitFloat fromRawValues(boolean sign, int exponent, long fraction) {
        assert ((exponent & 0x7FFFF) == exponent);
        short expSign = (short)exponent;
        if (sign) {
            expSign = (short)(expSign | Short.MIN_VALUE);
        }
        return new LLVM80BitFloat(expSign, fraction);
    }

    private LLVM80BitFloat(LLVM80BitFloat value) {
        this.expSign = value.expSign;
        this.fraction = value.fraction;
    }

    private int getUnbiasedExponent() {
        return (this.expSign & Short.MAX_VALUE) - 16383;
    }

    public static LLVM80BitFloat createPositiveZero() {
        if (CompilerDirectives.inCompiledCode()) {
            return LLVM80BitFloat.fromRawValues(false, 0, 0L);
        }
        return POSITIVE_ZERO;
    }

    public static long bit(long i) {
        return 1L << (int)i;
    }

    public static LLVM80BitFloat fromLong(long val) {
        if (val == 0L) {
            return LLVM80BitFloat.createPositiveZero();
        }
        boolean sign = val < 0L;
        return LLVM80BitFloat.fromLong(Math.abs(val), sign);
    }

    private static LLVM80BitFloat fromLong(long val, boolean sign) {
        int leadingOnePosition = 64 - Long.numberOfLeadingZeros(val);
        int exponent = 16383 + (leadingOnePosition - 1);
        long fractionMask = leadingOnePosition == 64 || leadingOnePosition == 63 ? -1L : (1L << leadingOnePosition + 1) - 1L;
        long maskedFractionValue = val & fractionMask;
        long fraction = maskedFractionValue << 64 - leadingOnePosition;
        return LLVM80BitFloat.fromRawValues(sign, exponent, fraction);
    }

    public static LLVM80BitFloat fromUnsignedLong(long val) {
        if (val == 0L) {
            return new LLVM80BitFloat(POSITIVE_ZERO);
        }
        return LLVM80BitFloat.fromLong(val, false);
    }

    public static LLVM80BitFloat fromUnsignedInt(int val) {
        if (val == 0) {
            return new LLVM80BitFloat(POSITIVE_ZERO);
        }
        return LLVM80BitFloat.fromLong((long)val & 0xFFFFFFFFL, false);
    }

    public static LLVM80BitFloat fromInt(int val) {
        if (val == 0) {
            return new LLVM80BitFloat(POSITIVE_ZERO);
        }
        boolean sign = val < 0;
        return LLVM80BitFloat.fromInt(val, sign);
    }

    private static LLVM80BitFloat fromInt(int val, boolean sign) {
        int posVal = Math.abs(val);
        int leadingOnePosition = 32 - Integer.numberOfLeadingZeros(posVal);
        int exponent = 16383 + (leadingOnePosition - 1);
        long fractionMask = (1L << leadingOnePosition + 1) - 1L;
        long maskedFractionValue = (long)posVal & fractionMask;
        long fraction = maskedFractionValue << 64 - leadingOnePosition;
        return LLVM80BitFloat.fromRawValues(sign, exponent, fraction);
    }

    private static boolean getBit(int position, long posVal) {
        long l = posVal >>> position;
        return (l & 1L) != 0L;
    }

    public boolean isZero() {
        return this.isPositiveZero() || this.isNegativeZero();
    }

    public boolean isPositiveZero() {
        return this.equals(POSITIVE_ZERO);
    }

    public boolean isNegativeZero() {
        return this.equals(NEGATIVE_ZERO);
    }

    public static LLVM80BitFloat fromFloat(float val) {
        boolean sign;
        boolean bl = sign = val < 0.0f;
        if (FloatHelper.isPositiveZero(val)) {
            return new LLVM80BitFloat(POSITIVE_ZERO);
        }
        if (FloatHelper.isNegativeZero(val)) {
            return new LLVM80BitFloat(NEGATIVE_ZERO);
        }
        if (FloatHelper.isPositiveInfinty(val)) {
            return new LLVM80BitFloat(DOUBLE_INFINITY_CONVERSION_NUMBER);
        }
        if (FloatHelper.isNegativeInfinity(val)) {
            return new LLVM80BitFloat(DOUBLE_MINUS_INFINITY_CONVERSION_NUMBER);
        }
        if (FloatHelper.isNaN(val)) {
            return new LLVM80BitFloat(DOUBLE_NAN_CONVERSION_NUMBER);
        }
        int rawValue = Float.floatToRawIntBits(val);
        int floatExponent = FloatHelper.getUnbiasedExponent(val);
        int biasedExponent = floatExponent + 16383;
        long leadingOne = Long.MIN_VALUE;
        long floatFraction = rawValue & FloatHelper.FRACTION_MASK;
        long shiftedFloatFraction = floatFraction << 40;
        long fraction = shiftedFloatFraction | leadingOne;
        return LLVM80BitFloat.fromRawValues(sign, biasedExponent, fraction);
    }

    public static LLVM80BitFloat fromDouble(double val) {
        boolean sign;
        boolean bl = sign = val < 0.0;
        if (DoubleHelper.isPositiveZero(val)) {
            return new LLVM80BitFloat(POSITIVE_ZERO);
        }
        if (DoubleHelper.isNegativeZero(val)) {
            return new LLVM80BitFloat(NEGATIVE_ZERO);
        }
        if (DoubleHelper.isPositiveInfinty(val)) {
            return new LLVM80BitFloat(DOUBLE_INFINITY_CONVERSION_NUMBER);
        }
        if (DoubleHelper.isNegativeInfinity(val)) {
            return new LLVM80BitFloat(DOUBLE_MINUS_INFINITY_CONVERSION_NUMBER);
        }
        if (DoubleHelper.isNaN(val)) {
            return new LLVM80BitFloat(DOUBLE_NAN_CONVERSION_NUMBER);
        }
        long rawValue = Double.doubleToRawLongBits(val);
        int doubleExponent = DoubleHelper.getUnbiasedExponent(val);
        int biasedExponent = doubleExponent + 16383;
        long leadingOne = Long.MIN_VALUE;
        long doubleFraction = rawValue & DoubleHelper.FRACTION_MASK;
        long shiftedDoubleFraction = doubleFraction << 11;
        long fraction = shiftedDoubleFraction | leadingOne;
        return LLVM80BitFloat.fromRawValues(sign, biasedExponent, fraction);
    }

    private long getFractionAsLong() {
        return this.fraction >>> 64 - this.getUnbiasedExponent() - 1;
    }

    public LLVM80BitFloat abs() {
        return new LLVM80BitFloat((short)(this.expSign & Short.MAX_VALUE), this.fraction);
    }

    public boolean isPositiveInfinity() {
        return POSITIVE_INFINITY.equals(this);
    }

    public boolean isNegativeInfinity() {
        return NEGATIVE_INFINITY.equals(this);
    }

    public boolean isInfinity() {
        return this.isPositiveInfinity() || this.isNegativeInfinity();
    }

    public boolean isSNaN() {
        if (this.getExponent() == Short.MAX_VALUE && LLVM80BitFloat.getBit(63, this.getFraction()) && !LLVM80BitFloat.getBit(62, this.getFraction())) {
            return (this.getFraction() & 0x3FFFFFFFFFFFFFFFL) != 0L;
        }
        return false;
    }

    public boolean isQNaN() {
        if (this.getExponent() == Short.MAX_VALUE) {
            if (LLVM80BitFloat.getBit(63, this.getFraction())) {
                if (LLVM80BitFloat.getBit(62, this.getFraction())) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public boolean isNaN() {
        return this.isSNaN() || this.isQNaN();
    }

    public boolean isOrdered() {
        return !this.isNaN();
    }

    int compareOrdered(LLVM80BitFloat val) {
        if (this.isNegativeInfinity()) {
            if (val.isNegativeInfinity()) {
                return 0;
            }
            return -1;
        }
        if (val.isNegativeInfinity()) {
            if (this.isNegativeInfinity()) {
                return 0;
            }
            return 1;
        }
        if (this.getSign() == val.getSign()) {
            int expDifference = this.getExponent() - val.getExponent();
            if (expDifference == 0) {
                long fractionDifference = this.getFraction() - val.getFraction();
                if (fractionDifference == 0L) {
                    return 0;
                }
                if (fractionDifference < 0L) {
                    return -1;
                }
                return 1;
            }
            return expDifference;
        }
        if (this.isZero() && val.isZero()) {
            return 0;
        }
        if (this.getSign()) {
            return -1;
        }
        return 1;
    }

    public short getExponent() {
        return (short)(this.expSign & Short.MAX_VALUE);
    }

    public long getFraction() {
        return this.fraction;
    }

    public long getFractionWithoutImplicitZero() {
        return this.fraction << 1;
    }

    public short getExpSign() {
        return this.expSign;
    }

    public boolean getSign() {
        return (this.expSign & Short.MIN_VALUE) != 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LLVM80BitFloat)) {
            return false;
        }
        LLVM80BitFloat other = (LLVM80BitFloat)obj;
        return this.expSign == other.expSign && this.fraction == other.fraction;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getBytes());
    }

    public byte[] getBytesBigEndian() {
        byte[] array = new byte[10];
        ByteArraySupport.bigEndian().putShort(array, 0, this.expSign);
        ByteArraySupport.bigEndian().putLong(array, 2, this.fraction);
        return array;
    }

    public byte[] getBytes() {
        byte[] array = new byte[10];
        ByteArraySupport.littleEndian().putLong(array, 0, this.fraction);
        ByteArraySupport.littleEndian().putShort(array, 8, this.expSign);
        return array;
    }

    public static LLVM80BitFloat fromBytesBigEndian(byte[] bytes) {
        assert (bytes.length == 10);
        short expSign = ByteArraySupport.bigEndian().getShort(bytes, 0);
        long fraction = ByteArraySupport.bigEndian().getLong(bytes, 2);
        return new LLVM80BitFloat(expSign, fraction);
    }

    public static LLVM80BitFloat fromBytes(byte[] bytes) {
        assert (bytes.length == 10);
        long fraction = ByteArraySupport.littleEndian().getLong(bytes, 0);
        short expSign = ByteArraySupport.littleEndian().getShort(bytes, 8);
        return new LLVM80BitFloat(expSign, fraction);
    }

    public byte getByteValue() {
        if (this.isNaN() || this.isInfinity()) {
            return 0;
        }
        long value = this.getFractionAsLong();
        return (byte)(this.getSign() ? -value : value);
    }

    public short getShortValue() {
        if (this.isNaN() || this.isInfinity()) {
            return 0;
        }
        long value = this.getFractionAsLong();
        return (short)(this.getSign() ? -value : value);
    }

    public int getIntValue() {
        if (this.isNaN() || this.isInfinity()) {
            return Integer.MIN_VALUE;
        }
        int value = (int)this.getFractionAsLong();
        return this.getSign() ? -value : value;
    }

    public long getLongValue() {
        if (this.isNaN() || this.isInfinity()) {
            return Long.MIN_VALUE;
        }
        long value = this.getFractionAsLong();
        return this.getSign() ? -value : value;
    }

    public float getFloatValue() {
        if (this.isPositiveZero()) {
            return 0.0f;
        }
        if (this.isNegativeZero()) {
            return -0.0f;
        }
        if (this.isPositiveInfinity()) {
            return Float.POSITIVE_INFINITY;
        }
        if (this.isNegativeInfinity()) {
            return Float.NEGATIVE_INFINITY;
        }
        if (this.isNaN()) {
            return Float.NaN;
        }
        int floatExponent = this.getUnbiasedExponent() + 127;
        long longFraction = this.getFractionWithoutImplicitZero() >>> 41;
        int floatFraction = (int)longFraction;
        int shiftedSignBit = (this.getSign() ? 1 : 0) << 31;
        int shiftedExponent = floatExponent << 23;
        int rawVal = floatFraction | shiftedExponent | shiftedSignBit;
        return Float.intBitsToFloat(rawVal);
    }

    @Override
    public double toDoubleValue() {
        if (this.isPositiveZero()) {
            return 0.0;
        }
        if (this.isNegativeZero()) {
            return -0.0;
        }
        if (this.isPositiveInfinity()) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.isNegativeInfinity()) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.isNaN()) {
            return Double.NaN;
        }
        int doubleExponent = this.getUnbiasedExponent() + 1023;
        long doubleFraction = this.getFractionWithoutImplicitZero() >>> 12;
        long shiftedSignBit = (this.getSign() ? 1L : 0L) << 63;
        long shiftedExponent = (long)doubleExponent << 52;
        long rawVal = doubleFraction | shiftedExponent | shiftedSignBit;
        return Double.longBitsToDouble(rawVal);
    }

    public LLVM80BitFloat negate() {
        return new LLVM80BitFloat((short)(this.expSign ^ Short.MIN_VALUE), this.fraction);
    }

    public static LLVM80BitFloat fromByte(byte from) {
        return LLVM80BitFloat.fromInt(from);
    }

    public static LLVM80BitFloat fromUnsignedByte(byte from) {
        return LLVM80BitFloat.fromInt(from & 0xFF);
    }

    public static LLVM80BitFloat fromUnsignedShort(short from) {
        return LLVM80BitFloat.fromUnsignedInt(from & 0xFFFF);
    }

    public static LLVM80BitFloat fromShort(short from) {
        return LLVM80BitFloat.fromInt(from);
    }

    @ExplodeLoop
    public static boolean areOrdered(LLVM80BitFloat ... vals) {
        CompilerAsserts.compilationConstant((Object)vals.length);
        for (LLVM80BitFloat val : vals) {
            if (val.isOrdered()) continue;
            return false;
        }
        return true;
    }

    public static int compare(LLVM80BitFloat val1, LLVM80BitFloat val2) {
        return val1.compareOrdered(val2);
    }

    @ExportMessage
    boolean isSerializable() {
        return true;
    }

    @ExportMessage(limit="1")
    void serialize(Object buffer, @CachedLibrary(value="buffer") InteropLibrary interop) {
        try {
            interop.writeBufferLong(buffer, ByteOrder.LITTLE_ENDIAN, 0L, this.fraction);
            interop.writeBufferShort(buffer, ByteOrder.LITTLE_ENDIAN, 8L, this.expSign);
        }
        catch (InvalidBufferOffsetException | UnsupportedMessageException ex) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
        }
    }
}

