/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.constants;

import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.model.symbols.constants.AbstractConstant;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class BlockAddressConstant
extends AbstractConstant {
    private FunctionDefinition function;
    private final int block;

    private BlockAddressConstant(Type type, int block) {
        super(type);
        this.block = block;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public FunctionDefinition getFunction() {
        return this.function;
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.function == original) {
            if (replacement instanceof FunctionDefinition) {
                this.function = (FunctionDefinition)replacement;
            } else {
                throw new LLVMParserException("Illegal symbol for function in BlockAddressConstant: " + String.valueOf(replacement));
            }
        }
    }

    public static BlockAddressConstant fromSymbols(SymbolTable symbols, Type type, int function, int block) {
        BlockAddressConstant constant = new BlockAddressConstant(type, block);
        SymbolImpl functionSymbol = symbols.getForwardReferenced(function, constant);
        if (!(functionSymbol instanceof FunctionDefinition)) {
            throw new LLVMParserException("Illegal symbol for function in BlockAddressConstant: " + String.valueOf(functionSymbol));
        }
        constant.function = (FunctionDefinition)functionSymbol;
        return constant;
    }

    @Override
    public LLVMExpressionNode createNode(LLVMParserRuntime runtime, DataLayout dataLayout, GetStackSpaceFactory stackFactory) {
        LLVMNativePointer blockAddress = LLVMNativePointer.create(this.block);
        PointerType type = new PointerType(null);
        return CommonNodeFactory.createLiteral(blockAddress, type);
    }
}

