/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.factories;

import com.oracle.truffle.api.InternalResource;
import com.oracle.truffle.llvm.parser.factories.BasicAarch64PlatformCapability;
import com.oracle.truffle.llvm.runtime.memory.LLVMSyscallOperationNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMNativeSyscallNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMSyscallExitNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.linux.aarch64.LinuxAArch64Syscall;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.aarch64.linux.LLVMLinuxAarch64VaListStorage;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.aarch64.linux.LLVMLinuxAarch64VaListStorageFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVAListNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVaListStorage;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.Type;

final class LinuxAArch64PlatformCapability
extends BasicAarch64PlatformCapability<LinuxAArch64Syscall> {
    LinuxAArch64PlatformCapability(boolean loadCxxLibraries) {
        super(LinuxAArch64Syscall.class, loadCxxLibraries);
    }

    @Override
    protected LLVMSyscallOperationNode createSyscallNode(LinuxAArch64Syscall syscall) {
        switch (syscall) {
            case SYS_exit: 
            case SYS_exit_group: {
                return new LLVMSyscallExitNode();
            }
        }
        return new LLVMNativeSyscallNode(syscall);
    }

    @Override
    public Object createVAListStorage(LLVMVAListNode allocaNode, LLVMPointer vaListStackPtr, Type vaListType) {
        return new LLVMLinuxAarch64VaListStorage(vaListStackPtr, vaListType);
    }

    @Override
    public Type getGlobalVAListType(Type type) {
        return LLVMLinuxAarch64VaListStorage.VA_LIST_TYPE_14.equals(type) ? LLVMLinuxAarch64VaListStorage.VA_LIST_TYPE_14 : (LLVMLinuxAarch64VaListStorage.VA_LIST_TYPE_12.equals(type) ? LLVMLinuxAarch64VaListStorage.VA_LIST_TYPE_12 : null);
    }

    @Override
    public LLVMVaListStorage.VAListPointerWrapperFactory createNativeVAListWrapper(boolean cached) {
        return cached ? LLVMLinuxAarch64VaListStorageFactory.Aarch64VAListPointerWrapperFactoryNodeGen.create() : LLVMLinuxAarch64VaListStorageFactory.Aarch64VAListPointerWrapperFactoryNodeGen.getUncached();
    }

    @Override
    public InternalResource.OS getOS() {
        return InternalResource.OS.LINUX;
    }

    @Override
    public int getDoubleLongSize() {
        return 128;
    }
}

