/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.elf;

import com.oracle.truffle.llvm.parser.filereader.ObjectFileReader;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import org.graalvm.polyglot.io.ByteSequence;

public final class ElfReader
extends ObjectFileReader {
    private static final int EI_NIDENT = 16;
    private static final int EI_CLASS = 4;
    private static final int EI_DATA = 5;
    private static final int ELFDATA2MSB = 2;
    private static final int ELFCLASS64 = 2;
    private final boolean is64Bit;

    private ElfReader(ByteSequence byteSequence, boolean littleEndian, boolean is64Bit) {
        super(byteSequence, littleEndian);
        this.is64Bit = is64Bit;
        this.setPosition(16);
    }

    static ElfReader create(ByteSequence byteSequence) {
        ElfReader.checkIdent(byteSequence);
        return new ElfReader(byteSequence, !ElfReader.isBigEndian(byteSequence), ElfReader.is64Bit(byteSequence));
    }

    public boolean is64Bit() {
        return this.is64Bit;
    }

    public ByteSequence getStringTable(long offset, long size) {
        return this.byteSequence.subSequence((int)offset, (int)(offset + size));
    }

    private static boolean isBigEndian(ByteSequence ident) {
        return ident.byteAt(5) == 2;
    }

    private static boolean is64Bit(ByteSequence ident) {
        return ident.byteAt(4) == 2;
    }

    private static void checkIdent(ByteSequence ident) {
        ElfReader.checkIndentByte(ident, 0, 127);
        ElfReader.checkIndentByte(ident, 1, 69);
        ElfReader.checkIndentByte(ident, 2, 76);
        ElfReader.checkIndentByte(ident, 3, 70);
    }

    private static void checkIndentByte(ByteSequence ident, int ind, int val) {
        if (ident.byteAt(ind) != val) {
            throw new LLVMParserException("Invalid ELF file!");
        }
    }
}

