/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.NodeFields;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMVarArgCompoundValue;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeChild(type=LLVMExpressionNode.class, value="source")
@NodeFields(value={@NodeField(name="length", type=long.class)})
public abstract class LLVMStructByValueNode
extends LLVMExpressionNode {
    @Node.Child
    private LLVMMemMoveNode memMove;
    @Node.Child
    private LLVMExpressionNode stackAllocationNode;

    public abstract long getLength();

    public LLVMStructByValueNode(LLVMMemMoveNode memMove, LLVMExpressionNode stackAllocationNode) {
        this.memMove = memMove;
        this.stackAllocationNode = stackAllocationNode;
    }

    @Specialization
    protected Object byValue(VirtualFrame frame, LLVMPointer source) {
        return this.byValueImp(frame, source);
    }

    private Object byValueImp(VirtualFrame frame, Object source) {
        Object dest = this.stackAllocationNode.executeGeneric(frame);
        this.memMove.executeWithTarget(frame, dest, source, this.getLength());
        return dest;
    }

    @Specialization
    protected Object byValue(VirtualFrame frame, LLVMVarArgCompoundValue source) {
        return this.byValueImp(frame, source.getAddr());
    }
}

