/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.c;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemSetNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.c.LLVMMemIntrinsic;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMMemIntrinsic.class)
public final class LLVMMemIntrinsicFactory {

    @GeneratedBy(value=LLVMMemIntrinsic.LLVMLibcMemMove.class)
    public static final class LLVMLibcMemMoveNodeGen
    extends LLVMMemIntrinsic.LLVMLibcMemMove
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode dst_;
        @Node.Child
        private LLVMExpressionNode src_;
        @Node.Child
        private LLVMExpressionNode len_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMLibcMemMoveNodeGen(LLVMMemMoveNode memmove, LLVMExpressionNode dst, LLVMExpressionNode src, LLVMExpressionNode len) {
            super(memmove);
            this.dst_ = dst;
            this.src_ = src;
            this.len_ = len;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object dstValue_ = this.dst_.executeGeneric(frameValue);
            Object srcValue_ = this.src_.executeGeneric(frameValue);
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_int0(state_0, frameValue, dstValue_, srcValue_);
            }
            if ((state_0 & 2) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_long1(state_0, frameValue, dstValue_, srcValue_);
            }
            return this.executeGeneric_generic2(state_0, frameValue, dstValue_, srcValue_);
        }

        private Object executeGeneric_int0(int state_0__, VirtualFrame frameValue, Object dstValue_, Object srcValue_) {
            int lenValue_;
            int state_0 = state_0__;
            try {
                lenValue_ = this.len_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, dstValue_, srcValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(frameValue, dstValue_, srcValue_, lenValue_);
            }
            assert ((state_0 & 2) != 0);
            return this.op(frameValue, dstValue_, srcValue_, lenValue_);
        }

        private Object executeGeneric_long1(int state_0__, VirtualFrame frameValue, Object dstValue_, Object srcValue_) {
            long lenValue_;
            int state_0 = state_0__;
            try {
                lenValue_ = this.len_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, dstValue_, srcValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(frameValue, dstValue_, srcValue_, lenValue_);
            }
            assert ((state_0 & 4) != 0);
            return this.op(frameValue, dstValue_, srcValue_, lenValue_);
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue, Object dstValue_, Object srcValue_) {
            int state_0 = state_0__;
            Object lenValue_ = this.len_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(frameValue, dstValue_, srcValue_, lenValue_);
            }
            if ((state_0 & 6) != 0) {
                if ((state_0 & 2) != 0 && lenValue_ instanceof Integer) {
                    int lenValue__ = (Integer)lenValue_;
                    return this.op(frameValue, dstValue_, srcValue_, lenValue__);
                }
                if ((state_0 & 4) != 0 && lenValue_ instanceof Long) {
                    long lenValue__ = (Long)lenValue_;
                    return this.op(frameValue, dstValue_, srcValue_, lenValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, dstValue_, srcValue_, lenValue_);
        }

        private Object executeAndSpecialize(VirtualFrame frameValue, Object dstValue, Object srcValue, Object lenValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (lenValue instanceof Integer) {
                int lenValue_ = (Integer)lenValue;
                this.state_0_ = state_0 |= 2;
                return this.op(frameValue, dstValue, srcValue, lenValue_);
            }
            if (lenValue instanceof Long) {
                long lenValue_ = (Long)lenValue;
                this.state_0_ = state_0 |= 4;
                return this.op(frameValue, dstValue, srcValue, lenValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.dst_, this.src_, this.len_}, new Object[]{dstValue, srcValue, lenValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMMemIntrinsic.LLVMLibcMemMove create(LLVMMemMoveNode memmove, LLVMExpressionNode dst, LLVMExpressionNode src, LLVMExpressionNode len) {
            return new LLVMLibcMemMoveNodeGen(memmove, dst, src, len);
        }
    }

    @GeneratedBy(value=LLVMMemIntrinsic.LLVMLibcMemset.class)
    public static final class LLVMLibcMemsetNodeGen
    extends LLVMMemIntrinsic.LLVMLibcMemset
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode dst_;
        @Node.Child
        private LLVMExpressionNode value_;
        @Node.Child
        private LLVMExpressionNode len_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMLibcMemsetNodeGen(LLVMMemSetNode memset, LLVMExpressionNode dst, LLVMExpressionNode value, LLVMExpressionNode len) {
            super(memset);
            this.dst_ = dst;
            this.value_ = value;
            this.len_ = len;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object dstValue_ = this.dst_.executeGeneric(frameValue);
            if ((state_0 & 0x1C) == 0 && (state_0 & 0x1E) != 0) {
                return this.executeGeneric_int_int0(state_0, frameValue, dstValue_);
            }
            if ((state_0 & 0x1A) == 0 && (state_0 & 0x1E) != 0) {
                return this.executeGeneric_int_long1(state_0, frameValue, dstValue_);
            }
            if ((state_0 & 0x16) == 0 && (state_0 & 0x1E) != 0) {
                return this.executeGeneric_byte_int2(state_0, frameValue, dstValue_);
            }
            if ((state_0 & 0xE) == 0 && (state_0 & 0x1E) != 0) {
                return this.executeGeneric_byte_long3(state_0, frameValue, dstValue_);
            }
            return this.executeGeneric_generic4(state_0, frameValue, dstValue_);
        }

        private Object executeGeneric_int_int0(int state_0__, VirtualFrame frameValue, Object dstValue_) {
            int lenValue_;
            int valueValue_;
            int state_0 = state_0__;
            try {
                valueValue_ = this.value_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object lenValue = this.len_.executeGeneric(frameValue);
                return this.executeAndSpecialize(dstValue_, ex.getResult(), lenValue);
            }
            try {
                lenValue_ = this.len_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(dstValue_, valueValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(dstValue_, valueValue_, lenValue_);
            }
            assert ((state_0 & 2) != 0);
            return this.op(dstValue_, valueValue_, lenValue_);
        }

        private Object executeGeneric_int_long1(int state_0__, VirtualFrame frameValue, Object dstValue_) {
            long lenValue_;
            int valueValue_;
            int state_0 = state_0__;
            try {
                valueValue_ = this.value_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object lenValue = this.len_.executeGeneric(frameValue);
                return this.executeAndSpecialize(dstValue_, ex.getResult(), lenValue);
            }
            try {
                lenValue_ = this.len_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(dstValue_, valueValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(dstValue_, valueValue_, lenValue_);
            }
            assert ((state_0 & 4) != 0);
            return this.op(dstValue_, valueValue_, lenValue_);
        }

        private Object executeGeneric_byte_int2(int state_0__, VirtualFrame frameValue, Object dstValue_) {
            int lenValue_;
            byte valueValue_;
            int state_0 = state_0__;
            try {
                valueValue_ = this.value_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object lenValue = this.len_.executeGeneric(frameValue);
                return this.executeAndSpecialize(dstValue_, ex.getResult(), lenValue);
            }
            try {
                lenValue_ = this.len_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(dstValue_, valueValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(dstValue_, valueValue_, lenValue_);
            }
            assert ((state_0 & 8) != 0);
            return this.op(dstValue_, valueValue_, lenValue_);
        }

        private Object executeGeneric_byte_long3(int state_0__, VirtualFrame frameValue, Object dstValue_) {
            long lenValue_;
            byte valueValue_;
            int state_0 = state_0__;
            try {
                valueValue_ = this.value_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object lenValue = this.len_.executeGeneric(frameValue);
                return this.executeAndSpecialize(dstValue_, ex.getResult(), lenValue);
            }
            try {
                lenValue_ = this.len_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(dstValue_, valueValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(dstValue_, valueValue_, lenValue_);
            }
            assert ((state_0 & 0x10) != 0);
            return this.op(dstValue_, valueValue_, lenValue_);
        }

        private Object executeGeneric_generic4(int state_0__, VirtualFrame frameValue, Object dstValue_) {
            int state_0 = state_0__;
            Object valueValue_ = this.value_.executeGeneric(frameValue);
            Object lenValue_ = this.len_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(dstValue_, valueValue_, lenValue_);
            }
            if ((state_0 & 0x1E) != 0) {
                if ((state_0 & 6) != 0 && valueValue_ instanceof Integer) {
                    int n = (Integer)valueValue_;
                    if ((state_0 & 2) != 0 && lenValue_ instanceof Integer) {
                        int lenValue__ = (Integer)lenValue_;
                        return this.op(dstValue_, n, lenValue__);
                    }
                    if ((state_0 & 4) != 0 && lenValue_ instanceof Long) {
                        long lenValue__ = (Long)lenValue_;
                        return this.op(dstValue_, n, lenValue__);
                    }
                }
                if ((state_0 & 0x18) != 0 && valueValue_ instanceof Byte) {
                    byte by = (Byte)valueValue_;
                    if ((state_0 & 8) != 0 && lenValue_ instanceof Integer) {
                        int lenValue__ = (Integer)lenValue_;
                        return this.op(dstValue_, by, lenValue__);
                    }
                    if ((state_0 & 0x10) != 0 && lenValue_ instanceof Long) {
                        long lenValue__ = (Long)lenValue_;
                        return this.op(dstValue_, by, lenValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(dstValue_, valueValue_, lenValue_);
        }

        private Object executeAndSpecialize(Object dstValue, Object valueValue, Object lenValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (valueValue instanceof Integer) {
                int n = (Integer)valueValue;
                if (lenValue instanceof Integer) {
                    int lenValue_ = (Integer)lenValue;
                    this.state_0_ = state_0 |= 2;
                    return this.op(dstValue, n, lenValue_);
                }
                if (lenValue instanceof Long) {
                    long lenValue_ = (Long)lenValue;
                    this.state_0_ = state_0 |= 4;
                    return this.op(dstValue, n, lenValue_);
                }
            }
            if (valueValue instanceof Byte) {
                byte by = (Byte)valueValue;
                if (lenValue instanceof Integer) {
                    int lenValue_ = (Integer)lenValue;
                    this.state_0_ = state_0 |= 8;
                    return this.op(dstValue, by, lenValue_);
                }
                if (lenValue instanceof Long) {
                    long lenValue_ = (Long)lenValue;
                    this.state_0_ = state_0 |= 0x10;
                    return this.op(dstValue, by, lenValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.dst_, this.value_, this.len_}, new Object[]{dstValue, valueValue, lenValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMMemIntrinsic.LLVMLibcMemset create(LLVMMemSetNode memset, LLVMExpressionNode dst, LLVMExpressionNode value, LLVMExpressionNode len) {
            return new LLVMLibcMemsetNodeGen(memset, dst, value, len);
        }
    }
}

