/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMBitcodeLibraryFunctions;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.except.LLVMUserException;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.List;

@NodeChildren(value={@NodeChild(value="exceptionObject", type=LLVMExpressionNode.class), @NodeChild(value="throwInfo", type=LLVMExpressionNode.class)})
public abstract class LLVMRaiseExceptionWindows
extends LLVMExpressionNode {
    @Node.Child
    private LLVMBitcodeLibraryFunctions.SulongEHUnwindWindowsNode unwindNode;

    public LLVMBitcodeLibraryFunctions.SulongEHUnwindWindowsNode getUnwind() {
        if (this.unwindNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.unwindNode = (LLVMBitcodeLibraryFunctions.SulongEHUnwindWindowsNode)this.insert(new LLVMBitcodeLibraryFunctions.SulongEHUnwindWindowsNode(this.getContext()));
        }
        return this.unwindNode;
    }

    @Specialization(guards={"throwInfo.isNull()", "exceptionObject.isNull()"})
    public Object doNull(LLVMPointer exceptionObject, LLVMPointer throwInfo) {
        throw ((LLVMLanguage.LLVMThreadLocalValue)this.getLanguage().contextThreadLocal.get()).popException();
    }

    protected void unwindCurrentException(LLVMStack stack) {
        LLVMLanguage.LLVMThreadLocalValue threadLocal = (LLVMLanguage.LLVMThreadLocalValue)this.getLanguage().contextThreadLocal.get();
        if (threadLocal.hasException()) {
            LLVMUserException.LLVMUserExceptionWindows exception = (LLVMUserException.LLVMUserExceptionWindows)threadLocal.popException();
            this.getUnwind().unwind(stack, exception.getExceptionObject(), exception.getThrowInfo(), exception.getImageBase());
        }
    }

    @Specialization(guards={"!throwInfo.isNull()", "throwInfo.isSame(cachedThrowInfo)"}, limit="3")
    public Object doRaise(LLVMPointer exceptionObject, LLVMPointer throwInfo, @Cached(value="throwInfo") LLVMPointer cachedThrowInfo, @Cached(value="getImageBase(cachedThrowInfo)") LLVMPointer imageBase) {
        LLVMStack stack = this.getContext().getThreadingStack().getStack(this);
        this.unwindCurrentException(stack);
        throw new LLVMUserException.LLVMUserExceptionWindows(this, imageBase, exceptionObject, cachedThrowInfo, stack.getStackPointer());
    }

    @Specialization(guards={"!throwInfo.isNull()"}, replaces={"doRaise"})
    public Object doFallback(LLVMPointer exceptionObject, LLVMPointer throwInfo) {
        LLVMStack stack = this.getContext().getThreadingStack().getStack(this);
        this.unwindCurrentException(stack);
        throw new LLVMUserException.LLVMUserExceptionWindows(this, this.getImageBase(throwInfo), exceptionObject, throwInfo, stack.getStackPointer());
    }

    @CompilerDirectives.TruffleBoundary
    protected LLVMPointer getImageBase(LLVMPointer throwInfo) {
        List<LLVMSymbol> symbols = this.getContext().findSymbols(throwInfo);
        assert (symbols.stream().allMatch(symb -> symb == symbols.get(0)));
        if (symbols.isEmpty()) {
            throw new LLVMParserException((Node)this, "Could not find exception throw info symbol.", new Object[0]);
        }
        return this.getContext().getGlobalsBase(symbols.get(0).getBitcodeIDUncached());
    }
}

