/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

public class LLVMAMD64BarrelShifter {
    private static final int MASK_8 = 7;
    private static final int MASK_16 = 15;
    private static final int MASK_32 = 31;
    private static final int MASK_64 = 63;

    public static byte rol(byte x, byte n) {
        int shift = n & 7;
        return (byte)(x << shift | (x & 0xFF) >>> 8 - shift);
    }

    public static short rol(short x, short n) {
        int shift = n & 0xF;
        return (short)(x << shift | (x & 0xFFFF) >>> 16 - shift);
    }

    public static int rol(int x, int n) {
        int shift = n & 0x1F;
        return x << shift | x >>> 32 - shift;
    }

    public static long rol(long x, long n) {
        int shift = (int)(n & 0x3FL);
        return x << shift | x >>> 64 - shift;
    }

    public static byte ror(byte x, byte n) {
        int shift = n & 7;
        return (byte)((x & 0xFF) >>> shift | x << 8 - shift);
    }

    public static short ror(short x, short n) {
        int shift = n & 0xF;
        return (short)((x & 0xFFFF) >>> shift | x << 16 - shift);
    }

    public static int ror(int x, int n) {
        int shift = n & 0x1F;
        return x >>> shift | x << 32 - shift;
    }

    public static long ror(long x, long n) {
        int shift = (int)(n & 0x3FL);
        return x >>> shift | x << 64 - shift;
    }
}

