/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64UpdateFlagsNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteTupelNode;

@NodeChildren(value={@NodeChild(value="left", type=LLVMExpressionNode.class), @NodeChild(value="right", type=LLVMExpressionNode.class)})
public abstract class LLVMAMD64XaddNode
extends LLVMStatementNode {
    @Node.Child
    protected LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode flags;
    @Node.Child
    protected LLVMAMD64WriteTupelNode out;

    private LLVMAMD64XaddNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode flags, LLVMAMD64WriteTupelNode out) {
        this.flags = flags;
        this.out = out;
    }

    public static abstract class LLVMAMD64XaddqNode
    extends LLVMAMD64XaddNode {
        public LLVMAMD64XaddqNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode flags, LLVMAMD64WriteTupelNode out) {
            super(flags, out);
        }

        @Specialization
        protected void doOp(VirtualFrame frame, long left, long right) {
            long result = left + right;
            boolean overflow = result < 0L && left > 0L && right > 0L || result > 0L && left < 0L && right < 0L;
            boolean carry = (left < 0L || right < 0L) && result > 0L || left < 0L && right < 0L;
            this.flags.execute(frame, overflow, carry, result);
            this.out.execute(frame, right, result);
        }
    }

    public static abstract class LLVMAMD64XaddlNode
    extends LLVMAMD64XaddNode {
        public LLVMAMD64XaddlNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode flags, LLVMAMD64WriteTupelNode out) {
            super(flags, out);
        }

        @Specialization
        protected void doOp(VirtualFrame frame, int left, int right) {
            int result = left + right;
            boolean overflow = result < 0 && left > 0 && right > 0 || result > 0 && left < 0 && right < 0;
            boolean carry = (left < 0 || right < 0) && result > 0 || left < 0 && right < 0;
            this.flags.execute(frame, overflow, carry, result);
            this.out.execute(frame, right, result);
        }
    }

    public static abstract class LLVMAMD64XaddwNode
    extends LLVMAMD64XaddNode {
        public LLVMAMD64XaddwNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode flags, LLVMAMD64WriteTupelNode out) {
            super(flags, out);
        }

        @Specialization
        protected void doOp(VirtualFrame frame, short left, short right) {
            short result = (short)(left + right);
            boolean overflow = result < 0 && left > 0 && right > 0 || result > 0 && left < 0 && right < 0;
            boolean carry = (left < 0 || right < 0) && result > 0 || left < 0 && right < 0;
            this.flags.execute(frame, overflow, carry, result);
            this.out.execute(frame, right, result);
        }
    }

    public static abstract class LLVMAMD64XaddbNode
    extends LLVMAMD64XaddNode {
        public LLVMAMD64XaddbNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode flags, LLVMAMD64WriteTupelNode out) {
            super(flags, out);
        }

        @Specialization
        protected void doOp(VirtualFrame frame, byte left, byte right) {
            byte result = (byte)(left + right);
            boolean overflow = result < 0 && left > 0 && right > 0 || result > 0 && left < 0 && right < 0;
            boolean carry = (left < 0 || right < 0) && result > 0 || left < 0 && right < 0;
            this.flags.execute(frame, overflow, carry, result);
            this.out.execute(frame, right, result);
        }
    }
}

