/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.blocks.InstructionBlock;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.TerminatingInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.VoidInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;

public final class IndirectBranchInstruction
extends VoidInstruction
implements TerminatingInstruction {
    private SymbolImpl address;
    private final InstructionBlock[] successors;

    private IndirectBranchInstruction(InstructionBlock[] successors) {
        this.successors = successors;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public SymbolImpl getAddress() {
        return this.address;
    }

    @Override
    public int getSuccessorCount() {
        return this.successors.length;
    }

    @Override
    public InstructionBlock getSuccessor(int index) {
        return this.successors[index];
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.address == original) {
            this.address = replacement;
        }
    }

    public static IndirectBranchInstruction generate(FunctionDefinition function, SymbolTable symbols, int address, int[] successors) {
        InstructionBlock[] blocks = new InstructionBlock[successors.length];
        for (int i = 0; i < successors.length; ++i) {
            blocks[i] = function.getBlock(successors[i]);
        }
        IndirectBranchInstruction inst = new IndirectBranchInstruction(blocks);
        inst.address = symbols.getForwardReferenced(address, inst);
        return inst;
    }
}

