/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;

public final class MDGlobalVariableExpression
implements MDBaseNode {
    private static final int ARGINDEX_VARIABLE = 1;
    private static final int ARGINDEX_EXPRESSION = 2;
    private MDBaseNode globalVariable = MDVoidNode.INSTANCE;
    private MDBaseNode expression = MDVoidNode.INSTANCE;

    private MDGlobalVariableExpression() {
    }

    public static MDGlobalVariableExpression create(long[] args, MetadataValueList md) {
        MDGlobalVariableExpression expression = new MDGlobalVariableExpression();
        expression.globalVariable = md.getNullable(args[1], expression);
        expression.expression = md.getNullable(args[2], expression);
        return expression;
    }

    public MDBaseNode getGlobalVariable() {
        return this.globalVariable;
    }

    public MDBaseNode getExpression() {
        return this.expression;
    }

    @Override
    public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
        if (this.globalVariable == oldValue) {
            this.globalVariable = newValue;
        }
        if (this.expression == oldValue) {
            this.expression = newValue;
        }
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }
}

