/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.pthread;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading.LLVMThreadStart;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class LLVMPThreadContext {
    private final TruffleLanguage.Env env;
    private final Object threadLock;
    private final ConcurrentMap<Long, Object> threadReturnValueStorage;
    private final ConcurrentMap<Long, WeakReference<Thread>> threadStorage;
    private volatile boolean isCreateThreadAllowed;
    private int pThreadKey;
    private final Object pThreadKeyLock;
    private final ConcurrentMap<Integer, ConcurrentMap<Long, LLVMPointer>> pThreadKeyStorage;
    private final ConcurrentMap<Integer, LLVMPointer> pThreadDestructorStorage;
    private final CallTarget pthreadCallTarget;

    public LLVMPThreadContext(TruffleLanguage.Env env, LLVMLanguage language, DataLayout dataLayout) {
        this.env = env;
        this.threadLock = new Object();
        this.threadReturnValueStorage = new ConcurrentHashMap<Long, Object>();
        this.threadStorage = new ConcurrentHashMap<Long, WeakReference<Thread>>();
        this.pThreadKey = 0;
        this.pThreadKeyLock = new Object();
        this.pThreadKeyStorage = new ConcurrentHashMap<Integer, ConcurrentMap<Long, LLVMPointer>>();
        this.pThreadDestructorStorage = new ConcurrentHashMap<Integer, LLVMPointer>();
        this.pthreadCallTarget = language.createCachedCallTarget(LLVMThreadStart.LLVMPThreadFunctionRootNode.class, l -> LLVMThreadStart.LLVMPThreadFunctionRootNode.create(l, l.getActiveConfiguration().createNodeFactory((LLVMLanguage)((Object)l), dataLayout)));
        this.isCreateThreadAllowed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void joinAllThreads() {
        Collection threads;
        Iterator iterator = this.threadLock;
        synchronized (iterator) {
            this.isCreateThreadAllowed = false;
            threads = this.threadStorage.values();
        }
        for (WeakReference thread : threads) {
            try {
                Thread t = (Thread)thread.get();
                if (t == null) continue;
                t.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createPThreadKey(LLVMPointer destructor) {
        Object object = this.pThreadKeyLock;
        synchronized (object) {
            ++this.pThreadKey;
            this.registerPThreadKey(this.pThreadKey, destructor);
            return this.pThreadKey;
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void registerPThreadKey(int key, LLVMPointer destructor) {
        this.pThreadDestructorStorage.put(key, destructor);
        this.pThreadKeyStorage.put(key, new ConcurrentHashMap());
    }

    public int getNumberOfPthreadKeys() {
        return this.pThreadKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void deletePThreadKey(int keyId) {
        Object object = this.pThreadKeyLock;
        synchronized (object) {
            this.pThreadKeyStorage.remove(keyId);
            this.pThreadDestructorStorage.remove(keyId);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMPointer getSpecific(int keyId) {
        ConcurrentMap value = (ConcurrentMap)this.pThreadKeyStorage.get(keyId);
        if (value != null) {
            long threadId = Thread.currentThread().getId();
            return (LLVMPointer)value.get(threadId);
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean setSpecific(int keyId, LLVMPointer value) {
        ConcurrentMap specificStore = (ConcurrentMap)this.pThreadKeyStorage.get(keyId);
        if (specificStore != null) {
            specificStore.put(Thread.currentThread().getId(), value);
            return true;
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMPointer getAndRemoveSpecificUnlessNull(int keyId) {
        return this.getAndRemoveSpecificUnlessNull(keyId, Thread.currentThread().getId());
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMPointer getAndRemoveSpecificUnlessNull(int keyId, long threadId) {
        LLVMPointer keyMapping;
        ConcurrentMap value = (ConcurrentMap)this.pThreadKeyStorage.get(keyId);
        if (value != null && (keyMapping = (LLVMPointer)value.get(threadId)) != null && !keyMapping.isNull()) {
            value.remove(threadId);
            return keyMapping;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMPointer getDestructor(int keyId) {
        return (LLVMPointer)this.pThreadDestructorStorage.get(keyId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public Thread createThread(Runnable runnable) {
        Object object = this.threadLock;
        synchronized (object) {
            if (this.isCreateThreadAllowed) {
                Thread thread = this.env.newTruffleThreadBuilder(runnable).build();
                this.threadStorage.put(thread.getId(), new WeakReference<Thread>(thread));
                return thread;
            }
            return null;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public Thread getThread(long threadID) {
        WeakReference thread = (WeakReference)this.threadStorage.get(threadID);
        if (thread == null) {
            return null;
        }
        return (Thread)thread.get();
    }

    @CompilerDirectives.TruffleBoundary
    public void clearThreadID(long threadID) {
        this.threadStorage.remove(threadID);
    }

    @CompilerDirectives.TruffleBoundary
    public void setThreadReturnValue(long threadID, Object value) {
        this.threadReturnValueStorage.put(threadID, value);
    }

    @CompilerDirectives.TruffleBoundary
    public Object getThreadReturnValue(long threadID) {
        return this.threadReturnValueStorage.get(threadID);
    }

    @CompilerDirectives.TruffleBoundary
    public void clearThreadReturnValue(long threadID) {
        this.threadReturnValueStorage.remove(threadID);
    }

    public CallTarget getPthreadCallTarget() {
        return this.pthreadCallTarget;
    }

    public void callDestructors(LLVMContext context) {
        this.callDestructors(context, Thread.currentThread().getId());
    }

    public void callDestructors(LLVMContext context, long threadId) {
        for (int key = 1; key <= this.getNumberOfPthreadKeys(); ++key) {
            LLVMPointer keyMapping;
            LLVMPointer destructor = this.getDestructor(key);
            if (destructor == null || destructor.isNull() || (keyMapping = this.getAndRemoveSpecificUnlessNull(key, threadId)) == null) continue;
            if (context.isFinalized()) {
                throw new LLVMPolyglotException(null, "Tried to call a pthread destructor, but the LLVMContext has already been finalized. Ensure that the context is still alive and that the thread was created using the Truffle API.");
            }
            assert (!keyMapping.isNull());
            this.getPthreadCallTarget().call(new Object[]{destructor, keyMapping});
        }
    }
}

