/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.CountingConditionProfile;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMCopyTargetLibrary;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.ManagedMemMoveHelperNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.ManagedMemMoveHelperNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GenerateUncached
public abstract class NativeProfiledMemMove
extends LLVMNode
implements LLVMMemMoveNode {
    protected static final long MAX_JAVA_LEN = 256L;

    private static void copyForward(LLVMPointer target, LLVMPointer source, long length, ManagedMemMoveHelperNode helper, ManagedMemMoveHelperNode.UnitSizeNode unitSizeNode) {
        int unitSize = unitSizeNode.execute(helper, length);
        for (long i = 0L; i < length; i += (long)unitSize) {
            helper.execute(target.increment(i), source.increment(i), unitSize);
        }
    }

    private static void copyBackward(LLVMPointer target, LLVMPointer source, long length, ManagedMemMoveHelperNode helper, ManagedMemMoveHelperNode.UnitSizeNode unitSizeNode) {
        int unitSize = unitSizeNode.execute(helper, length);
        for (long i = length - (long)unitSize; i >= 0L; i -= (long)unitSize) {
            helper.execute(target.increment(i), source.increment(i), unitSize);
        }
    }

    static boolean doCustomCopy(LLVMManagedPointer target, LLVMManagedPointer source, long length, LLVMCopyTargetLibrary copyTargetLib) {
        return source.getOffset() == 0L && target.getOffset() == 0L && copyTargetLib.canCopyFrom(target.getObject(), source.getObject(), length);
    }

    static boolean doCustomCopy(LLVMManagedPointer target, LLVMNativePointer source, long length, LLVMCopyTargetLibrary copyTargetLib) {
        return target.getOffset() == 0L && copyTargetLib.canCopyFrom(target.getObject(), source, length);
    }

    @Specialization(limit="8", guards={"target.getObject() != source.getObject()", "doCustomCopy(target, source, length, copyTargetLib)"})
    protected void doManagedCustomCopy(LLVMManagedPointer target, LLVMManagedPointer source, long length, @CachedLibrary(value="target.getObject()") LLVMCopyTargetLibrary copyTargetLib) {
        copyTargetLib.copyFrom(target.getObject(), source.getObject(), length);
    }

    @Specialization(limit="8", guards={"helper.guard(target, source)", "target.getObject() != source.getObject()", "!doCustomCopy(target, source, length, copyTargetLib)"})
    protected void doManagedNonAliasing(LLVMManagedPointer target, LLVMManagedPointer source, long length, @Cached(value="create(target, source)") ManagedMemMoveHelperNode helper, @Cached ManagedMemMoveHelperNode.UnitSizeNode unitSizeNode, @CachedLibrary(value="target.getObject()") LLVMCopyTargetLibrary copyTargetLib) {
        NativeProfiledMemMove.copyForward(target, source, length, helper, unitSizeNode);
    }

    @Specialization(limit="8", guards={"helper.guard(target, source)", "target.getObject() == source.getObject()", "!doCustomCopy(target, source, length, copyTargetLib)"})
    protected void doManagedAliasing(LLVMManagedPointer target, LLVMManagedPointer source, long length, @Cached(value="create(target, source)") ManagedMemMoveHelperNode helper, @Cached ManagedMemMoveHelperNode.UnitSizeNode unitSizeNode, @Cached CountingConditionProfile canCopyForward, @CachedLibrary(value="target.getObject()") LLVMCopyTargetLibrary copyTargetLib) {
        if (canCopyForward.profile(Long.compareUnsigned(target.getOffset() - source.getOffset(), length) >= 0)) {
            NativeProfiledMemMove.copyForward(target, source, length, helper, unitSizeNode);
        } else {
            NativeProfiledMemMove.copyBackward(target, source, length, helper, unitSizeNode);
        }
    }

    @Specialization(limit="4", guards={"helper.guard(target, source)", "!doCustomCopy(target, source, length, copyTargetLib)"})
    protected void doManagedNative(LLVMManagedPointer target, LLVMNativePointer source, long length, @Cached(value="create(target, source)") ManagedMemMoveHelperNode helper, @Cached ManagedMemMoveHelperNode.UnitSizeNode unitSizeNode, @CachedLibrary(value="target.getObject()") LLVMCopyTargetLibrary copyTargetLib) {
        NativeProfiledMemMove.copyForward(target, source, length, helper, unitSizeNode);
    }

    @Specialization(limit="4", guards={"doCustomCopy(target, source, length, copyTargetLib)"})
    protected void doManagedNativeCustomCopy(LLVMManagedPointer target, LLVMNativePointer source, long length, @CachedLibrary(value="target.getObject()") LLVMCopyTargetLibrary copyTargetLib) {
        copyTargetLib.copyFrom(target.getObject(), source, length);
    }

    @Specialization(limit="4", guards={"helper.guard(target, source)"})
    protected void doNativeManaged(LLVMNativePointer target, LLVMManagedPointer source, long length, @Cached(value="create(target, source)") ManagedMemMoveHelperNode helper, @Cached ManagedMemMoveHelperNode.UnitSizeNode unitSizeNode) {
        NativeProfiledMemMove.copyForward(target, source, length, helper, unitSizeNode);
    }

    static boolean isManaged(LLVMPointer ptr) {
        return LLVMManagedPointer.isInstance(ptr);
    }

    @Specialization(guards={"isManaged(target) || isManaged(source)"}, replaces={"doManagedNonAliasing", "doManagedCustomCopy", "doManagedAliasing", "doManagedNative", "doManagedNativeCustomCopy", "doNativeManaged"})
    @CompilerDirectives.TruffleBoundary
    protected void doManagedSlowPath(LLVMPointer target, LLVMPointer source, long length) {
        ManagedMemMoveHelperNode helper = ManagedMemMoveHelperNode.createSlowPath(target, source);
        ManagedMemMoveHelperNode.UnitSizeNode unitSizeNode = ManagedMemMoveHelperNodeGen.UnitSizeNodeGen.create();
        LLVMCopyTargetLibrary copyTargetLib = (LLVMCopyTargetLibrary)LLVMCopyTargetLibrary.getFactory().getUncached();
        if (LLVMManagedPointer.isInstance(target) && LLVMManagedPointer.isInstance(source)) {
            this.doManagedAliasing(LLVMManagedPointer.cast(target), LLVMManagedPointer.cast(source), length, helper, unitSizeNode, CountingConditionProfile.getUncached(), copyTargetLib);
        } else if (LLVMManagedPointer.isInstance(target) && LLVMManagedPointer.isInstance(source) && NativeProfiledMemMove.doCustomCopy(LLVMManagedPointer.cast(target), LLVMManagedPointer.cast(source), length, copyTargetLib)) {
            copyTargetLib.copyFrom(LLVMManagedPointer.cast(target).getObject(), LLVMManagedPointer.cast(source).getObject(), length);
        } else if (LLVMManagedPointer.isInstance(target) && LLVMNativePointer.isInstance(source) && NativeProfiledMemMove.doCustomCopy(LLVMManagedPointer.cast(target), LLVMNativePointer.cast(source), length, copyTargetLib)) {
            copyTargetLib.copyFrom(LLVMManagedPointer.cast(target).getObject(), source, length);
        } else {
            NativeProfiledMemMove.copyForward(target, source, length, helper, unitSizeNode);
        }
    }

    @Specialization(guards={"length <= MAX_JAVA_LEN"})
    protected void doInJava(Object target, Object source, long length, @Cached LLVMToNativeNode convertTarget, @Cached LLVMToNativeNode convertSource) {
        LLVMMemory memory = this.getLanguage().getLLVMMemory();
        LLVMNativePointer t = convertTarget.executeWithTarget(target);
        LLVMNativePointer s = convertSource.executeWithTarget(source);
        long targetPointer = t.asNative();
        long sourcePointer = s.asNative();
        if (CompilerDirectives.injectBranchProbability((double)0.75, (length > 0L && sourcePointer != targetPointer ? (byte)1 : 0) != 0)) {
            if (CompilerDirectives.injectBranchProbability((double)0.75, (Long.compareUnsigned(targetPointer - sourcePointer, length) >= 0 ? (byte)1 : 0) != 0)) {
                this.copyForward(memory, targetPointer, sourcePointer, length);
            } else {
                this.copyBackward(memory, targetPointer, sourcePointer, length);
            }
        }
    }

    @Specialization(replaces={"doInJava"})
    protected void doNative(Object target, Object source, long length, @Cached LLVMToNativeNode convertTarget, @Cached LLVMToNativeNode convertSource) {
        this.getLanguage().getLLVMMemory().copyMemory(this, convertSource.executeWithTarget(source).asNative(), convertTarget.executeWithTarget(target).asNative(), length);
    }

    private void copyForward(LLVMMemory memory, long target, long source, long length) {
        long targetPointer = target;
        long sourcePointer = source;
        long i64ValuesToWrite = length >> 3;
        long i = 0L;
        while (CompilerDirectives.injectBranchProbability((double)0.75, (i < i64ValuesToWrite ? (byte)1 : 0) != 0)) {
            long v64 = memory.getI64((Node)this, sourcePointer);
            memory.putI64((Node)this, targetPointer, v64);
            targetPointer += 8L;
            sourcePointer += 8L;
            ++i;
        }
        long i8ValuesToWrite = length & 7L;
        long i2 = 0L;
        while (CompilerDirectives.injectBranchProbability((double)0.75, (i2 < i8ValuesToWrite ? (byte)1 : 0) != 0)) {
            byte value = memory.getI8((Node)this, sourcePointer);
            memory.putI8((Node)this, targetPointer, value);
            ++targetPointer;
            ++sourcePointer;
            ++i2;
        }
    }

    private void copyBackward(LLVMMemory memory, long target, long source, long length) {
        long targetPointer = target + length;
        long sourcePointer = source + length;
        long i64ValuesToWrite = length >> 3;
        long i = 0L;
        while (CompilerDirectives.injectBranchProbability((double)0.75, (i < i64ValuesToWrite ? (byte)1 : 0) != 0)) {
            long v64 = memory.getI64((Node)this, sourcePointer -= 8L);
            memory.putI64((Node)this, targetPointer -= 8L, v64);
            ++i;
        }
        long i8ValuesToWrite = length & 7L;
        long i2 = 0L;
        while (CompilerDirectives.injectBranchProbability((double)0.75, (i2 < i8ValuesToWrite ? (byte)1 : 0) != 0)) {
            byte value = memory.getI8((Node)this, --sourcePointer);
            memory.putI8((Node)this, --targetPointer, value);
            ++i2;
        }
    }
}

