/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemSetNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemoryOpNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMMemoryIntrinsicFactory;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMMemoryIntrinsic
extends LLVMExpressionNode {

    @GenerateUncached
    public static abstract class LLVMFreeOpNode
    extends LLVMNode
    implements LLVMMemoryOpNode {
        @Specialization(guards={"address.isNull()"})
        protected void doNull(LLVMNativePointer address) {
        }

        @Specialization
        protected void doVoid(LLVMNativePointer address) {
            this.getLanguage().getLLVMMemory().free((Node)this, address);
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMFree
    extends LLVMMemoryIntrinsic
    implements LLVMMemoryOpNode {
        @Specialization(guards={"address.isNull()"})
        protected Object doNull(LLVMNativePointer address) {
            return null;
        }

        @Specialization
        protected Object doVoid(LLVMNativePointer address) {
            this.getLanguage().getLLVMMemory().free((Node)this, address);
            return null;
        }
    }

    @NodeChild(value="memptr", type=LLVMExpressionNode.class)
    public static abstract class LLVMPosixMemalign
    extends LLVMMemoryIntrinsic {
        @Node.Child
        private LLVMPointerStoreNode writePointer = LLVMPointerStoreNode.create();
        @Node.Child
        private LLVMAlignedAlloc alignedAlloc;

        public static LLVMPosixMemalign create(LLVMExpressionNode memptr, LLVMExpressionNode alignment, LLVMExpressionNode size) {
            return LLVMMemoryIntrinsicFactory.LLVMPosixMemalignNodeGen.create(alignment, size, memptr);
        }

        LLVMPosixMemalign(LLVMExpressionNode alignment, LLVMExpressionNode size) {
            this.alignedAlloc = LLVMMemoryIntrinsicFactory.LLVMAlignedAllocNodeGen.create(alignment, size);
        }

        @Specialization
        protected int doVoid(VirtualFrame frame, LLVMPointer memptr) {
            LLVMPointer ret = this.alignedAlloc.execute(frame);
            if (ret.isNull()) {
                return 1;
            }
            this.writePointer.executeWithTarget(memptr, (Object)ret);
            return 0;
        }
    }

    @NodeChildren(value={@NodeChild(value="alignment", type=LLVMExpressionNode.class), @NodeChild(value="size", type=LLVMExpressionNode.class)})
    public static abstract class LLVMAlignedAlloc
    extends LLVMMemoryIntrinsic {
        abstract LLVMPointer execute(VirtualFrame var1);

        @Specialization
        LLVMPointer doAlloc(long alignment, long size, @Cached BranchProfile outOfMemory) {
            try {
                LLVMNativePointer address = this.getLanguage().getLLVMMemory().allocateMemory(this, size);
                assert ((address.asNative() & alignment - 1L) == 0L) : "Memory allocation alignment is not 16 bytes.";
                return address;
            }
            catch (ArithmeticException | OutOfMemoryError e) {
                outOfMemory.enter();
                return LLVMNativePointer.createNull();
            }
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMRealloc
    extends LLVMMemoryIntrinsic {
        public abstract LLVMNativePointer executeWithTarget(LLVMNativePointer var1, Object var2);

        @Specialization
        protected LLVMNativePointer doVoid(LLVMNativePointer addr, int size, @Cached BranchProfile outOfMemory) {
            return this.doVoid(addr, (long)size, outOfMemory);
        }

        @Specialization
        protected LLVMNativePointer doVoid(LLVMNativePointer addr, long size, @Cached BranchProfile outOfMemory) {
            try {
                return this.getLanguage().getLLVMMemory().reallocateMemory(this, addr, size);
            }
            catch (OutOfMemoryError e) {
                outOfMemory.enter();
                return LLVMNativePointer.createNull();
            }
        }

        public static LLVMRealloc create() {
            return LLVMMemoryIntrinsicFactory.LLVMReallocNodeGen.create(null, null);
        }
    }

    @NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class), @NodeChild(type=LLVMExpressionNode.class)})
    public static abstract class LLVMCalloc
    extends LLVMMemoryIntrinsic {
        @Node.Child
        private LLVMMemSetNode memSet;

        public LLVMCalloc(LLVMMemSetNode memSet) {
            this.memSet = memSet;
        }

        @Specialization
        protected LLVMNativePointer doVoid(int n, int size, @Cached BranchProfile outOfMemory) {
            try {
                long length = Math.multiplyExact(n, size);
                LLVMNativePointer address = this.getLanguage().getLLVMMemory().allocateMemory(this, length);
                this.memSet.executeWithTarget(address, (byte)0, length);
                return address;
            }
            catch (ArithmeticException | OutOfMemoryError e) {
                outOfMemory.enter();
                return LLVMNativePointer.createNull();
            }
        }

        @Specialization
        protected LLVMNativePointer doVoid(long n, long size, @Cached BranchProfile outOfMemory) {
            try {
                long length = Math.multiplyExact(n, size);
                LLVMNativePointer address = this.getLanguage().getLLVMMemory().allocateMemory(this, length);
                this.memSet.executeWithTarget(address, (byte)0, length);
                return address;
            }
            catch (ArithmeticException | OutOfMemoryError e) {
                outOfMemory.enter();
                return LLVMNativePointer.createNull();
            }
        }
    }

    @NodeChild(type=LLVMExpressionNode.class)
    public static abstract class LLVMMalloc
    extends LLVMMemoryIntrinsic {
        @Specialization
        protected LLVMNativePointer doVoid(int size, @Cached BranchProfile outOfMemory) {
            try {
                return this.getLanguage().getLLVMMemory().allocateMemory(this, size);
            }
            catch (OutOfMemoryError e) {
                outOfMemory.enter();
                return LLVMNativePointer.createNull();
            }
        }

        @Specialization
        protected LLVMNativePointer doVoid(long size, @Cached BranchProfile outOfMemory) {
            try {
                return this.getLanguage().getLLVMMemory().allocateMemory(this, size);
            }
            catch (OutOfMemoryError e) {
                outOfMemory.enter();
                return LLVMNativePointer.createNull();
            }
        }
    }
}

