/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.LLVMContextWindows;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.pthread.LLVMThreadException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class LLVMWindowsInitThreadIntrinsics {

    public static abstract class InitThreadNotify
    extends LLVMExpressionNode {
        abstract Object execute();

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public Object doWait() {
            LLVMContextWindows context = this.getContext().getWindowsContext();
            ReentrantLock lock = context.getInitThreadLock();
            try {
                lock.lock();
                context.getInitThreadCondition().signalAll();
            }
            finally {
                lock.unlock();
            }
            return null;
        }
    }

    @NodeChild(value="timeout")
    public static abstract class InitThreadWait
    extends LLVMExpressionNode {
        abstract Object execute(int var1);

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public Object doWait(int timeout) {
            try {
                this.getContext().getWindowsContext().getInitThreadCondition().await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                throw new LLVMThreadException(this, "Thread interrupted during _Init_thread_wait", ex);
            }
            return null;
        }
    }

    public static abstract class InitThreadUnlock
    extends LLVMExpressionNode {
        abstract Object execute();

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public Object doUnlock() {
            this.getContext().getWindowsContext().getInitThreadLock().unlock();
            return null;
        }
    }

    public static abstract class InitThreadLock
    extends LLVMExpressionNode {
        abstract Object execute();

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public Object doLock() {
            this.getContext().getWindowsContext().getInitThreadLock().lock();
            return null;
        }
    }
}

