/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.nodes.ExecutionSignature;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.llvm.runtime.DummyReceiver;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMHasDatalayoutNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMRootNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import java.util.HashMap;
import java.util.Map;

public final class LLVMFunctionStartNode
extends LLVMRootNode
implements LLVMHasDatalayoutNode {
    @Node.Child
    private LLVMExpressionNode node;
    private final String name;
    private final int explicitArgumentsCount;
    private final String originalName;
    private final Source bcSource;
    private final LLVMSourceLocation sourceLocation;
    private final DataLayout dataLayout;
    private final LLVMFunction rootFunction;

    public LLVMFunctionStartNode(LLVMLanguage language, LLVMStack.LLVMStackAccess stackAccess, LLVMExpressionNode node, FrameDescriptor frameDescriptor, String name, int explicitArgumentsCount, String originalName, Source bcSource, LLVMSourceLocation location, DataLayout dataLayout, LLVMFunction rootFunction) {
        super(language, frameDescriptor, stackAccess);
        this.dataLayout = dataLayout;
        this.explicitArgumentsCount = explicitArgumentsCount;
        this.node = node;
        this.name = name;
        this.originalName = originalName;
        this.bcSource = bcSource;
        this.sourceLocation = location;
        this.rootFunction = rootFunction;
    }

    public String toString() {
        return this.name;
    }

    public SourceSection getSourceSection() {
        return this.sourceLocation.getSourceSection();
    }

    public boolean isInternal() {
        return this.bcSource.isInternal();
    }

    public Object execute(VirtualFrame frame) {
        return this.node.executeGeneric(frame);
    }

    @Override
    public String getName() {
        if (this.originalName != null) {
            return this.originalName;
        }
        return this.name;
    }

    public LLVMFunction getRootFunction() {
        return this.rootFunction;
    }

    public int getExplicitArgumentsCount() {
        return this.explicitArgumentsCount;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getBcName() {
        return this.name;
    }

    public Source getBcSource() {
        return this.bcSource;
    }

    @Override
    public DataLayout getDatalayout() {
        return this.dataLayout;
    }

    public Map<String, Object> getDebugProperties() {
        CompilerAsserts.neverPartOfCompilation();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.originalName != null) {
            properties.put("originalName", this.originalName);
        }
        if (this.bcSource != null) {
            properties.put("bcSource", this.bcSource);
        }
        if (this.sourceLocation != null) {
            properties.put("sourceLocation", this.sourceLocation);
        }
        return properties;
    }

    @Override
    protected ExecutionSignature prepareForAOT() {
        super.prepareForAOT();
        LLVMFunctionStartNode.customPrepareForAOT(this);
        return ExecutionSignature.GENERIC;
    }

    protected Object translateStackTraceElement(TruffleStackTraceElement element) {
        return LLVMManagedPointer.cast(LLVMLanguage.getContext().getSymbolResolved(this.rootFunction, BranchProfile.getUncached())).getObject();
    }

    private static void customPrepareForAOT(RootNode root) {
        root.atomic(() -> {
            LLVMLanguage language = LLVMLanguage.get((Node)root);
            NodeUtil.forEachChild((Node)root, (NodeVisitor)new ReplacingAOTNodeVisitor(language, root));
        });
    }

    private static final class ReplacingAOTNodeVisitor
    implements NodeVisitor {
        private final LLVMLanguage language;
        private final RootNode root;

        private ReplacingAOTNodeVisitor(LLVMLanguage language, RootNode root) {
            this.language = language;
            this.root = root;
        }

        public boolean visit(Node n) {
            Node node = n;
            boolean prepareForAOT = true;
            if (node.isAdoptable() && node instanceof Library) {
                Library repl = DummyReceiver.getAOTLibraryReplacement((Library)node);
                if (repl != null) {
                    node = node.replace((Node)repl);
                }
                boolean bl = prepareForAOT = repl == null;
            }
            if (prepareForAOT && node instanceof GenerateAOT.Provider) {
                GenerateAOT.Provider provider = (GenerateAOT.Provider)node;
                if (node.isAdoptable() && node.getRootNode() == null) {
                    throw new AssertionError((Object)("Node is not yet adopted before prepare " + node));
                }
                provider.prepareForAOT((TruffleLanguage)this.language, this.root);
            }
            return NodeUtil.forEachChild((Node)node, (NodeVisitor)this);
        }
    }
}

