/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMToPointerNode.class)
public final class LLVMToPointerNodeGen
extends LLVMToPointerNode
implements GenerateAOT.Provider {
    private static final Uncached UNCACHED = new Uncached();
    @CompilerDirectives.CompilationFinal
    private int state_0_;
    @Node.Child
    private LLVMToNativeNode generic_toNative_;

    private LLVMToPointerNodeGen() {
    }

    @Override
    public LLVMPointer executeWithTarget(Object arg0Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(arg0Value);
        }
        if ((state_0 & 0xE) != 0) {
            LLVMToNativeNode toNative__;
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                return this.doPointer(arg0Value_);
            }
            if ((state_0 & 8) != 0 && arg0Value instanceof Long) {
                long arg0Value_ = (Long)arg0Value;
                return this.doLong(arg0Value_);
            }
            if ((state_0 & 4) != 0 && (toNative__ = this.generic_toNative_) != null) {
                return this.doGeneric(arg0Value, toNative__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private LLVMPointer executeAndSpecialize(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if ((state_0 & 4) == 0 && LLVMTypes.isPointer(arg0Value)) {
            LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
            this.state_0_ = state_0 |= 2;
            return this.doPointer(arg0Value_);
        }
        if ((state_0 & 4) == 0 && arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            this.state_0_ = state_0 |= 8;
            return this.doLong(arg0Value_);
        }
        LLVMToNativeNode toNative__ = (LLVMToNativeNode)this.insert(LLVMToNativeNodeGen.create());
        Objects.requireNonNull(toNative__, "Specialization 'doGeneric(Object, LLVMToNativeNode)' cache 'toNative' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
        VarHandle.storeStoreFence();
        this.generic_toNative_ = toNative__;
        state_0 &= 0xFFFFFFF5;
        this.state_0_ = state_0 |= 4;
        return this.doGeneric(arg0Value, toNative__);
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0xE) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 0xE & (state_0 & 0xE) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        if ((this.state_0_ & 1) != 0) {
            return;
        }
        LLVMToNativeNode toNative__ = (LLVMToNativeNode)this.insert(LLVMToNativeNodeGen.create());
        Objects.requireNonNull(toNative__, "Specialization 'doGeneric(Object, LLVMToNativeNode)' cache 'toNative' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
        VarHandle.storeStoreFence();
        this.generic_toNative_ = toNative__;
        this.state_0_ &= 0xFFFFFFF5;
        assert (NodeUtil.assertRecursion((Node)this.generic_toNative_, (int)1));
        ((GenerateAOT.Provider)this.generic_toNative_).prepareForAOT(language, root);
        this.state_0_ |= 4;
        int state_0 = this.state_0_;
        this.state_0_ = state_0 |= 1;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if ((state_0 & 1) == 0) {
            return;
        }
        this.state_0_ = 0;
        this.generic_toNative_ = null;
    }

    @NeverDefault
    public static LLVMToPointerNode create() {
        return new LLVMToPointerNodeGen();
    }

    @NeverDefault
    public static LLVMToPointerNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=LLVMToPointerNode.class)
    @DenyReplace
    private static final class Uncached
    extends LLVMToPointerNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public LLVMPointer executeWithTarget(Object arg0Value) {
            return this.doGeneric(arg0Value, LLVMToNativeNodeGen.getUncached());
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }
}

