/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMAccessForeignObjectNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropWriteNode;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupport;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.nio.ByteOrder;

@NodeChildren(value={@NodeChild(value="foreign", type=LLVMAccessForeignObjectNode.ForeignDummy.class, implicit=true), @NodeChild(value="offset", type=LLVMAccessForeignObjectNode.OffsetDummy.class, implicit=true), @NodeChild(value="value", type=LLVMAccessForeignObjectNode.ForeignDummy.class, implicit=true), @NodeChild(value="resolve", type=LLVMAccessForeignObjectNode.ResolveNativePointerNode.class, executeWith={"foreign", "offset"}, implicit=true, allowUncached=true), @NodeChild(value="type", type=LLVMAccessForeignObjectNode.GetForeignTypeNode.class, executeWith={"resolve"}, implicit=true, allowUncached=true)})
public abstract class LLVMWriteToForeignObjectNode
extends LLVMAccessForeignObjectNode {

    @GenerateUncached
    public static abstract class ForeignWriteI64Node
    extends LLVMWriteToForeignObjectNode {
        public abstract void execute(Object var1, long var2, Object var4);

        public abstract void executeLong(Object var1, long var2, long var4);

        public abstract void executePointer(Object var1, long var2, LLVMPointer var4);

        @Specialization
        void doNativeLong(Object foreign, long offset, long value, LLVMNativePointer resolved, Object type) {
            this.getLanguage().getLLVMMemory().putI64((Node)this, resolved, value);
        }

        @Specialization
        void doNativePointer(Object foreign, long offset, Object value, LLVMNativePointer resolved, Object type, @Cached LLVMNativePointerSupport.ToNativePointerNode toNativePointer) {
            this.getLanguage().getLLVMMemory().putPointer((Node)this, resolved, toNativePointer.execute(value));
        }

        @Specialization
        @GenerateAOT.Exclude
        void doBufferLong(Object foreign, long offset, long value, LLVMManagedPointer resolved, LLVMInteropType.Buffer type, @CachedLibrary(limit="3") InteropLibrary interop, @Cached BranchProfile oobProfile) {
            try {
                interop.writeBufferLong(resolved.getObject(), ByteOrder.nativeOrder(), resolved.getOffset(), value);
            }
            catch (InvalidBufferOffsetException ex) {
                throw this.oob(oobProfile, ex);
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }

        @Specialization
        @GenerateAOT.Exclude
        void doBufferPointer(Object foreign, long offset, Object value, LLVMManagedPointer resolved, LLVMInteropType.Buffer type, @CachedLibrary(limit="3") InteropLibrary interop, @Cached LLVMNativePointerSupport.ToNativePointerNode toNativePointer, @Cached BranchProfile oobProfile) {
            LLVMNativePointer n = toNativePointer.execute(value);
            try {
                interop.writeBufferLong(resolved.getObject(), ByteOrder.nativeOrder(), resolved.getOffset(), n.asNative());
            }
            catch (InvalidBufferOffsetException ex) {
                throw this.oob(oobProfile, ex);
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }

        @Specialization
        void doStructured(Object foreign, long offset, Object value, LLVMManagedPointer resolved, LLVMInteropType.Structured type, @Cached LLVMInteropWriteNode interopWrite) {
            interopWrite.execute(type, resolved.getObject(), resolved.getOffset(), value, ForeignToLLVM.ForeignToLLVMType.I64);
        }

        @Specialization(limit="3", guards={"type == null"})
        @GenerateAOT.Exclude
        void doFallbackLong(Object foreign, long offset, long value, LLVMManagedPointer resolved, Object type, @CachedLibrary(value="resolved.getObject()") InteropLibrary interop) {
            try {
                interop.writeArrayElement(resolved.getObject(), resolved.getOffset() / 8L, (Object)value);
            }
            catch (UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new LLVMPolyglotException(this, "Wrong type writing to array element.");
            }
            catch (InteropException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new LLVMPolyglotException(this, "Error writing to foreign array.");
            }
        }

        @Specialization(limit="3", guards={"type == null"})
        @GenerateAOT.Exclude
        void doFallbackPointer(Object foreign, long offset, LLVMPointer value, LLVMManagedPointer resolved, Object type, @Cached LLVMDataEscapeNode.LLVMPointerDataEscapeNode dataEscape, @CachedLibrary(value="resolved.getObject()") InteropLibrary interop) {
            try {
                Object escapedValue = dataEscape.executeWithTarget(value);
                interop.writeArrayElement(resolved.getObject(), resolved.getOffset() / 8L, escapedValue);
            }
            catch (UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new LLVMPolyglotException(this, "Wrong type writing to array element.");
            }
            catch (InteropException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new LLVMPolyglotException(this, "Error writing to foreign array.");
            }
        }
    }

    @GenerateUncached
    public static abstract class ForeignWriteDoubleNode
    extends LLVMWriteToForeignObjectNode {
        public abstract void execute(Object var1, long var2, double var4);

        @Specialization
        void doNative(Object foreign, long offset, double value, LLVMNativePointer resolved, Object type) {
            this.getLanguage().getLLVMMemory().putDouble((Node)this, resolved, value);
        }

        @Specialization(limit="3")
        @GenerateAOT.Exclude
        void doBuffer(Object foreign, long offset, double value, LLVMManagedPointer resolved, LLVMInteropType.Buffer type, @CachedLibrary(value="resolved.getObject()") InteropLibrary interop, @Cached BranchProfile oobProfile) {
            try {
                interop.writeBufferDouble(resolved.getObject(), ByteOrder.nativeOrder(), resolved.getOffset(), value);
            }
            catch (InvalidBufferOffsetException ex) {
                throw this.oob(oobProfile, ex);
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }

        @Specialization
        void doStructured(Object foreign, long offset, double value, LLVMManagedPointer resolved, LLVMInteropType.Structured type, @Cached LLVMInteropWriteNode interopWrite) {
            interopWrite.execute(type, resolved.getObject(), resolved.getOffset(), value, ForeignToLLVM.ForeignToLLVMType.DOUBLE);
        }

        @Specialization(limit="3", guards={"type == null"})
        @GenerateAOT.Exclude
        void doFallback(Object foreign, long offset, double value, LLVMManagedPointer resolved, Object type, @CachedLibrary(value="resolved.getObject()") InteropLibrary interop) {
            try {
                interop.writeArrayElement(resolved.getObject(), resolved.getOffset() / 8L, (Object)value);
            }
            catch (UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new LLVMPolyglotException(this, "Wrong type writing to array element.");
            }
            catch (InteropException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new LLVMPolyglotException(this, "Error writing to foreign array.");
            }
        }
    }

    @GenerateUncached
    public static abstract class ForeignWriteFloatNode
    extends LLVMWriteToForeignObjectNode {
        public abstract void execute(Object var1, long var2, float var4);

        @Specialization
        void doNative(Object foreign, long offset, float value, LLVMNativePointer resolved, Object type) {
            this.getLanguage().getLLVMMemory().putFloat((Node)this, resolved, value);
        }

        @Specialization(limit="3")
        @GenerateAOT.Exclude
        void doBuffer(Object foreign, long offset, float value, LLVMManagedPointer resolved, LLVMInteropType.Buffer type, @CachedLibrary(value="resolved.getObject()") InteropLibrary interop, @Cached BranchProfile oobProfile) {
            try {
                interop.writeBufferFloat(resolved.getObject(), ByteOrder.nativeOrder(), resolved.getOffset(), value);
            }
            catch (InvalidBufferOffsetException ex) {
                throw this.oob(oobProfile, ex);
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }

        @Specialization
        void doStructured(Object foreign, long offset, float value, LLVMManagedPointer resolved, LLVMInteropType.Structured type, @Cached LLVMInteropWriteNode interopWrite) {
            interopWrite.execute(type, resolved.getObject(), resolved.getOffset(), Float.valueOf(value), ForeignToLLVM.ForeignToLLVMType.FLOAT);
        }

        @Specialization(limit="3", guards={"type == null"})
        @GenerateAOT.Exclude
        void doFallback(Object foreign, long offset, float value, LLVMManagedPointer resolved, Object type, @CachedLibrary(value="resolved.getObject()") InteropLibrary interop) {
            try {
                interop.writeArrayElement(resolved.getObject(), resolved.getOffset() / 4L, (Object)Float.valueOf(value));
            }
            catch (UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new LLVMPolyglotException(this, "Wrong type writing to array element.");
            }
            catch (InteropException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new LLVMPolyglotException(this, "Error writing to foreign array.");
            }
        }
    }

    @GenerateUncached
    public static abstract class ForeignWriteI32Node
    extends LLVMWriteToForeignObjectNode {
        public abstract void execute(Object var1, long var2, int var4);

        @Specialization
        void doNative(Object foreign, long offset, int value, LLVMNativePointer resolved, Object type) {
            this.getLanguage().getLLVMMemory().putI32((Node)this, resolved, value);
        }

        @Specialization(limit="3")
        @GenerateAOT.Exclude
        void doBuffer(Object foreign, long offset, int value, LLVMManagedPointer resolved, LLVMInteropType.Buffer type, @CachedLibrary(value="resolved.getObject()") InteropLibrary interop, @Cached BranchProfile oobProfile) {
            try {
                interop.writeBufferInt(resolved.getObject(), ByteOrder.nativeOrder(), resolved.getOffset(), value);
            }
            catch (InvalidBufferOffsetException ex) {
                throw this.oob(oobProfile, ex);
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }

        @Specialization
        void doStructured(Object foreign, long offset, int value, LLVMManagedPointer resolved, LLVMInteropType.Structured type, @Cached LLVMInteropWriteNode interopWrite) {
            interopWrite.execute(type, resolved.getObject(), resolved.getOffset(), value, ForeignToLLVM.ForeignToLLVMType.I32);
        }

        @Specialization(limit="3", guards={"type == null"})
        @GenerateAOT.Exclude
        void doFallback(Object foreign, long offset, int value, LLVMManagedPointer resolved, Object type, @CachedLibrary(value="resolved.getObject()") InteropLibrary interop) {
            try {
                interop.writeArrayElement(resolved.getObject(), resolved.getOffset() / 4L, (Object)value);
            }
            catch (UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new LLVMPolyglotException(this, "Wrong type writing to array element.");
            }
            catch (InteropException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new LLVMPolyglotException(this, "Error writing to foreign array.");
            }
        }
    }

    @GenerateUncached
    public static abstract class ForeignWriteI16Node
    extends LLVMWriteToForeignObjectNode {
        public abstract void execute(Object var1, long var2, short var4);

        @Specialization
        void doNative(Object foreign, long offset, short value, LLVMNativePointer resolved, Object type) {
            this.getLanguage().getLLVMMemory().putI16((Node)this, resolved, value);
        }

        @Specialization(limit="3")
        @GenerateAOT.Exclude
        void doBuffer(Object foreign, long offset, short value, LLVMManagedPointer resolved, LLVMInteropType.Buffer type, @CachedLibrary(value="resolved.getObject()") InteropLibrary interop, @Cached BranchProfile oobProfile) {
            try {
                interop.writeBufferShort(resolved.getObject(), ByteOrder.nativeOrder(), resolved.getOffset(), value);
            }
            catch (InvalidBufferOffsetException ex) {
                throw this.oob(oobProfile, ex);
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }

        @Specialization
        void doStructured(Object foreign, long offset, short value, LLVMManagedPointer resolved, LLVMInteropType.Structured type, @Cached LLVMInteropWriteNode interopWrite) {
            interopWrite.execute(type, resolved.getObject(), resolved.getOffset(), value, ForeignToLLVM.ForeignToLLVMType.I16);
        }

        @Specialization(limit="3", guards={"type == null"})
        @GenerateAOT.Exclude
        void doFallback(Object foreign, long offset, short value, LLVMManagedPointer resolved, Object type, @CachedLibrary(value="resolved.getObject()") InteropLibrary interop) {
            try {
                interop.writeArrayElement(resolved.getObject(), resolved.getOffset() / 2L, (Object)value);
            }
            catch (UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new LLVMPolyglotException(this, "Wrong type writing to array element.");
            }
            catch (InteropException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new LLVMPolyglotException(this, "Error writing to foreign array.");
            }
        }
    }

    @GenerateUncached
    public static abstract class ForeignWriteI8Node
    extends LLVMWriteToForeignObjectNode {
        public abstract void execute(Object var1, long var2, byte var4);

        @Specialization
        void doNative(Object foreign, long offset, byte value, LLVMNativePointer resolved, Object type) {
            this.getLanguage().getLLVMMemory().putI8((Node)this, resolved, value);
        }

        @Specialization(limit="3")
        @GenerateAOT.Exclude
        void doBuffer(Object foreign, long offset, byte value, LLVMManagedPointer resolved, LLVMInteropType.Buffer type, @CachedLibrary(value="resolved.getObject()") InteropLibrary interop, @Cached BranchProfile oobProfile) {
            try {
                interop.writeBufferByte(resolved.getObject(), resolved.getOffset(), value);
            }
            catch (InvalidBufferOffsetException ex) {
                throw this.oob(oobProfile, ex);
            }
            catch (UnsupportedMessageException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }

        @Specialization
        void doStructured(Object foreign, long offset, byte value, LLVMManagedPointer resolved, LLVMInteropType.Structured type, @Cached LLVMInteropWriteNode interopWrite) {
            interopWrite.execute(type, resolved.getObject(), resolved.getOffset(), value, ForeignToLLVM.ForeignToLLVMType.I8);
        }

        @Specialization(limit="3", guards={"type == null"})
        @GenerateAOT.Exclude
        void doFallback(Object foreign, long offset, byte value, LLVMManagedPointer resolved, Object type, @CachedLibrary(value="resolved.getObject()") InteropLibrary interop) {
            try {
                interop.writeArrayElement(resolved.getObject(), resolved.getOffset() / 1L, (Object)value);
            }
            catch (UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new LLVMPolyglotException(this, "Wrong type writing to array element.");
            }
            catch (InteropException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new LLVMPolyglotException(this, "Error writing to foreign array.");
            }
        }
    }
}

