/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMInfo;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.aarch64.darwin.LLVMDarwinAarch64VaListStorage;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.aarch64.linux.LLVMLinuxAarch64VaListStorage;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVaListLibrary;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.x86.LLVMX86_64VaListStorage;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.x86_win.LLVMX86_64_WinVaListStorage;
import com.oracle.truffle.llvm.runtime.pointer.LLVMMaybeVaPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;
import com.oracle.truffle.nfi.api.NativePointerLibrary;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

@ExportLibrary.Repeat(value={@ExportLibrary(value=LLVMManagedReadLibrary.class, useForAOT=false), @ExportLibrary(value=LLVMManagedWriteLibrary.class, useForAOT=false), @ExportLibrary(value=LLVMVaListLibrary.class, useForAOT=false), @ExportLibrary(value=NativeTypeLibrary.class, useForAOT=false), @ExportLibrary(value=LLVMNativeLibrary.class, useForAOT=false), @ExportLibrary(value=NativePointerLibrary.class, useForAOT=false), @ExportLibrary(value=SignatureLibrary.class, useForAOT=false)})
public final class DummyReceiver {
    private static final Map<Class<?>, Supplier<Boolean>> platformVerifiers = new ConcurrentHashMap();
    public static final DummyReceiver INSTANCE_FOR_CREATE;
    public static final DummyReceiver INSTANCE_FOR_ACCEPTS;

    private static void registerPlatformVerifier(Class<?> vaListStorageClass, Supplier<Boolean> verifier) {
        platformVerifiers.put(vaListStorageClass, verifier);
    }

    public static boolean isValidPlatform(Class<?> possibleVaListStorageClass) {
        Supplier<Boolean> platformVerifier = platformVerifiers.get(possibleVaListStorageClass);
        return platformVerifier == null || platformVerifier.get() != false;
    }

    public static Library getAOTLibraryReplacement(Library node) {
        GeneratedBy generatedByAnnot = node.getClass().getAnnotation(GeneratedBy.class);
        if (generatedByAnnot != null) {
            Class exportClass = generatedByAnnot.value();
            Class<?> libClass = node.getClass();
            while (libClass.getSuperclass() != Library.class) {
                libClass = libClass.getSuperclass();
            }
            LibraryFactory libraryFactory = LibraryFactory.resolve(libClass);
            Library dummyLibrary = libraryFactory.create((Object)INSTANCE_FOR_CREATE);
            if (dummyLibrary.accepts((Object)INSTANCE_FOR_ACCEPTS)) {
                return null;
            }
            if (!DummyReceiver.isValidPlatform(exportClass)) {
                return dummyLibrary;
            }
            if (libClass == exportClass) {
                return null;
            }
        }
        return null;
    }

    @ExportMessage
    public boolean accepts() {
        return this == INSTANCE_FOR_CREATE;
    }

    @ExportMessage
    boolean isReadable() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    public byte readI8(long offset) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    public short readI16(long offset) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    public int readI32(long offset) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    public LLVMPointer readPointer(long offset) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    public Object readGenericI64(long offset) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    public boolean isWritable() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    public void writeI8(long offset, byte value) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    public void writeI16(long offset, short value) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    public void writeI32(long offset, int value) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    public void writeGenericI64(long offset, Object value) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    public void initialize(Object[] arguments, int numberOfExplicitArguments, Frame frame) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    public void cleanup(Frame frame) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    public void copy(Object destVaList, Frame frame) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    public Object shift(Type type, Frame frame) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    public boolean hasNativeType() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    public Object getNativeType() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage(name="isPointer", library=LLVMNativeLibrary.class)
    public boolean isPointerLLVMNativeLibrary() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage(name="asPointer", library=LLVMNativeLibrary.class)
    public long asPointerLLVMNativeLibrary() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    public LLVMNativePointer toNativePointer() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage(name="isPointer", library=NativePointerLibrary.class)
    public boolean isPointerNativePointerLibrary() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage(name="asPointer", library=NativePointerLibrary.class)
    public long asPointerNativePointerLibrary() {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    public Object call(Object functionPointer, Object ... args) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    public Object bind(Object functionPointer) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    public Object createClosure(Object executable) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    static {
        DummyReceiver.registerPlatformVerifier(LLVMX86_64_WinVaListStorage.class, () -> LLVMInfo.SYSNAME.toLowerCase().contains("windows") && LLVMInfo.MACHINE.equalsIgnoreCase("x86_64"));
        DummyReceiver.registerPlatformVerifier(LLVMDarwinAarch64VaListStorage.class, () -> LLVMInfo.SYSNAME.toLowerCase().contains("mac os x") && LLVMInfo.MACHINE.equalsIgnoreCase("aarch64"));
        DummyReceiver.registerPlatformVerifier(LLVMLinuxAarch64VaListStorage.class, () -> LLVMInfo.SYSNAME.toLowerCase().contains("linux") && LLVMInfo.MACHINE.equalsIgnoreCase("aarch64"));
        DummyReceiver.registerPlatformVerifier(LLVMX86_64VaListStorage.class, () -> !LLVMInfo.SYSNAME.toLowerCase().contains("windows") && LLVMInfo.MACHINE.equalsIgnoreCase("x86_64"));
        DummyReceiver.registerPlatformVerifier(LLVMMaybeVaPointer.class, () -> (LLVMInfo.SYSNAME.toLowerCase().contains("mac os x") || LLVMInfo.SYSNAME.toLowerCase().contains("windows")) && LLVMInfo.MACHINE.equalsIgnoreCase("aarch64"));
        INSTANCE_FOR_CREATE = new DummyReceiver();
        INSTANCE_FOR_ACCEPTS = new DummyReceiver();
    }
}

