/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.constants;

import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.enums.BinaryOperator;
import com.oracle.truffle.llvm.parser.model.symbols.constants.AbstractConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.Constant;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.parser.util.LLVMBitcodeTypeHelper;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VectorType;

public final class BinaryOperationConstant
extends AbstractConstant {
    private final BinaryOperator operator;
    private Constant lhs;
    private Constant rhs;

    private BinaryOperationConstant(Type type, BinaryOperator operator) {
        super(type);
        this.operator = operator;
        this.lhs = null;
        this.rhs = null;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.lhs == original) {
            this.lhs = (Constant)replacement;
        }
        if (this.rhs == original) {
            this.rhs = (Constant)replacement;
        }
    }

    public static BinaryOperationConstant fromSymbols(SymbolTable symbols, Type type, int opcode, int lhs, int rhs) {
        boolean isFloatingPoint = Type.isFloatingpointType(type) || type instanceof VectorType && Type.isFloatingpointType(((VectorType)type).getElementType());
        BinaryOperator operator = BinaryOperator.decode(opcode, isFloatingPoint);
        BinaryOperationConstant constant = new BinaryOperationConstant(type, operator);
        constant.lhs = symbols.getForwardReferenced(lhs, constant);
        constant.rhs = symbols.getForwardReferenced(rhs, constant);
        return constant;
    }

    @Override
    public LLVMExpressionNode createNode(LLVMParserRuntime runtime, DataLayout dataLayout, GetStackSpaceFactory stackFactory) {
        return LLVMBitcodeTypeHelper.createArithmeticInstruction(this.lhs.createNode(runtime, dataLayout, stackFactory), this.rhs.createNode(runtime, dataLayout, stackFactory), this.operator, this.getType(), runtime.getNodeFactory());
    }
}

