/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.enums;

public enum Visibility {
    DEFAULT("default", 0L),
    HIDDEN("hidden", 1L),
    PROTECTED("protected", 2L);

    private static final Visibility[] VALUES;
    private final String irString;
    private final long encodedValue;

    private Visibility(String irString, long encodedValue) {
        this.irString = irString;
        this.encodedValue = encodedValue;
    }

    public long getEncodedValue() {
        return this.encodedValue;
    }

    public static Visibility decode(long value) {
        for (Visibility visibility : VALUES) {
            if (visibility.getEncodedValue() != value) continue;
            return visibility;
        }
        return DEFAULT;
    }

    public String getIrString() {
        return this.irString;
    }

    static {
        VALUES = Visibility.values();
    }
}

