/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.enums;

import com.oracle.truffle.llvm.parser.model.enums.Visibility;

public enum Linkage {
    EXTERNAL("external", 0L),
    WEAK("weak", 1L, 16L),
    APPENDING("appending", 2L),
    INTERNAL("internal", 3L),
    LINKONCE("linkonce", 4L, 18L),
    DLL_IMPORT("dllimport", 5L),
    DLL_EXPORT("dllexport", 6L),
    EXTERN_WEAK("extern_weak", 7L),
    COMMON("common", 8L),
    PRIVATE("private", 9L),
    WEAK_ODR("weak_odr", 10L, 17L),
    LINK_ONCE_ODR("linkonce_odr", 11L, 19L),
    AVAILABLE_EXTERNALLY("available_externally", 12L),
    LINKER_PRIVATE("linker_private", 13L),
    LINKER_PRIVATE_WEAK("linker_private_weak", 14L),
    LINK_ONCE_ODR_AUTO_HIDE("linkonce_odr_auto_hide", 15L);

    private static final Linkage[] VALUES;
    private final String irString;
    private final long[] encodedValue;

    private Linkage(String irString, long ... encodedValue) {
        this.irString = irString;
        this.encodedValue = encodedValue;
    }

    private long[] getEncodedValue() {
        return this.encodedValue;
    }

    public static Linkage decode(long value) {
        for (Linkage linkage : VALUES) {
            for (long l : linkage.getEncodedValue()) {
                if (l != value) continue;
                return linkage;
            }
        }
        return EXTERNAL;
    }

    public String getIrString() {
        return this.irString;
    }

    public static boolean isExported(Linkage linkage, Visibility visibility) {
        switch (linkage) {
            case AVAILABLE_EXTERNALLY: 
            case DLL_IMPORT: {
                return true;
            }
            case EXTERNAL: 
            case DLL_EXPORT: 
            case WEAK: 
            case APPENDING: 
            case LINKONCE: 
            case EXTERN_WEAK: 
            case COMMON: 
            case WEAK_ODR: 
            case LINK_ONCE_ODR: {
                return visibility == Visibility.DEFAULT || visibility == Visibility.PROTECTED;
            }
            case INTERNAL: 
            case PRIVATE: 
            case LINKER_PRIVATE: 
            case LINKER_PRIVATE_WEAK: 
            case LINK_ONCE_ODR_AUTO_HIDE: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown linkage: " + linkage);
    }

    public static boolean isOverridable(Linkage linkage, Visibility visibility) {
        switch (linkage) {
            case AVAILABLE_EXTERNALLY: 
            case DLL_IMPORT: {
                return true;
            }
            case EXTERNAL: 
            case DLL_EXPORT: 
            case WEAK: 
            case APPENDING: 
            case LINKONCE: 
            case EXTERN_WEAK: 
            case COMMON: 
            case WEAK_ODR: 
            case LINK_ONCE_ODR: {
                return visibility == Visibility.DEFAULT;
            }
            case INTERNAL: 
            case PRIVATE: 
            case LINKER_PRIVATE: 
            case LINKER_PRIVATE_WEAK: 
            case LINK_ONCE_ODR_AUTO_HIDE: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown linkage: " + linkage);
    }

    public static boolean isExternal(Linkage linkage) {
        switch (linkage) {
            case AVAILABLE_EXTERNALLY: 
            case DLL_IMPORT: {
                return true;
            }
            case EXTERNAL: 
            case DLL_EXPORT: 
            case WEAK: 
            case APPENDING: 
            case LINKONCE: 
            case EXTERN_WEAK: 
            case COMMON: 
            case WEAK_ODR: 
            case LINK_ONCE_ODR: 
            case INTERNAL: 
            case PRIVATE: 
            case LINKER_PRIVATE: 
            case LINKER_PRIVATE_WEAK: 
            case LINK_ONCE_ODR_AUTO_HIDE: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown linkage: " + linkage);
    }

    static {
        VALUES = Linkage.values();
    }
}

