/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.initialization;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.initialization.LoadModulesNode;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.NativeContextExtension;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.c.LLVMDLOpen;
import java.util.ArrayList;

public final class LoadNativeNode
extends RootNode {
    private final String path;

    private LoadNativeNode(LLVMLanguage language, TruffleFile file) {
        super((TruffleLanguage)language);
        this.path = file.getPath();
    }

    public static LoadNativeNode create(LLVMLanguage language, TruffleFile file) {
        return new LoadNativeNode(language, file);
    }

    public String getName() {
        return String.format("<%s/%s>", ((Object)((Object)this)).getClass().getSimpleName(), this.path);
    }

    public Object execute(VirtualFrame frame) {
        LoadModulesNode.LLVMLoadingPhase phase;
        Object[] arguments = frame.getArguments();
        Object library = null;
        if (arguments.length > 0 && arguments[0] instanceof LoadModulesNode.LLVMLoadingPhase) {
            phase = (LoadModulesNode.LLVMLoadingPhase)((Object)arguments[0]);
        } else if (arguments.length == 0 || arguments.length > 0 && arguments[0] instanceof LLVMDLOpen.RTLDFlags) {
            if (this.path == null) {
                throw new LLVMParserException((Node)this, "Toplevel executable %s does not contain bitcode", this.path);
            }
            phase = LoadModulesNode.LLVMLoadingPhase.INIT_SYMBOLS;
        } else {
            throw new LLVMParserException((Node)this, "LoadNativeNode is called either with unexpected arguments or as a toplevel", new Object[0]);
        }
        if (LoadModulesNode.LLVMLoadingPhase.INIT_SYMBOLS.isActive(phase)) {
            LLVMContext context = LLVMContext.get((Node)this);
            library = this.parseAndInitialiseNativeLib(context);
        }
        if (LoadModulesNode.LLVMLoadingPhase.BUILD_DEPENDENCY.isActive(phase)) {
            ArrayList dependencies = (ArrayList)frame.getArguments()[2];
            dependencies.add(this.getCallTarget());
        }
        return library;
    }

    @CompilerDirectives.TruffleBoundary
    private Object parseAndInitialiseNativeLib(LLVMContext context) {
        NativeContextExtension nativeContextExtension = context.getContextExtensionOrNull(NativeContextExtension.class);
        if (nativeContextExtension != null) {
            CallTarget callTarget = nativeContextExtension.parseNativeLibrary(this.path, context);
            Object nfiLibrary = callTarget.call(new Object[0]);
            nativeContextExtension.addLibraryHandles(nfiLibrary);
            return nfiLibrary;
        }
        return null;
    }
}

