/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.op;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesLongPointerGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupport;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupportFactory;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMFunnelShiftNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMFunnelShiftNode.class)
public final class LLVMFunnelShiftNodeFactory {

    @GeneratedBy(value=LLVMFunnelShiftNode.Fshr_I64Vector.class)
    public static final class Fshr_I64VectorNodeGen
    extends LLVMFunnelShiftNode.Fshr_I64Vector
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode shift_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private Fshr_I64VectorNodeGen(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            super(vectorSize);
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object shiftValue_ = this.shift_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 2) != 0 && leftValue_ instanceof LLVMI64Vector) {
                LLVMI64Vector leftValue__ = (LLVMI64Vector)leftValue_;
                if (rightValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector rightValue__ = (LLVMI64Vector)rightValue_;
                    if (shiftValue_ instanceof LLVMI64Vector) {
                        LLVMI64Vector shiftValue__ = (LLVMI64Vector)shiftValue_;
                        return this.doFshl(leftValue__, rightValue__, shiftValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private LLVMI64Vector executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof LLVMI64Vector) {
                LLVMI64Vector leftValue_ = (LLVMI64Vector)leftValue;
                if (rightValue instanceof LLVMI64Vector) {
                    LLVMI64Vector rightValue_ = (LLVMI64Vector)rightValue;
                    if (shiftValue instanceof LLVMI64Vector) {
                        LLVMI64Vector shiftValue_ = (LLVMI64Vector)shiftValue;
                        this.state_0_ = state_0 |= 2;
                        return this.doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.shift_}, new Object[]{leftValue, rightValue, shiftValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMFunnelShiftNode.Fshr_I64Vector create(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshr_I64VectorNodeGen(vectorSize, left, right, shift);
        }
    }

    @GeneratedBy(value=LLVMFunnelShiftNode.Fshr_I64.class)
    public static final class Fshr_I64NodeGen
    extends LLVMFunnelShiftNode.Fshr_I64
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode shift_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private Fshr_I64NodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            long shiftValue_;
            long rightValue_;
            long leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            try {
                shiftValue_ = this.shift_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doFshl(leftValue_, rightValue_, shiftValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) {
            long shiftValue_;
            long rightValue_;
            long leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            try {
                shiftValue_ = this.shift_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doFshl(leftValue_, rightValue_, shiftValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private long executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof Long) {
                long leftValue_ = (Long)leftValue;
                if (rightValue instanceof Long) {
                    long rightValue_ = (Long)rightValue;
                    if (shiftValue instanceof Long) {
                        long shiftValue_ = (Long)shiftValue;
                        this.state_0_ = state_0 |= 2;
                        return this.doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.shift_}, new Object[]{leftValue, rightValue, shiftValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMFunnelShiftNode.Fshr_I64 create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshr_I64NodeGen(left, right, shift);
        }
    }

    @GeneratedBy(value=LLVMFunnelShiftNode.Fshr_I32Vector.class)
    public static final class Fshr_I32VectorNodeGen
    extends LLVMFunnelShiftNode.Fshr_I32Vector
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode shift_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private Fshr_I32VectorNodeGen(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            super(vectorSize);
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object shiftValue_ = this.shift_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 2) != 0 && leftValue_ instanceof LLVMI32Vector) {
                LLVMI32Vector leftValue__ = (LLVMI32Vector)leftValue_;
                if (rightValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector rightValue__ = (LLVMI32Vector)rightValue_;
                    if (shiftValue_ instanceof LLVMI32Vector) {
                        LLVMI32Vector shiftValue__ = (LLVMI32Vector)shiftValue_;
                        return this.doFshl(leftValue__, rightValue__, shiftValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private LLVMI32Vector executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof LLVMI32Vector) {
                LLVMI32Vector leftValue_ = (LLVMI32Vector)leftValue;
                if (rightValue instanceof LLVMI32Vector) {
                    LLVMI32Vector rightValue_ = (LLVMI32Vector)rightValue;
                    if (shiftValue instanceof LLVMI32Vector) {
                        LLVMI32Vector shiftValue_ = (LLVMI32Vector)shiftValue;
                        this.state_0_ = state_0 |= 2;
                        return this.doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.shift_}, new Object[]{leftValue, rightValue, shiftValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMFunnelShiftNode.Fshr_I32Vector create(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshr_I32VectorNodeGen(vectorSize, left, right, shift);
        }
    }

    @GeneratedBy(value=LLVMFunnelShiftNode.Fshr_I32.class)
    public static final class Fshr_I32NodeGen
    extends LLVMFunnelShiftNode.Fshr_I32
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode shift_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private Fshr_I32NodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int shiftValue_;
            int rightValue_;
            int leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            try {
                shiftValue_ = this.shift_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doFshl(leftValue_, rightValue_, shiftValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int shiftValue_;
            int rightValue_;
            int leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            try {
                shiftValue_ = this.shift_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doFshl(leftValue_, rightValue_, shiftValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private int executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof Integer) {
                int leftValue_ = (Integer)leftValue;
                if (rightValue instanceof Integer) {
                    int rightValue_ = (Integer)rightValue;
                    if (shiftValue instanceof Integer) {
                        int shiftValue_ = (Integer)shiftValue;
                        this.state_0_ = state_0 |= 2;
                        return this.doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.shift_}, new Object[]{leftValue, rightValue, shiftValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMFunnelShiftNode.Fshr_I32 create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshr_I32NodeGen(left, right, shift);
        }
    }

    @GeneratedBy(value=LLVMFunnelShiftNode.Fshr_I16Vector.class)
    public static final class Fshr_I16VectorNodeGen
    extends LLVMFunnelShiftNode.Fshr_I16Vector
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode shift_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private Fshr_I16VectorNodeGen(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            super(vectorSize);
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object shiftValue_ = this.shift_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 2) != 0 && leftValue_ instanceof LLVMI16Vector) {
                LLVMI16Vector leftValue__ = (LLVMI16Vector)leftValue_;
                if (rightValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector rightValue__ = (LLVMI16Vector)rightValue_;
                    if (shiftValue_ instanceof LLVMI16Vector) {
                        LLVMI16Vector shiftValue__ = (LLVMI16Vector)shiftValue_;
                        return this.doFshl(leftValue__, rightValue__, shiftValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private LLVMI16Vector executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof LLVMI16Vector) {
                LLVMI16Vector leftValue_ = (LLVMI16Vector)leftValue;
                if (rightValue instanceof LLVMI16Vector) {
                    LLVMI16Vector rightValue_ = (LLVMI16Vector)rightValue;
                    if (shiftValue instanceof LLVMI16Vector) {
                        LLVMI16Vector shiftValue_ = (LLVMI16Vector)shiftValue;
                        this.state_0_ = state_0 |= 2;
                        return this.doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.shift_}, new Object[]{leftValue, rightValue, shiftValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMFunnelShiftNode.Fshr_I16Vector create(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshr_I16VectorNodeGen(vectorSize, left, right, shift);
        }
    }

    @GeneratedBy(value=LLVMFunnelShiftNode.Fshr_I16.class)
    public static final class Fshr_I16NodeGen
    extends LLVMFunnelShiftNode.Fshr_I16
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode shift_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private Fshr_I16NodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            short shiftValue_;
            short rightValue_;
            short leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            try {
                shiftValue_ = this.shift_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doFshl(leftValue_, rightValue_, shiftValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        @Override
        public short executeI16(VirtualFrame frameValue) {
            short shiftValue_;
            short rightValue_;
            short leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            try {
                shiftValue_ = this.shift_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doFshl(leftValue_, rightValue_, shiftValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private short executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof Short) {
                short leftValue_ = (Short)leftValue;
                if (rightValue instanceof Short) {
                    short rightValue_ = (Short)rightValue;
                    if (shiftValue instanceof Short) {
                        short shiftValue_ = (Short)shiftValue;
                        this.state_0_ = state_0 |= 2;
                        return this.doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.shift_}, new Object[]{leftValue, rightValue, shiftValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMFunnelShiftNode.Fshr_I16 create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshr_I16NodeGen(left, right, shift);
        }
    }

    @GeneratedBy(value=LLVMFunnelShiftNode.Fshr_I8Vector.class)
    public static final class Fshr_I8VectorNodeGen
    extends LLVMFunnelShiftNode.Fshr_I8Vector
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode shift_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private Fshr_I8VectorNodeGen(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            super(vectorSize);
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object shiftValue_ = this.shift_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 2) != 0 && leftValue_ instanceof LLVMI8Vector) {
                LLVMI8Vector leftValue__ = (LLVMI8Vector)leftValue_;
                if (rightValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector rightValue__ = (LLVMI8Vector)rightValue_;
                    if (shiftValue_ instanceof LLVMI8Vector) {
                        LLVMI8Vector shiftValue__ = (LLVMI8Vector)shiftValue_;
                        return this.doFshl(leftValue__, rightValue__, shiftValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private LLVMI8Vector executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof LLVMI8Vector) {
                LLVMI8Vector leftValue_ = (LLVMI8Vector)leftValue;
                if (rightValue instanceof LLVMI8Vector) {
                    LLVMI8Vector rightValue_ = (LLVMI8Vector)rightValue;
                    if (shiftValue instanceof LLVMI8Vector) {
                        LLVMI8Vector shiftValue_ = (LLVMI8Vector)shiftValue;
                        this.state_0_ = state_0 |= 2;
                        return this.doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.shift_}, new Object[]{leftValue, rightValue, shiftValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMFunnelShiftNode.Fshr_I8Vector create(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshr_I8VectorNodeGen(vectorSize, left, right, shift);
        }
    }

    @GeneratedBy(value=LLVMFunnelShiftNode.Fshr_I8.class)
    public static final class Fshr_I8NodeGen
    extends LLVMFunnelShiftNode.Fshr_I8
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode shift_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private Fshr_I8NodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            byte shiftValue_;
            byte rightValue_;
            byte leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            try {
                shiftValue_ = this.shift_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doFshl(leftValue_, rightValue_, shiftValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) {
            byte shiftValue_;
            byte rightValue_;
            byte leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            try {
                shiftValue_ = this.shift_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doFshl(leftValue_, rightValue_, shiftValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private byte executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof Byte) {
                byte leftValue_ = (Byte)leftValue;
                if (rightValue instanceof Byte) {
                    byte rightValue_ = (Byte)rightValue;
                    if (shiftValue instanceof Byte) {
                        byte shiftValue_ = (Byte)shiftValue;
                        this.state_0_ = state_0 |= 2;
                        return this.doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.shift_}, new Object[]{leftValue, rightValue, shiftValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMFunnelShiftNode.Fshr_I8 create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshr_I8NodeGen(left, right, shift);
        }
    }

    @GeneratedBy(value=LLVMFunnelShiftNode.Fshl_I64Vector.class)
    public static final class Fshl_I64VectorNodeGen
    extends LLVMFunnelShiftNode.Fshl_I64Vector
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode shift_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private Fshl_I64VectorNodeGen(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            super(vectorSize);
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object shiftValue_ = this.shift_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 2) != 0 && leftValue_ instanceof LLVMI64Vector) {
                LLVMI64Vector leftValue__ = (LLVMI64Vector)leftValue_;
                if (rightValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector rightValue__ = (LLVMI64Vector)rightValue_;
                    if (shiftValue_ instanceof LLVMI64Vector) {
                        LLVMI64Vector shiftValue__ = (LLVMI64Vector)shiftValue_;
                        return this.doFshl(leftValue__, rightValue__, shiftValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private LLVMI64Vector executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof LLVMI64Vector) {
                LLVMI64Vector leftValue_ = (LLVMI64Vector)leftValue;
                if (rightValue instanceof LLVMI64Vector) {
                    LLVMI64Vector rightValue_ = (LLVMI64Vector)rightValue;
                    if (shiftValue instanceof LLVMI64Vector) {
                        LLVMI64Vector shiftValue_ = (LLVMI64Vector)shiftValue;
                        this.state_0_ = state_0 |= 2;
                        return this.doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.shift_}, new Object[]{leftValue, rightValue, shiftValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMFunnelShiftNode.Fshl_I64Vector create(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshl_I64VectorNodeGen(vectorSize, left, right, shift);
        }
    }

    @GeneratedBy(value=LLVMFunnelShiftNode.Fshl_I64.class)
    public static final class Fshl_I64NodeGen
    extends LLVMFunnelShiftNode.Fshl_I64
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode shift_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private LLVMNativePointerSupport.ToNativePointerNode fshl1_toNativePointerLeft_;
        @Node.Child
        private LLVMNativePointerSupport.ToNativePointerNode fshl1_toNativePointerRight_;

        private Fshl_I64NodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_long_long_long0(state_0, frameValue);
            }
            if ((state_0 & 2) == 0 && (state_0 & 6) != 0) {
                return this.executeGeneric_long1(state_0, frameValue);
            }
            return this.executeGeneric_generic2(state_0, frameValue);
        }

        private Object executeGeneric_long_long_long0(int state_0__, VirtualFrame frameValue) {
            long shiftValue_;
            long rightValue_;
            long leftValue_;
            int state_0 = state_0__;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            try {
                shiftValue_ = this.shift_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            assert ((state_0 & 2) != 0);
            return this.doFshl(leftValue_, rightValue_, shiftValue_);
        }

        private Object executeGeneric_long1(int state_0__, VirtualFrame frameValue) {
            long shiftValue_;
            int state_0 = state_0__;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            try {
                shiftValue_ = this.shift_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            assert ((state_0 & 4) != 0);
            if (LLVMTypesLongPointerGen.isImplicitLLVMPointer((state_0 & 0x18) >>> 3, leftValue_)) {
                LLVMPointer leftValue__ = LLVMTypesLongPointerGen.asImplicitLLVMPointer((state_0 & 0x18) >>> 3, leftValue_);
                if (LLVMTypesLongPointerGen.isImplicitLLVMPointer((state_0 & 0x60) >>> 5, rightValue_)) {
                    LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__;
                    LLVMPointer rightValue__ = LLVMTypesLongPointerGen.asImplicitLLVMPointer((state_0 & 0x60) >>> 5, rightValue_);
                    LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__ = this.fshl1_toNativePointerLeft_;
                    if (toNativePointerLeft__ != null && (toNativePointerRight__ = this.fshl1_toNativePointerRight_) != null) {
                        return this.doFshl(leftValue__, rightValue__, shiftValue_, toNativePointerLeft__, toNativePointerRight__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue) {
            long shiftValue_;
            int state_0 = state_0__;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            try {
                shiftValue_ = this.shift_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 6) != 0) {
                if ((state_0 & 2) != 0 && leftValue_ instanceof Long) {
                    long leftValue__ = (Long)leftValue_;
                    if (rightValue_ instanceof Long) {
                        long rightValue__ = (Long)rightValue_;
                        return this.doFshl(leftValue__, rightValue__, shiftValue_);
                    }
                }
                if ((state_0 & 4) != 0 && LLVMTypesLongPointerGen.isImplicitLLVMPointer((state_0 & 0x18) >>> 3, leftValue_)) {
                    LLVMPointer leftValue__ = LLVMTypesLongPointerGen.asImplicitLLVMPointer((state_0 & 0x18) >>> 3, leftValue_);
                    if (LLVMTypesLongPointerGen.isImplicitLLVMPointer((state_0 & 0x60) >>> 5, rightValue_)) {
                        LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__;
                        LLVMPointer rightValue__ = LLVMTypesLongPointerGen.asImplicitLLVMPointer((state_0 & 0x60) >>> 5, rightValue_);
                        LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__ = this.fshl1_toNativePointerLeft_;
                        if (toNativePointerLeft__ != null && (toNativePointerRight__ = this.fshl1_toNativePointerRight_) != null) {
                            return this.doFshl(leftValue__, rightValue__, shiftValue_, toNativePointerLeft__, toNativePointerRight__);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
                return this.executeI64_long_long_long3(state_0, frameValue);
            }
            if ((state_0 & 2) == 0 && (state_0 & 6) != 0) {
                return this.executeI64_long4(state_0, frameValue);
            }
            return this.executeI64_generic5(state_0, frameValue);
        }

        private long executeI64_long_long_long3(int state_0__, VirtualFrame frameValue) {
            long shiftValue_;
            long rightValue_;
            long leftValue_;
            int state_0 = state_0__;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            try {
                shiftValue_ = this.shift_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            assert ((state_0 & 2) != 0);
            return this.doFshl(leftValue_, rightValue_, shiftValue_);
        }

        private long executeI64_long4(int state_0__, VirtualFrame frameValue) {
            long shiftValue_;
            int state_0 = state_0__;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            try {
                shiftValue_ = this.shift_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            assert ((state_0 & 4) != 0);
            if (LLVMTypesLongPointerGen.isImplicitLLVMPointer((state_0 & 0x18) >>> 3, leftValue_)) {
                LLVMPointer leftValue__ = LLVMTypesLongPointerGen.asImplicitLLVMPointer((state_0 & 0x18) >>> 3, leftValue_);
                if (LLVMTypesLongPointerGen.isImplicitLLVMPointer((state_0 & 0x60) >>> 5, rightValue_)) {
                    LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__;
                    LLVMPointer rightValue__ = LLVMTypesLongPointerGen.asImplicitLLVMPointer((state_0 & 0x60) >>> 5, rightValue_);
                    LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__ = this.fshl1_toNativePointerLeft_;
                    if (toNativePointerLeft__ != null && (toNativePointerRight__ = this.fshl1_toNativePointerRight_) != null) {
                        return this.doFshl(leftValue__, rightValue__, shiftValue_, toNativePointerLeft__, toNativePointerRight__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private long executeI64_generic5(int state_0__, VirtualFrame frameValue) {
            long shiftValue_;
            int state_0 = state_0__;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            try {
                shiftValue_ = this.shift_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 6) != 0) {
                if ((state_0 & 2) != 0 && leftValue_ instanceof Long) {
                    long leftValue__ = (Long)leftValue_;
                    if (rightValue_ instanceof Long) {
                        long rightValue__ = (Long)rightValue_;
                        return this.doFshl(leftValue__, rightValue__, shiftValue_);
                    }
                }
                if ((state_0 & 4) != 0 && LLVMTypesLongPointerGen.isImplicitLLVMPointer((state_0 & 0x18) >>> 3, leftValue_)) {
                    LLVMPointer leftValue__ = LLVMTypesLongPointerGen.asImplicitLLVMPointer((state_0 & 0x18) >>> 3, leftValue_);
                    if (LLVMTypesLongPointerGen.isImplicitLLVMPointer((state_0 & 0x60) >>> 5, rightValue_)) {
                        LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__;
                        LLVMPointer rightValue__ = LLVMTypesLongPointerGen.asImplicitLLVMPointer((state_0 & 0x60) >>> 5, rightValue_);
                        LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__ = this.fshl1_toNativePointerLeft_;
                        if (toNativePointerLeft__ != null && (toNativePointerRight__ = this.fshl1_toNativePointerRight_) != null) {
                            return this.doFshl(leftValue__, rightValue__, shiftValue_, toNativePointerLeft__, toNativePointerRight__);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private long executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (shiftValue instanceof Long) {
                int lLVMPointerCast0;
                long shiftValue_ = (Long)shiftValue;
                if (leftValue instanceof Long) {
                    long leftValue_ = (Long)leftValue;
                    if (rightValue instanceof Long) {
                        long rightValue_ = (Long)rightValue;
                        this.state_0_ = state_0 |= 2;
                        return this.doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
                if ((lLVMPointerCast0 = LLVMTypesLongPointerGen.specializeImplicitLLVMPointer(leftValue)) != 0) {
                    LLVMPointer leftValue_ = LLVMTypesLongPointerGen.asImplicitLLVMPointer(lLVMPointerCast0, leftValue);
                    int lLVMPointerCast1 = LLVMTypesLongPointerGen.specializeImplicitLLVMPointer(rightValue);
                    if (lLVMPointerCast1 != 0) {
                        LLVMPointer rightValue_ = LLVMTypesLongPointerGen.asImplicitLLVMPointer(lLVMPointerCast1, rightValue);
                        LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__ = (LLVMNativePointerSupport.ToNativePointerNode)this.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
                        Objects.requireNonNull(toNativePointerLeft__, "Specialization 'doFshl(LLVMPointer, LLVMPointer, long, ToNativePointerNode, ToNativePointerNode)' cache 'toNativePointerLeft' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.fshl1_toNativePointerLeft_ = toNativePointerLeft__;
                        LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__ = (LLVMNativePointerSupport.ToNativePointerNode)this.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
                        Objects.requireNonNull(toNativePointerRight__, "Specialization 'doFshl(LLVMPointer, LLVMPointer, long, ToNativePointerNode, ToNativePointerNode)' cache 'toNativePointerRight' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.fshl1_toNativePointerRight_ = toNativePointerRight__;
                        state_0 |= lLVMPointerCast0 << 3;
                        state_0 |= lLVMPointerCast1 << 5;
                        this.state_0_ = state_0 |= 4;
                        return this.doFshl(leftValue_, rightValue_, shiftValue_, toNativePointerLeft__, toNativePointerRight__);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.shift_}, new Object[]{leftValue, rightValue, shiftValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 6) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 6 & (state_0 & 6) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft__ = (LLVMNativePointerSupport.ToNativePointerNode)this.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
            Objects.requireNonNull(toNativePointerLeft__, "Specialization 'doFshl(LLVMPointer, LLVMPointer, long, ToNativePointerNode, ToNativePointerNode)' cache 'toNativePointerLeft' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.fshl1_toNativePointerLeft_ = toNativePointerLeft__;
            LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight__ = (LLVMNativePointerSupport.ToNativePointerNode)this.insert(LLVMNativePointerSupportFactory.ToNativePointerNodeGen.create());
            Objects.requireNonNull(toNativePointerRight__, "Specialization 'doFshl(LLVMPointer, LLVMPointer, long, ToNativePointerNode, ToNativePointerNode)' cache 'toNativePointerRight' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.fshl1_toNativePointerRight_ = toNativePointerRight__;
            assert (NodeUtil.assertRecursion((Node)this.fshl1_toNativePointerLeft_, (int)1));
            ((GenerateAOT.Provider)this.fshl1_toNativePointerLeft_).prepareForAOT(language, root);
            assert (NodeUtil.assertRecursion((Node)this.fshl1_toNativePointerRight_, (int)1));
            ((GenerateAOT.Provider)this.fshl1_toNativePointerRight_).prepareForAOT(language, root);
            this.state_0_ |= 4;
            int state_0 = this.state_0_;
            state_0 |= 1;
            this.state_0_ = state_0 |= 0x78;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.fshl1_toNativePointerLeft_ = null;
            this.fshl1_toNativePointerRight_ = null;
        }

        @NeverDefault
        public static LLVMFunnelShiftNode.Fshl_I64 create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshl_I64NodeGen(left, right, shift);
        }
    }

    @GeneratedBy(value=LLVMFunnelShiftNode.Fshl_I32Vector.class)
    public static final class Fshl_I32VectorNodeGen
    extends LLVMFunnelShiftNode.Fshl_I32Vector
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode shift_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private Fshl_I32VectorNodeGen(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            super(vectorSize);
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object shiftValue_ = this.shift_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 2) != 0 && leftValue_ instanceof LLVMI32Vector) {
                LLVMI32Vector leftValue__ = (LLVMI32Vector)leftValue_;
                if (rightValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector rightValue__ = (LLVMI32Vector)rightValue_;
                    if (shiftValue_ instanceof LLVMI32Vector) {
                        LLVMI32Vector shiftValue__ = (LLVMI32Vector)shiftValue_;
                        return this.doFshl(leftValue__, rightValue__, shiftValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private LLVMI32Vector executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof LLVMI32Vector) {
                LLVMI32Vector leftValue_ = (LLVMI32Vector)leftValue;
                if (rightValue instanceof LLVMI32Vector) {
                    LLVMI32Vector rightValue_ = (LLVMI32Vector)rightValue;
                    if (shiftValue instanceof LLVMI32Vector) {
                        LLVMI32Vector shiftValue_ = (LLVMI32Vector)shiftValue;
                        this.state_0_ = state_0 |= 2;
                        return this.doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.shift_}, new Object[]{leftValue, rightValue, shiftValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMFunnelShiftNode.Fshl_I32Vector create(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshl_I32VectorNodeGen(vectorSize, left, right, shift);
        }
    }

    @GeneratedBy(value=LLVMFunnelShiftNode.Fshl_I32.class)
    public static final class Fshl_I32NodeGen
    extends LLVMFunnelShiftNode.Fshl_I32
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode shift_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private Fshl_I32NodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int shiftValue_;
            int rightValue_;
            int leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            try {
                shiftValue_ = this.shift_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doFshl(leftValue_, rightValue_, shiftValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int shiftValue_;
            int rightValue_;
            int leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            try {
                shiftValue_ = this.shift_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doFshl(leftValue_, rightValue_, shiftValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private int executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof Integer) {
                int leftValue_ = (Integer)leftValue;
                if (rightValue instanceof Integer) {
                    int rightValue_ = (Integer)rightValue;
                    if (shiftValue instanceof Integer) {
                        int shiftValue_ = (Integer)shiftValue;
                        this.state_0_ = state_0 |= 2;
                        return this.doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.shift_}, new Object[]{leftValue, rightValue, shiftValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMFunnelShiftNode.Fshl_I32 create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshl_I32NodeGen(left, right, shift);
        }
    }

    @GeneratedBy(value=LLVMFunnelShiftNode.Fshl_I16Vector.class)
    public static final class Fshl_I16VectorNodeGen
    extends LLVMFunnelShiftNode.Fshl_I16Vector
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode shift_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private Fshl_I16VectorNodeGen(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            super(vectorSize);
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object shiftValue_ = this.shift_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 2) != 0 && leftValue_ instanceof LLVMI16Vector) {
                LLVMI16Vector leftValue__ = (LLVMI16Vector)leftValue_;
                if (rightValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector rightValue__ = (LLVMI16Vector)rightValue_;
                    if (shiftValue_ instanceof LLVMI16Vector) {
                        LLVMI16Vector shiftValue__ = (LLVMI16Vector)shiftValue_;
                        return this.doFshl(leftValue__, rightValue__, shiftValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private LLVMI16Vector executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof LLVMI16Vector) {
                LLVMI16Vector leftValue_ = (LLVMI16Vector)leftValue;
                if (rightValue instanceof LLVMI16Vector) {
                    LLVMI16Vector rightValue_ = (LLVMI16Vector)rightValue;
                    if (shiftValue instanceof LLVMI16Vector) {
                        LLVMI16Vector shiftValue_ = (LLVMI16Vector)shiftValue;
                        this.state_0_ = state_0 |= 2;
                        return this.doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.shift_}, new Object[]{leftValue, rightValue, shiftValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMFunnelShiftNode.Fshl_I16Vector create(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshl_I16VectorNodeGen(vectorSize, left, right, shift);
        }
    }

    @GeneratedBy(value=LLVMFunnelShiftNode.Fshl_I16.class)
    public static final class Fshl_I16NodeGen
    extends LLVMFunnelShiftNode.Fshl_I16
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode shift_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private Fshl_I16NodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            short shiftValue_;
            short rightValue_;
            short leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            try {
                shiftValue_ = this.shift_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doFshl(leftValue_, rightValue_, shiftValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        @Override
        public short executeI16(VirtualFrame frameValue) {
            short shiftValue_;
            short rightValue_;
            short leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            try {
                shiftValue_ = this.shift_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doFshl(leftValue_, rightValue_, shiftValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private short executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof Short) {
                short leftValue_ = (Short)leftValue;
                if (rightValue instanceof Short) {
                    short rightValue_ = (Short)rightValue;
                    if (shiftValue instanceof Short) {
                        short shiftValue_ = (Short)shiftValue;
                        this.state_0_ = state_0 |= 2;
                        return this.doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.shift_}, new Object[]{leftValue, rightValue, shiftValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMFunnelShiftNode.Fshl_I16 create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshl_I16NodeGen(left, right, shift);
        }
    }

    @GeneratedBy(value=LLVMFunnelShiftNode.Fshl_I8Vector.class)
    public static final class Fshl_I8VectorNodeGen
    extends LLVMFunnelShiftNode.Fshl_I8Vector
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode shift_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private Fshl_I8VectorNodeGen(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            super(vectorSize);
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object shiftValue_ = this.shift_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 2) != 0 && leftValue_ instanceof LLVMI8Vector) {
                LLVMI8Vector leftValue__ = (LLVMI8Vector)leftValue_;
                if (rightValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector rightValue__ = (LLVMI8Vector)rightValue_;
                    if (shiftValue_ instanceof LLVMI8Vector) {
                        LLVMI8Vector shiftValue__ = (LLVMI8Vector)shiftValue_;
                        return this.doFshl(leftValue__, rightValue__, shiftValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private LLVMI8Vector executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof LLVMI8Vector) {
                LLVMI8Vector leftValue_ = (LLVMI8Vector)leftValue;
                if (rightValue instanceof LLVMI8Vector) {
                    LLVMI8Vector rightValue_ = (LLVMI8Vector)rightValue;
                    if (shiftValue instanceof LLVMI8Vector) {
                        LLVMI8Vector shiftValue_ = (LLVMI8Vector)shiftValue;
                        this.state_0_ = state_0 |= 2;
                        return this.doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.shift_}, new Object[]{leftValue, rightValue, shiftValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMFunnelShiftNode.Fshl_I8Vector create(int vectorSize, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshl_I8VectorNodeGen(vectorSize, left, right, shift);
        }
    }

    @GeneratedBy(value=LLVMFunnelShiftNode.Fshl_I8.class)
    public static final class Fshl_I8NodeGen
    extends LLVMFunnelShiftNode.Fshl_I8
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @Node.Child
        private LLVMExpressionNode shift_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private Fshl_I8NodeGen(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            this.left_ = left;
            this.right_ = right;
            this.shift_ = shift;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            byte shiftValue_;
            byte rightValue_;
            byte leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            try {
                shiftValue_ = this.shift_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doFshl(leftValue_, rightValue_, shiftValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) {
            byte shiftValue_;
            byte rightValue_;
            byte leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue, shiftValue);
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object shiftValue = this.shift_.executeGeneric(frameValue);
                return this.executeAndSpecialize(leftValue_, ex.getResult(), shiftValue);
            }
            try {
                shiftValue_ = this.shift_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftValue_, rightValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doFshl(leftValue_, rightValue_, shiftValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_, shiftValue_);
        }

        private byte executeAndSpecialize(Object leftValue, Object rightValue, Object shiftValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof Byte) {
                byte leftValue_ = (Byte)leftValue;
                if (rightValue instanceof Byte) {
                    byte rightValue_ = (Byte)rightValue;
                    if (shiftValue instanceof Byte) {
                        byte shiftValue_ = (Byte)shiftValue;
                        this.state_0_ = state_0 |= 2;
                        return this.doFshl(leftValue_, rightValue_, shiftValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_, this.shift_}, new Object[]{leftValue, rightValue, shiftValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMFunnelShiftNode.Fshl_I8 create(LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode shift) {
            return new Fshl_I8NodeGen(left, right, shift);
        }
    }
}

