/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.LLVMVarArgCompoundValue;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMStructStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMStructStoreNode.class)
public final class LLVMStructStoreNodeGen
extends LLVMStructStoreNode
implements GenerateAOT.Provider {
    private final long structSize;
    @Node.Child
    private LLVMExpressionNode address_;
    @Node.Child
    private LLVMExpressionNode value_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;
    @Node.Child
    private LLVMDerefHandleGetReceiverNode opDerefHandle_getReceiver_;
    @Node.Child
    private ConvertData convert_cache;
    @Node.Child
    private VarArgCompoundValueData varArgCompoundValue_cache;

    private LLVMStructStoreNodeGen(LLVMMemMoveNode memMove, boolean isRecursive, LLVMExpressionNode address, LLVMExpressionNode value, long structSize) {
        super(memMove, isRecursive);
        this.structSize = structSize;
        this.address_ = address;
        this.value_ = value;
    }

    private LLVMStructStoreNodeGen(LLVMMemMoveNode memMove, LLVMExpressionNode address, LLVMExpressionNode value, long structSize) {
        super(memMove);
        this.structSize = structSize;
        this.address_ = address;
        this.value_ = value;
    }

    private LLVMStructStoreNodeGen(LLVMExpressionNode address, LLVMExpressionNode value, long structSize) {
        this.structSize = structSize;
        this.address_ = address;
        this.value_ = value;
    }

    private LLVMStructStoreNodeGen(boolean isRecursive, LLVMExpressionNode address, LLVMExpressionNode value, long structSize) {
        super(isRecursive);
        this.structSize = structSize;
        this.address_ = address;
        this.value_ = value;
    }

    @Override
    @Idempotent
    public long getStructSize() {
        return this.structSize;
    }

    @Override
    public void executeWithTarget(Object addressValue, Object valueValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            this.executeAndSpecialize(addressValue, valueValue);
            return;
        }
        if ((state_0 & 0x7E) != 0) {
            Object valueValue_;
            LLVMNativePointer addressValue_;
            if ((state_0 & 2) != 0) {
                assert (DSLSupport.assertIdempotence((this.getStructSize() == 0L ? (byte)1 : 0) != 0));
                this.noCopy(addressValue, valueValue);
                return;
            }
            if ((state_0 & 0x14) != 0 && LLVMTypes.isNativePointer(addressValue)) {
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if (LLVMTypes.isNativePointer(valueValue)) {
                    LLVMDerefHandleGetReceiverNode getReceiver__;
                    valueValue_ = LLVMTypes.asNativePointer(valueValue);
                    if ((state_0 & 4) != 0) {
                        assert (DSLSupport.assertIdempotence((this.getStructSize() > 0L ? (byte)1 : 0) != 0));
                        if (!this.isAutoDerefHandle(addressValue_) && !this.isAutoDerefHandle((LLVMNativePointer)valueValue_)) {
                            this.doOp(addressValue_, (LLVMNativePointer)valueValue_);
                            return;
                        }
                    }
                    if ((state_0 & 0x10) != 0 && (getReceiver__ = this.opDerefHandle_getReceiver_) != null) {
                        assert (DSLSupport.assertIdempotence((this.getStructSize() > 0L ? (byte)1 : 0) != 0));
                        if (this.isAutoDerefHandle(addressValue_) && this.isAutoDerefHandle((LLVMNativePointer)valueValue_)) {
                            this.doOpDerefHandle(addressValue_, (LLVMNativePointer)valueValue_, getReceiver__);
                            return;
                        }
                    }
                }
            }
            if ((state_0 & 0x28) != 0 && LLVMTypes.isPointer(valueValue)) {
                LLVMPointer addressValue_2;
                LLVMPointer valueValue_2 = LLVMTypes.asPointer(valueValue);
                if ((state_0 & 0x20) != 0 && LLVMTypes.isManagedPointer(addressValue)) {
                    addressValue_2 = LLVMTypes.asManagedPointer(addressValue);
                    assert (DSLSupport.assertIdempotence((this.getStructSize() > 0L ? (byte)1 : 0) != 0));
                    this.doManaged((LLVMManagedPointer)addressValue_2, valueValue_2);
                    return;
                }
                if ((state_0 & 8) != 0 && LLVMTypes.isNativePointer(addressValue)) {
                    addressValue_2 = LLVMTypes.asNativePointer(addressValue);
                    ConvertData s4_ = this.convert_cache;
                    if (s4_ != null) {
                        assert (DSLSupport.assertIdempotence((this.getStructSize() > 0L ? (byte)1 : 0) != 0));
                        if (!this.isAutoDerefHandle((LLVMNativePointer)addressValue_2)) {
                            this.doConvert((LLVMNativePointer)addressValue_2, valueValue_2, s4_.toNative_);
                            return;
                        }
                    }
                }
            }
            if ((state_0 & 0x40) != 0 && LLVMTypes.isNativePointer(addressValue)) {
                addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if (valueValue instanceof LLVMVarArgCompoundValue) {
                    valueValue_ = (LLVMVarArgCompoundValue)valueValue;
                    VarArgCompoundValueData s5_ = this.varArgCompoundValue_cache;
                    if (s5_ != null) {
                        assert (DSLSupport.assertIdempotence((!this.isRecursive ? (byte)1 : 0) != 0));
                        this.doVarArgCompoundValue(addressValue_, (LLVMVarArgCompoundValue)valueValue_, s5_.recursionNode_);
                        return;
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(addressValue, valueValue);
    }

    @Override
    public void execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        Object valueValue_ = this.value_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            this.executeAndSpecialize(addressValue_, valueValue_);
            return;
        }
        if ((state_0 & 0x7E) != 0) {
            Object valueValue__;
            LLVMNativePointer addressValue__;
            if ((state_0 & 2) != 0) {
                assert (DSLSupport.assertIdempotence((this.getStructSize() == 0L ? (byte)1 : 0) != 0));
                this.noCopy(addressValue_, valueValue_);
                return;
            }
            if ((state_0 & 0x14) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
                addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if (LLVMTypes.isNativePointer(valueValue_)) {
                    LLVMDerefHandleGetReceiverNode getReceiver__;
                    valueValue__ = LLVMTypes.asNativePointer(valueValue_);
                    if ((state_0 & 4) != 0) {
                        assert (DSLSupport.assertIdempotence((this.getStructSize() > 0L ? (byte)1 : 0) != 0));
                        if (!this.isAutoDerefHandle(addressValue__) && !this.isAutoDerefHandle((LLVMNativePointer)valueValue__)) {
                            this.doOp(addressValue__, (LLVMNativePointer)valueValue__);
                            return;
                        }
                    }
                    if ((state_0 & 0x10) != 0 && (getReceiver__ = this.opDerefHandle_getReceiver_) != null) {
                        assert (DSLSupport.assertIdempotence((this.getStructSize() > 0L ? (byte)1 : 0) != 0));
                        if (this.isAutoDerefHandle(addressValue__) && this.isAutoDerefHandle((LLVMNativePointer)valueValue__)) {
                            this.doOpDerefHandle(addressValue__, (LLVMNativePointer)valueValue__, getReceiver__);
                            return;
                        }
                    }
                }
            }
            if ((state_0 & 0x28) != 0 && LLVMTypes.isPointer(valueValue_)) {
                LLVMPointer addressValue__2;
                LLVMPointer valueValue__2 = LLVMTypes.asPointer(valueValue_);
                if ((state_0 & 0x20) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
                    addressValue__2 = LLVMTypes.asManagedPointer(addressValue_);
                    assert (DSLSupport.assertIdempotence((this.getStructSize() > 0L ? (byte)1 : 0) != 0));
                    this.doManaged((LLVMManagedPointer)addressValue__2, valueValue__2);
                    return;
                }
                if ((state_0 & 8) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
                    addressValue__2 = LLVMTypes.asNativePointer(addressValue_);
                    ConvertData s4_ = this.convert_cache;
                    if (s4_ != null) {
                        assert (DSLSupport.assertIdempotence((this.getStructSize() > 0L ? (byte)1 : 0) != 0));
                        if (!this.isAutoDerefHandle((LLVMNativePointer)addressValue__2)) {
                            this.doConvert((LLVMNativePointer)addressValue__2, valueValue__2, s4_.toNative_);
                            return;
                        }
                    }
                }
            }
            if ((state_0 & 0x40) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
                addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if (valueValue_ instanceof LLVMVarArgCompoundValue) {
                    valueValue__ = (LLVMVarArgCompoundValue)valueValue_;
                    VarArgCompoundValueData s5_ = this.varArgCompoundValue_cache;
                    if (s5_ != null) {
                        assert (DSLSupport.assertIdempotence((!this.isRecursive ? (byte)1 : 0) != 0));
                        this.doVarArgCompoundValue(addressValue__, (LLVMVarArgCompoundValue)valueValue__, s5_.recursionNode_);
                        return;
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(addressValue_, valueValue_);
    }

    private void executeAndSpecialize(Object addressValue, Object valueValue) {
        Object valueValue_;
        LLVMNativePointer addressValue_;
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (this.getStructSize() == 0L) {
            this.state_0_ = state_0 |= 2;
            this.noCopy(addressValue, valueValue);
            return;
        }
        if (LLVMTypes.isNativePointer(addressValue)) {
            addressValue_ = LLVMTypes.asNativePointer(addressValue);
            if (LLVMTypes.isNativePointer(valueValue)) {
                valueValue_ = LLVMTypes.asNativePointer(valueValue);
                if ((state_0 & 8) == 0 && this.getStructSize() > 0L && !this.isAutoDerefHandle(addressValue_) && !this.isAutoDerefHandle((LLVMNativePointer)valueValue_)) {
                    this.state_0_ = state_0 |= 4;
                    this.doOp(addressValue_, (LLVMNativePointer)valueValue_);
                    return;
                }
                if (this.getStructSize() > 0L && this.isAutoDerefHandle(addressValue_) && this.isAutoDerefHandle((LLVMNativePointer)valueValue_)) {
                    LLVMDerefHandleGetReceiverNode getReceiver__ = (LLVMDerefHandleGetReceiverNode)this.insert(LLVMDerefHandleGetReceiverNodeGen.create());
                    Objects.requireNonNull(getReceiver__, "Specialization 'doOpDerefHandle(LLVMNativePointer, LLVMNativePointer, LLVMDerefHandleGetReceiverNode)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.opDerefHandle_getReceiver_ = getReceiver__;
                    this.state_0_ = state_0 |= 0x10;
                    this.doOpDerefHandle(addressValue_, (LLVMNativePointer)valueValue_, getReceiver__);
                    return;
                }
            }
        }
        if (LLVMTypes.isPointer(valueValue)) {
            LLVMPointer addressValue_2;
            LLVMPointer valueValue_2 = LLVMTypes.asPointer(valueValue);
            if (LLVMTypes.isManagedPointer(addressValue)) {
                addressValue_2 = LLVMTypes.asManagedPointer(addressValue);
                if (this.getStructSize() > 0L) {
                    this.state_0_ = state_0 |= 0x20;
                    this.doManaged((LLVMManagedPointer)addressValue_2, valueValue_2);
                    return;
                }
            }
            if (LLVMTypes.isNativePointer(addressValue)) {
                addressValue_2 = LLVMTypes.asNativePointer(addressValue);
                if (this.getStructSize() > 0L && !this.isAutoDerefHandle((LLVMNativePointer)addressValue_2)) {
                    ConvertData s4_ = (ConvertData)this.insert(new ConvertData());
                    s4_.toNative_ = (LLVMToNativeNode)s4_.insert(LLVMToNativeNode.createToNativeWithTarget());
                    VarHandle.storeStoreFence();
                    this.convert_cache = s4_;
                    state_0 &= 0xFFFFFFFB;
                    this.state_0_ = state_0 |= 8;
                    this.doConvert((LLVMNativePointer)addressValue_2, valueValue_2, s4_.toNative_);
                    return;
                }
            }
        }
        if (LLVMTypes.isNativePointer(addressValue)) {
            addressValue_ = LLVMTypes.asNativePointer(addressValue);
            if (valueValue instanceof LLVMVarArgCompoundValue) {
                valueValue_ = (LLVMVarArgCompoundValue)valueValue;
                if (!this.isRecursive) {
                    VarArgCompoundValueData s5_ = (VarArgCompoundValueData)this.insert(new VarArgCompoundValueData());
                    s5_.recursionNode_ = (LLVMStructStoreNode)s5_.insert(this.createRecursive());
                    VarHandle.storeStoreFence();
                    this.varArgCompoundValue_cache = s5_;
                    this.state_0_ = state_0 |= 0x40;
                    this.doVarArgCompoundValue(addressValue_, (LLVMVarArgCompoundValue)valueValue_, s5_.recursionNode_);
                    return;
                }
            }
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_, this.value_}, new Object[]{addressValue, valueValue});
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0x7E) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 0x7E & (state_0 & 0x7E) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        if ((this.state_0_ & 1) != 0) {
            return;
        }
        if (this.getStructSize() == 0L) {
            this.state_0_ |= 2;
        }
        if (this.getStructSize() > 0L) {
            LLVMDerefHandleGetReceiverNode getReceiver__ = (LLVMDerefHandleGetReceiverNode)this.insert(LLVMDerefHandleGetReceiverNodeGen.create());
            Objects.requireNonNull(getReceiver__, "Specialization 'doOpDerefHandle(LLVMNativePointer, LLVMNativePointer, LLVMDerefHandleGetReceiverNode)' cache 'getReceiver' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.opDerefHandle_getReceiver_ = getReceiver__;
            assert (NodeUtil.assertRecursion((Node)this.opDerefHandle_getReceiver_, (int)1));
            ((GenerateAOT.Provider)this.opDerefHandle_getReceiver_).prepareForAOT(language, root);
            this.state_0_ |= 0x10;
        }
        if (this.getStructSize() > 0L) {
            this.state_0_ |= 0x20;
        }
        if (this.getStructSize() > 0L) {
            ConvertData s4_ = (ConvertData)this.insert(new ConvertData());
            s4_.toNative_ = (LLVMToNativeNode)s4_.insert(LLVMToNativeNode.createToNativeWithTarget());
            VarHandle.storeStoreFence();
            this.convert_cache = s4_;
            this.state_0_ &= 0xFFFFFFFB;
            assert (NodeUtil.assertRecursion((Node)s4_.toNative_, (int)1));
            ((GenerateAOT.Provider)s4_.toNative_).prepareForAOT(language, root);
            this.state_0_ |= 8;
        }
        if (!this.isRecursive) {
            VarArgCompoundValueData s5_ = (VarArgCompoundValueData)this.insert(new VarArgCompoundValueData());
            s5_.recursionNode_ = (LLVMStructStoreNode)s5_.insert(this.createRecursive());
            VarHandle.storeStoreFence();
            this.varArgCompoundValue_cache = s5_;
            assert (NodeUtil.assertRecursion((Node)s5_.recursionNode_, (int)1));
            ((GenerateAOT.Provider)s5_.recursionNode_).prepareForAOT(language, root);
            this.state_0_ |= 0x40;
        }
        int state_0 = this.state_0_;
        this.state_0_ = state_0 |= 1;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if ((state_0 & 1) == 0) {
            return;
        }
        this.state_0_ = 0;
        this.opDerefHandle_getReceiver_ = null;
        this.convert_cache = null;
        this.varArgCompoundValue_cache = null;
    }

    @NeverDefault
    public static LLVMStructStoreNode create(LLVMMemMoveNode memMove, boolean isRecursive, LLVMExpressionNode address, LLVMExpressionNode value, long structSize) {
        return new LLVMStructStoreNodeGen(memMove, isRecursive, address, value, structSize);
    }

    @NeverDefault
    public static LLVMStructStoreNode create(LLVMMemMoveNode memMove, LLVMExpressionNode address, LLVMExpressionNode value, long structSize) {
        return new LLVMStructStoreNodeGen(memMove, address, value, structSize);
    }

    @NeverDefault
    public static LLVMStructStoreNode create(LLVMExpressionNode address, LLVMExpressionNode value, long structSize) {
        return new LLVMStructStoreNodeGen(address, value, structSize);
    }

    @NeverDefault
    public static LLVMStructStoreNode create(boolean isRecursive, LLVMExpressionNode address, LLVMExpressionNode value, long structSize) {
        return new LLVMStructStoreNodeGen(isRecursive, address, value, structSize);
    }

    @GeneratedBy(value=LLVMStructStoreNode.class)
    @DenyReplace
    private static final class ConvertData
    extends Node
    implements DSLSupport.SpecializationDataNode {
        @Node.Child
        LLVMToNativeNode toNative_;

        ConvertData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    @GeneratedBy(value=LLVMStructStoreNode.class)
    @DenyReplace
    private static final class VarArgCompoundValueData
    extends Node
    implements DSLSupport.SpecializationDataNode {
        @Node.Child
        LLVMStructStoreNode recursionNode_;

        VarArgCompoundValueData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }
}

