/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.move;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMCopyTargetLibrary;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMNoOpNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.literals.LLVMSimpleLiteralNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.move.LLVMPrimitiveMoveNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.ArrayList;
import java.util.List;

public abstract class LLVMPrimitiveMoveNode
extends LLVMNode {
    private static final int LENGTH_LIMIT_FOR_REPLACEMENT = 64;
    private static final int LENGTH_ARG_INDEX = 3;
    private static final int DEST_ARG_INDEX = 1;
    private static final int SOURCE_ARG_INDEX = 2;
    @Node.Child
    private LLVMLoadNode loadNode;
    @Node.Child
    private LLVMStoreNode storeNode;
    @Node.Child
    private LLVMPrimitiveMoveNode nextPrimitiveMoveNode;
    private final long step;

    public LLVMPrimitiveMoveNode(LLVMLoadNode loadNode, LLVMStoreNode storeNode, LLVMPrimitiveMoveNode nextPrimitiveMoveNode, long step) {
        this.loadNode = loadNode;
        this.storeNode = storeNode;
        this.nextPrimitiveMoveNode = nextPrimitiveMoveNode;
        this.step = step;
    }

    public abstract void executeWithTarget(LLVMPointer var1, LLVMPointer var2, boolean var3);

    @Specialization(guards={"forwardCopy"})
    void moveNormalDir(LLVMPointer srcPtr, LLVMPointer destPtr, boolean forwardCopy) {
        Object val = this.loadNode.executeWithTargetGeneric(srcPtr);
        this.storeNode.executeWithTarget(destPtr, val);
        if (this.nextPrimitiveMoveNode != null) {
            this.nextPrimitiveMoveNode.executeWithTarget(srcPtr.increment(this.step), destPtr.increment(this.step), forwardCopy);
        }
    }

    @Specialization(guards={"!forwardCopy"})
    void moveReverseDir(LLVMPointer src, LLVMPointer dest, boolean forwardCopy) {
        LLVMPointer srcPtr = src.increment(-this.step);
        Object val = this.loadNode.executeWithTargetGeneric(srcPtr);
        LLVMPointer destPtr = dest.increment(-this.step);
        this.storeNode.executeWithTarget(destPtr, val);
        if (this.nextPrimitiveMoveNode != null) {
            this.nextPrimitiveMoveNode.executeWithTarget(srcPtr, destPtr, forwardCopy);
        }
    }

    public static LLVMExpressionNode createSerialMoves(LLVMExpressionNode[] args, NodeFactory nodeFactory, LLVMMemMoveNode memMoveNode) {
        LLVMExpressionNode sourceNode = args[2];
        LLVMExpressionNode destNode = args[1];
        LLVMExpressionNode lengthArgNode = args[3];
        if (lengthArgNode instanceof LLVMSimpleLiteralNode) {
            long len = Long.MAX_VALUE;
            if (lengthArgNode instanceof LLVMSimpleLiteralNode.LLVMI64LiteralNode) {
                len = ((LLVMSimpleLiteralNode.LLVMI64LiteralNode)lengthArgNode).doI64();
            } else if (lengthArgNode instanceof LLVMSimpleLiteralNode.LLVMI32LiteralNode) {
                len = ((LLVMSimpleLiteralNode.LLVMI32LiteralNode)lengthArgNode).doI32();
            }
            if (len <= 0L) {
                return LLVMNoOpNodeGen.create();
            }
            if (len < 64L) {
                int i;
                ArrayList<Type> moveTypes = new ArrayList<Type>();
                long m = len;
                long n = m / 8L;
                if (n > 0L) {
                    i = 0;
                    while ((long)i < n) {
                        moveTypes.add(PrimitiveType.I64);
                        ++i;
                    }
                }
                if ((n = (m %= 8L) / 4L) > 0L) {
                    i = 0;
                    while ((long)i < n) {
                        moveTypes.add(PrimitiveType.I32);
                        ++i;
                    }
                }
                if ((n = (m %= 4L) / 2L) > 0L) {
                    i = 0;
                    while ((long)i < n) {
                        moveTypes.add(PrimitiveType.I16);
                        ++i;
                    }
                }
                if ((n = m % 2L) > 0L) {
                    moveTypes.add(PrimitiveType.I8);
                }
                return LLVMPrimitiveMoveNode.createScalarMemMoveSeries(moveTypes, destNode, sourceNode, nodeFactory, len, memMoveNode);
            }
        }
        return null;
    }

    private static LLVMExpressionNode createScalarMemMoveSeries(List<Type> moveTypes, LLVMExpressionNode dest, LLVMExpressionNode source, NodeFactory nodeFactory, long length, LLVMMemMoveNode memMoveNode) {
        assert (!moveTypes.isEmpty());
        LLVMPrimitiveMoveNode primitiveMoveNode = null;
        for (Type memberType : moveTypes) {
            LLVMExpressionNode loadNode = nodeFactory.createExtractValue(memberType, null);
            assert (loadNode instanceof LLVMLoadNode);
            LLVMStatementNode storeNode = nodeFactory.createStore(null, null, memberType);
            assert (storeNode instanceof LLVMStoreNode);
            try {
                long step = nodeFactory.getDataLayout().getByteSize(memberType);
                primitiveMoveNode = LLVMPrimitiveMoveNodeGen.create((LLVMLoadNode)loadNode, (LLVMStoreNode)storeNode, primitiveMoveNode, step);
            }
            catch (Type.TypeOverflowException e) {
                throw Type.throwOverflowExceptionAsLLVMException(primitiveMoveNode, e);
            }
        }
        return LLVMPrimitiveMoveNodeGen.HeadNodeGen.create(length, primitiveMoveNode, memMoveNode, source, dest);
    }

    @NodeChildren(value={@NodeChild(value="source", type=LLVMExpressionNode.class), @NodeChild(value="destination", type=LLVMExpressionNode.class)})
    public static abstract class HeadNode
    extends LLVMExpressionNode {
        private final long length;
        @Node.Child
        private LLVMPrimitiveMoveNode primitiveMoveNode;
        @Node.Child
        private LLVMMemMoveNode memMoveNode;

        protected HeadNode(long length, LLVMPrimitiveMoveNode primitiveMoveNode, LLVMMemMoveNode memMoveNode) {
            this.length = length;
            this.primitiveMoveNode = primitiveMoveNode;
            this.memMoveNode = memMoveNode;
        }

        public abstract Object executeWithTarget(LLVMPointer var1, LLVMPointer var2);

        boolean doCustomCopy(LLVMPointer sourcePtr, LLVMPointer destPtr, LLVMCopyTargetLibrary copyTargetLib) {
            Object src = HeadNode.getReceiver(sourcePtr);
            if (src == null) {
                return false;
            }
            Object dest = HeadNode.getReceiver(destPtr);
            if (dest == null) {
                return false;
            }
            return copyTargetLib.canCopyFrom(dest, src, this.length);
        }

        private static Object getReceiver(LLVMPointer receiverPtr) {
            Object recv;
            if (LLVMManagedPointer.isInstance(receiverPtr)) {
                if (LLVMManagedPointer.cast(receiverPtr).getOffset() != 0L) {
                    return null;
                }
                recv = LLVMManagedPointer.cast(receiverPtr).getObject();
            } else {
                recv = receiverPtr;
            }
            return recv;
        }

        boolean useMemMoveIntrinsic(LLVMPointer sourcePtr, LLVMPointer destPtr, LLVMAsForeignLibrary asForeignLib) {
            Object recv;
            if (LLVMManagedPointer.isInstance(sourcePtr)) {
                if (LLVMManagedPointer.cast(sourcePtr).getOffset() != 0L) {
                    return true;
                }
                recv = LLVMManagedPointer.cast(sourcePtr).getObject();
                if (asForeignLib.isForeign(recv)) {
                    return true;
                }
            }
            if (LLVMManagedPointer.isInstance(destPtr)) {
                if (LLVMManagedPointer.cast(destPtr).getOffset() != 0L) {
                    return true;
                }
                recv = LLVMManagedPointer.cast(destPtr).getObject();
                if (asForeignLib.isForeign(recv)) {
                    return true;
                }
            }
            return false;
        }

        short copyDirection(LLVMPointer sourcePtr, LLVMPointer destPtr) {
            if (LLVMManagedPointer.isInstance(sourcePtr) && LLVMManagedPointer.isInstance(destPtr)) {
                LLVMManagedPointer managedSourcePtr = LLVMManagedPointer.cast(sourcePtr);
                LLVMManagedPointer managedDestPtr = LLVMManagedPointer.cast(destPtr);
                if (managedSourcePtr.getObject() == managedDestPtr.getObject()) {
                    if (managedSourcePtr.getOffset() == managedDestPtr.getOffset()) {
                        return 0;
                    }
                    if (managedSourcePtr.getOffset() < managedDestPtr.getOffset() && managedSourcePtr.getOffset() + this.length > managedDestPtr.getOffset()) {
                        return -1;
                    }
                    return 1;
                }
            } else if (LLVMNativePointer.isInstance(sourcePtr) && LLVMNativePointer.isInstance(destPtr)) {
                LLVMNativePointer nativeSourcePtr = LLVMNativePointer.cast(sourcePtr);
                LLVMNativePointer nativeDestPtr = LLVMNativePointer.cast(destPtr);
                if (nativeSourcePtr.asNative() == nativeDestPtr.asNative()) {
                    return 0;
                }
                if (nativeSourcePtr.asNative() < nativeDestPtr.asNative() && nativeSourcePtr.asNative() + this.length > nativeDestPtr.asNative()) {
                    return -1;
                }
                return 1;
            }
            return 1;
        }

        @Specialization(guards={"doCustomCopy(sourcePtr, destPtr, copyTargetLib)"})
        Object customCopy(LLVMPointer sourcePtr, LLVMPointer destPtr, @CachedLibrary(limit="3") LLVMCopyTargetLibrary copyTargetLib) {
            copyTargetLib.copyFrom(HeadNode.getReceiver(destPtr), HeadNode.getReceiver(sourcePtr), this.length);
            return null;
        }

        @Specialization(guards={"!doCustomCopy(sourcePtr, destPtr, copyTargetLib)", "useMemMoveIntrinsic(sourcePtr, destPtr, asForeignLib)"})
        Object delegateToMemMove(LLVMPointer sourcePtr, LLVMPointer destPtr, @CachedLibrary(limit="3") LLVMCopyTargetLibrary copyTargetLib, @CachedLibrary(limit="3") LLVMAsForeignLibrary asForeignLib) {
            this.memMoveNode.executeWithTarget(destPtr, sourcePtr, this.length);
            return null;
        }

        @Specialization(guards={"!doCustomCopy(sourcePtr, destPtr, copyTargetLib)", "!useMemMoveIntrinsic(sourcePtr, destPtr, asForeignLib)", "copyDirection(sourcePtr, destPtr) > 0"})
        Object primitiveMoveInForwardDir(LLVMPointer sourcePtr, LLVMPointer destPtr, @CachedLibrary(limit="3") LLVMCopyTargetLibrary copyTargetLib, @CachedLibrary(limit="3") LLVMAsForeignLibrary asForeignLib) {
            this.primitiveMoveNode.executeWithTarget(sourcePtr, destPtr, true);
            return null;
        }

        @Specialization(guards={"!doCustomCopy(sourcePtr, destPtr, copyTargetLib)", "!useMemMoveIntrinsic(sourcePtr, destPtr, asForeignLib)", "copyDirection(sourcePtr, destPtr) < 0"})
        Object primitiveMoveInBackwardDir(LLVMPointer sourcePtr, LLVMPointer destPtr, @CachedLibrary(limit="3") LLVMCopyTargetLibrary copyTargetLib, @CachedLibrary(limit="3") LLVMAsForeignLibrary asForeignLib) {
            this.primitiveMoveNode.executeWithTarget(sourcePtr.increment(this.length), destPtr.increment(this.length), false);
            return null;
        }

        @Specialization(guards={"!doCustomCopy(sourcePtr, destPtr, copyTargetLib)", "!useMemMoveIntrinsic(sourcePtr, destPtr, asForeignLib)", "copyDirection(sourcePtr, destPtr) == 0"})
        Object noOp(LLVMPointer sourcePtr, LLVMPointer destPtr, @CachedLibrary(limit="3") LLVMCopyTargetLibrary copyTargetLib, @CachedLibrary(limit="3") LLVMAsForeignLibrary asForeignLib) {
            return null;
        }
    }
}

