/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.aarch64.linux;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMVarArgCompoundValue;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMSourceTypeFactory;
import com.oracle.truffle.llvm.runtime.except.LLVMMemoryException;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMCopyTargetLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVaListLibrary;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVaListStorage;
import com.oracle.truffle.llvm.runtime.nodes.memory.NativeProfiledMemMove;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMPointerLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVM80BitFloatStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;
import java.util.ArrayList;
import java.util.Arrays;

@ExportLibrary.Repeat(value={@ExportLibrary(value=LLVMManagedReadLibrary.class, useForAOT=true, useForAOTPriority=5), @ExportLibrary(value=LLVMManagedWriteLibrary.class, useForAOT=true, useForAOTPriority=4), @ExportLibrary(value=LLVMVaListLibrary.class, useForAOT=true, useForAOTPriority=3), @ExportLibrary(value=NativeTypeLibrary.class, useForAOT=true, useForAOTPriority=2), @ExportLibrary(value=LLVMCopyTargetLibrary.class, useForAOT=true, useForAOTPriority=1), @ExportLibrary(value=InteropLibrary.class)})
public final class LLVMLinuxAarch64VaListStorage
extends LLVMVaListStorage {
    public static final StructureType VA_LIST_TYPE_12 = StructureType.createNamedFromList("struct.__va_list", false, new ArrayList<Type>(Arrays.asList(PointerType.I8, PointerType.I8, PointerType.I8, PrimitiveType.I32, PrimitiveType.I32)));
    public static final StructureType VA_LIST_TYPE_14 = StructureType.createNamedFromList("struct.std::__va_list", false, new ArrayList<Type>(Arrays.asList(PointerType.I8, PointerType.I8, PointerType.I8, PrimitiveType.I32, PrimitiveType.I32)));
    private final Type vaListType;
    private Object[] originalArgs;
    private Object[][] expansions;
    private int gpOffset;
    private int fpOffset;
    private LLVMPointer overflowArgAreaBaseNativePtr;
    private LLVMPointer gpSaveAreaNativePtr;
    private LLVMPointer fpSaveAreaNativePtr;
    private RegSaveArea gpSaveArea;
    private LLVMPointer gpSaveAreaPtr;
    private RegSaveArea fpSaveArea;
    private LLVMPointer fpSaveAreaPtr;
    protected OverflowArgArea overflowArgArea;

    public LLVMLinuxAarch64VaListStorage(LLVMPointer vaListStackPtr, Type vaListType) {
        super(vaListStackPtr);
        this.vaListType = vaListType;
    }

    private static int calculateUsedFpArea(Object[] realArguments, int numberOfExplicitArguments) {
        assert (numberOfExplicitArguments <= realArguments.length);
        int usedFpArea = 0;
        for (int i = 0; i < numberOfExplicitArguments && usedFpArea < 128; ++i) {
            if (LLVMLinuxAarch64VaListStorage.getVarArgArea(realArguments[i]) != LLVMVaListStorage.VarArgArea.FP_AREA) continue;
            usedFpArea += 16;
        }
        return usedFpArea;
    }

    private static int calculateUsedGpArea(Object[] realArguments, int numberOfExplicitArguments) {
        assert (numberOfExplicitArguments <= realArguments.length);
        int usedGpArea = 0;
        for (int i = 0; i < numberOfExplicitArguments && usedGpArea < 64; ++i) {
            if (LLVMLinuxAarch64VaListStorage.getVarArgArea(realArguments[i]) != LLVMVaListStorage.VarArgArea.GP_AREA) continue;
            usedGpArea += 8;
        }
        return usedGpArea;
    }

    @ExportMessage
    public boolean canCopyFrom(Object source, long length) {
        return source instanceof LLVMLinuxAarch64VaListStorage || LLVMNativePointer.isInstance(source);
    }

    @ExportMessage
    public void copyFrom(Object source, long length, @Cached LLVMVaListStorage.VAListPointerWrapperFactoryDelegate wrapperFactory, @CachedLibrary(limit="1") LLVMVaListLibrary vaListLibrary, @Cached BranchProfile invalidLengthProfile) {
        if (length != 32L) {
            invalidLengthProfile.enter();
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw CompilerDirectives.shouldNotReachHere((String)("Invalid length " + length + ". Expected length 32"));
        }
        vaListLibrary.copyWithoutFrame(wrapperFactory.execute(source), this);
    }

    @ExportMessage
    boolean hasNativeType() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getNativeType() {
        return LLVMLanguage.get(null).getInteropType(LLVMSourceTypeFactory.resolveType(this.vaListType, LLVMLinuxAarch64VaListStorage.findDataLayoutFromCurrentFrame()));
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isReadable"), @ExportMessage(name="isWritable")})
    boolean isAccessible() {
        return true;
    }

    @ExportMessage
    byte readI8(long offset) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    short readI16(long offset) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    Object readGenericI64(long offset) {
        switch ((int)offset) {
            case 0: {
                return this.overflowArgArea.getCurrentArgPtr();
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    void writeI8(long offset, byte value) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    void writeI16(long offset, short value) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    void writeGenericI64(long offset, Object value) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    void toNative(@Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode gpOffsetStore, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode fpOffsetStore, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode overflowArgAreaStore, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode gpSaveAreaStore, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode fpSaveAreaStore, @Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode i64RegSaveAreaStore, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode i32RegSaveAreaStore, @Cached LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode fp80bitRegSaveAreaStore, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode pointerRegSaveAreaStore, @Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode i64OverflowArgAreaStore, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode i32OverflowArgAreaStore, @Cached LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode fp80bitOverflowArgAreaStore, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode pointerOverflowArgAreaStore, @Cached NativeProfiledMemMove memMove, @Cached BranchProfile nativizedProfile) {
        if (this.isNativized()) {
            nativizedProfile.enter();
            return;
        }
        this.nativized = true;
        if (this.overflowArgArea == null) {
            return;
        }
        LLVMLinuxAarch64VaListStorage.initNativeVAList(gpOffsetStore, fpOffsetStore, overflowArgAreaStore, gpSaveAreaStore, fpSaveAreaStore, this.vaListStackPtr, this.gpOffset, this.fpOffset, this.overflowArgAreaBaseNativePtr.increment(this.overflowArgArea.getOffset()), this.gpSaveAreaNativePtr, this.fpSaveAreaNativePtr);
        LLVMLinuxAarch64VaListStorage.initNativeAreas(this.realArguments, this.originalArgs, this.expansions, this.numberOfExplicitArguments, this.gpOffset, this.fpOffset, this.gpSaveAreaNativePtr, this.fpSaveAreaNativePtr, this.overflowArgAreaBaseNativePtr, i64RegSaveAreaStore, i32RegSaveAreaStore, fp80bitRegSaveAreaStore, pointerRegSaveAreaStore, i64OverflowArgAreaStore, i32OverflowArgAreaStore, fp80bitOverflowArgAreaStore, pointerOverflowArgAreaStore, memMove);
    }

    private void allocateNativeAreas(LLVMVaListStorage.StackAllocationNode stackAllocationNode, Frame frame) {
        this.overflowArgAreaBaseNativePtr = this.overflowArgArea == null ? null : stackAllocationNode.executeWithTarget(this.overflowArgArea.overflowAreaSize, frame);
        this.gpSaveAreaNativePtr = stackAllocationNode.executeWithTarget(64L, frame);
        this.gpSaveAreaNativePtr = this.gpSaveAreaNativePtr.increment(64L);
        this.fpSaveAreaNativePtr = stackAllocationNode.executeWithTarget(128L, frame);
        this.fpSaveAreaNativePtr = this.fpSaveAreaNativePtr.increment(128L);
    }

    private static void initNativeVAList(LLVMI32StoreNode.LLVMI32OffsetStoreNode gpOffsetStore, LLVMI32StoreNode.LLVMI32OffsetStoreNode fpOffsetStore, LLVMPointerStoreNode.LLVMPointerOffsetStoreNode overflowArgAreaStore, LLVMPointerStoreNode.LLVMPointerOffsetStoreNode gpSaveAreaStore, LLVMPointerStoreNode.LLVMPointerOffsetStoreNode fpSaveAreaStore, LLVMPointer vaListStackPtr, int gpOffset, int fpOffset, LLVMPointer overflowArgAreaNativePtr, LLVMPointer gpSaveAreaNativePtr, LLVMPointer fpSaveAreaNativePtr) {
        gpOffsetStore.executeWithTarget(vaListStackPtr, 24L, gpOffset);
        fpOffsetStore.executeWithTarget(vaListStackPtr, 28L, fpOffset);
        overflowArgAreaStore.executeWithTarget(vaListStackPtr, 0L, overflowArgAreaNativePtr);
        gpSaveAreaStore.executeWithTarget(vaListStackPtr, 8L, gpSaveAreaNativePtr);
        fpSaveAreaStore.executeWithTarget(vaListStackPtr, 16L, fpSaveAreaNativePtr);
    }

    private static void initNativeAreas(Object[] realArguments, Object[] originalArguments, Object[][] expansions, int numberOfExplicitArguments, int initGPOffset, int initFPOffset, LLVMPointer gpSaveAreaNativePtr, LLVMPointer fpSaveAreaNativePtr, LLVMPointer overflowArgAreaBaseNativePtr, LLVMI64StoreNode.LLVMI64OffsetStoreNode i64RegSaveAreaStore, LLVMI32StoreNode.LLVMI32OffsetStoreNode i32RegSaveAreaStore, LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode fp80bitRegSaveAreaStore, LLVMPointerStoreNode.LLVMPointerOffsetStoreNode pointerRegSaveAreaStore, LLVMI64StoreNode.LLVMI64OffsetStoreNode i64OverflowArgAreaStore, LLVMI32StoreNode.LLVMI32OffsetStoreNode i32OverflowArgAreaStore, LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode fp80bitOverflowArgAreaStore, LLVMPointerStoreNode.LLVMPointerOffsetStoreNode pointerOverflowArgAreaStore, LLVMMemMoveNode memMove) {
        int gp = initGPOffset;
        int fp = initFPOffset;
        int vaLength = realArguments.length - numberOfExplicitArguments;
        if (vaLength > 0) {
            long overflowOffset = 0L;
            int ei = -1;
            int expansionStart = 0;
            int expansionLength = 0;
            int remainingExpLength = 0;
            for (int i = 0; i < realArguments.length; ++i) {
                Object object = realArguments[i];
                if (i >= expansionStart + expansionLength) {
                    expansionStart += expansionLength;
                    remainingExpLength = expansionLength = expansions == null || expansions[ei] == null ? 1 : expansions[++ei].length;
                } else {
                    --remainingExpLength;
                }
                if (i < numberOfExplicitArguments) continue;
                LLVMVaListStorage.VarArgArea area = LLVMLinuxAarch64VaListStorage.getVarArgArea(object);
                if (area == LLVMVaListStorage.VarArgArea.GP_AREA) {
                    if (gp + remainingExpLength * 8 <= 0) {
                        LLVMLinuxAarch64VaListStorage.storeArgument(gpSaveAreaNativePtr, gp, memMove, i64RegSaveAreaStore, i32RegSaveAreaStore, fp80bitRegSaveAreaStore, pointerRegSaveAreaStore, object, 8);
                        gp += 8;
                        continue;
                    }
                    if (remainingExpLength != expansionLength) continue;
                    gp = 0;
                    LLVMLinuxAarch64VaListStorage.storeArgument(overflowArgAreaBaseNativePtr, overflowOffset, memMove, i64OverflowArgAreaStore, i32OverflowArgAreaStore, fp80bitOverflowArgAreaStore, pointerOverflowArgAreaStore, originalArguments[ei], 8);
                    if (originalArguments[ei] instanceof LLVMVarArgCompoundValue) {
                        overflowOffset += ((LLVMVarArgCompoundValue)originalArguments[ei]).getSize();
                        continue;
                    }
                    overflowOffset += (long)(expansionLength * 8);
                    continue;
                }
                if (area == LLVMVaListStorage.VarArgArea.FP_AREA) {
                    if (fp + remainingExpLength * 16 <= 0) {
                        LLVMLinuxAarch64VaListStorage.storeArgument(fpSaveAreaNativePtr, fp, memMove, i64RegSaveAreaStore, i32RegSaveAreaStore, fp80bitRegSaveAreaStore, pointerRegSaveAreaStore, object, 8);
                        fp += 16;
                        continue;
                    }
                    if (remainingExpLength != expansionLength) continue;
                    fp = 0;
                    LLVMLinuxAarch64VaListStorage.storeArgument(overflowArgAreaBaseNativePtr, overflowOffset, memMove, i64OverflowArgAreaStore, i32OverflowArgAreaStore, fp80bitOverflowArgAreaStore, pointerOverflowArgAreaStore, originalArguments[ei], 8);
                    if (originalArguments[ei] instanceof LLVMVarArgCompoundValue) {
                        overflowOffset += ((LLVMVarArgCompoundValue)originalArguments[ei]).getSize();
                        continue;
                    }
                    overflowOffset += (long)(expansionLength * 8);
                    continue;
                }
                if (!(object instanceof LLVMVarArgCompoundValue)) continue;
                overflowOffset += LLVMLinuxAarch64VaListStorage.storeArgument(overflowArgAreaBaseNativePtr, overflowOffset, memMove, i64OverflowArgAreaStore, i32OverflowArgAreaStore, fp80bitOverflowArgAreaStore, pointerOverflowArgAreaStore, object, 8);
            }
        }
    }

    @ExportMessage
    public void cleanup(Frame frame) {
    }

    private static long getArgPtrFromNativePtr(LLVMLinuxAarch64VaListStorage srcVaList, LLVMManagedReadLibrary readLib) {
        LLVMPointer overflowAreaPtr = readLib.readPointer(srcVaList, 0L);
        long curAddr = LLVMNativePointer.isInstance(overflowAreaPtr) ? LLVMNativePointer.cast(overflowAreaPtr).asNative() : LLVMManagedPointer.cast(overflowAreaPtr).getOffset();
        long baseAddr = LLVMNativePointer.isInstance(srcVaList.overflowArgAreaBaseNativePtr) ? LLVMNativePointer.cast(srcVaList.overflowArgAreaBaseNativePtr).asNative() : LLVMManagedPointer.cast(srcVaList.overflowArgAreaBaseNativePtr).getOffset();
        return curAddr - baseAddr;
    }

    @ExportMessage
    Object shift(Type type, Frame frame, @CachedLibrary(limit="1") LLVMManagedReadLibrary readLib, @CachedLibrary(limit="1") LLVMManagedWriteLibrary writeLib, @Cached BranchProfile regAreaProfile, @Cached LLVMVaListStorage.LoadFromAreaNode loadFromArea, @Cached ConditionProfile isNativizedProfile) {
        int regSaveAreaOffs = 0;
        int regSaveOffs = 0;
        int regSaveStep = 0;
        boolean lookIntoRegSaveArea = true;
        LLVMVaListStorage.VarArgArea varArgArea = LLVMLinuxAarch64VaListStorage.getVarArgArea(type);
        RegSaveArea regSaveArea = null;
        switch (varArgArea) {
            case GP_AREA: {
                regSaveAreaOffs = 8;
                regSaveOffs = 24;
                regSaveStep = 8;
                regSaveArea = this.gpSaveArea;
                break;
            }
            case FP_AREA: {
                regSaveAreaOffs = 16;
                regSaveOffs = 28;
                regSaveStep = 16;
                regSaveArea = this.fpSaveArea;
                break;
            }
            case OVERFLOW_AREA: {
                lookIntoRegSaveArea = false;
            }
        }
        if (lookIntoRegSaveArea) {
            regAreaProfile.enter();
            int offs = readLib.readI32(this, regSaveOffs);
            if (offs < 0) {
                writeLib.writeI32(this, regSaveOffs, offs + regSaveStep);
                if (regSaveArea != null) {
                    long n = regSaveArea.offsetToIndex(offs);
                    if (n >= 0L) {
                        int i = (int)(n << 32 >> 32);
                        return regSaveArea.args[i];
                    }
                } else {
                    return loadFromArea.execute(this.vaListStackPtr, regSaveAreaOffs, offs, 0, type);
                }
            }
        }
        if (isNativizedProfile.profile(this.isNativized())) {
            assert (regSaveStep == 8);
            return loadFromArea.execute(this.vaListStackPtr, 0, 0, 8, type);
        }
        Object currentArg = this.overflowArgArea.getCurrentArg();
        this.overflowArgArea.shift(1);
        return currentArg;
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class OverflowArgArea
    extends LLVMVaListStorage.AbstractOverflowArgArea {
        final int argsCnt;

        OverflowArgArea(Object[] args, long[] offsets, long overflowAreaSize, int argsCnt) {
            super(args, offsets, overflowAreaSize);
            this.argsCnt = argsCnt;
        }

        public OverflowArgArea clone() {
            OverflowArgArea cloned = new OverflowArgArea(this.args, this.offsets, this.overflowAreaSize, this.argsCnt);
            cloned.currentOffset = this.currentOffset;
            cloned.previousOffset = this.previousOffset;
            return cloned;
        }

        @ExportMessage
        public boolean isPointer() {
            Object prevArg = this.getPreviousArg();
            if (prevArg instanceof LLVMVarArgCompoundValue) {
                return LLVMNativePointer.isInstance(((LLVMVarArgCompoundValue)prevArg).getAddr());
            }
            return false;
        }

        @ExportMessage
        public long asPointer() throws UnsupportedMessageException {
            Object prevArg = this.getPreviousArg();
            assert (prevArg != null && this.previousOffset >= 0L);
            if (prevArg instanceof LLVMVarArgCompoundValue) {
                return LLVMNativePointer.cast(((LLVMVarArgCompoundValue)prevArg).getAddr()).increment(-this.previousOffset).asNative();
            }
            throw UnsupportedMessageException.create();
        }
    }

    public static final class RegSaveArea
    extends LLVMVaListStorage.ArgsArea {
        private final int[] idx;
        private final int step;
        private final int limit;

        RegSaveArea(Object[] args, int[] idx, int step, int limit) {
            super(args);
            this.idx = idx;
            this.step = step;
            this.limit = limit;
        }

        @Override
        public long offsetToIndex(long offset) {
            if (offset >= 0L) {
                return -1L;
            }
            int s = this.step;
            long i = ((long)this.limit + offset) / (long)s;
            if (i > 0L && this.idx[(int)i] == this.idx[(int)i - 1]) {
                s = 16;
            }
            long j = ((long)this.limit + offset) % (long)s;
            return i >= (long)this.idx.length ? -1L : (long)this.idx[(int)i] + (j << 32);
        }
    }

    @ExportLibrary(value=LLVMVaListLibrary.class, useForAOT=true, useForAOTPriority=0)
    @ImportStatic(value={LLVMVaListStorage.class})
    public static final class NativeVAListWrapper {
        final LLVMPointer nativeVAListPtr;

        public NativeVAListWrapper(LLVMPointer nativeVAListPtr) {
            this.nativeVAListPtr = nativeVAListPtr;
        }

        @ExportMessage
        public void initialize(Object[] originalArgs, int numberOfExplicitArguments, Frame frame, @Cached.Exclusive @Cached LLVMVaListStorage.StackAllocationNode stackAllocationNode, @Cached.Shared(value="gpOffsetStore") @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode gpOffsetStore, @Cached.Shared(value="fpOffsetStore") @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode fpOffsetStore, @Cached.Exclusive @Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode i64RegSaveAreaStore, @Cached.Exclusive @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode i32RegSaveAreaStore, @Cached.Exclusive @Cached LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode fp80bitRegSaveAreaStore, @Cached.Exclusive @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode pointerRegSaveAreaStore, @Cached.Exclusive @Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode i64OverflowArgAreaStore, @Cached.Exclusive @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode i32OverflowArgAreaStore, @Cached.Exclusive @Cached LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode fp80bitOverflowArgAreaStore, @Cached.Exclusive @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode pointerOverflowArgAreaStore, @Cached.Shared(value="overflowAreaStore") @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode overflowArgAreaStore, @Cached.Shared(value="gpSaveAreaStore") @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode gpSaveAreaStore, @Cached.Shared(value="fpSaveAreaStore") @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode fpSaveAreaStore, @Cached NativeProfiledMemMove memMove, @Cached(parameters={"UNPACK_32BIT_PRIMITIVES_IN_STRUCTS"}) LLVMVaListStorage.ArgumentListExpander argsExpander) {
            int initFPOffset;
            int initGPOffset;
            Object[][][] expansionsOutArg = new Object[1][][];
            Object[] realArguments = argsExpander.expand(originalArgs, expansionsOutArg);
            Object[][] expansions = expansionsOutArg[0];
            int gpNamedUsage = LLVMLinuxAarch64VaListStorage.calculateUsedGpArea(realArguments, numberOfExplicitArguments);
            int gp = initGPOffset = gpNamedUsage - 64;
            int fpNamedUsage = LLVMLinuxAarch64VaListStorage.calculateUsedFpArea(realArguments, numberOfExplicitArguments);
            int fp = initFPOffset = fpNamedUsage - 128;
            int ei = -1;
            int expansionStart = 0;
            int expansionLength = 0;
            int remainingExpLength = 0;
            long overflowArea = 0L;
            for (int i = 0; i < realArguments.length; ++i) {
                Object arg = realArguments[i];
                if (i >= expansionStart + expansionLength) {
                    expansionStart += expansionLength;
                    remainingExpLength = expansionLength = expansions == null || expansions[ei] == null ? 1 : expansions[++ei].length;
                } else {
                    --remainingExpLength;
                }
                if (i < numberOfExplicitArguments) continue;
                LLVMVaListStorage.VarArgArea area = LLVMVaListStorage.getVarArgArea(arg);
                if (area == LLVMVaListStorage.VarArgArea.GP_AREA) {
                    if (gp + remainingExpLength * 8 <= 0) {
                        gp += 8;
                        continue;
                    }
                    gp = 0;
                    if (remainingExpLength != expansionLength) continue;
                    if (originalArgs[ei] instanceof LLVMVarArgCompoundValue) {
                        overflowArea += ((LLVMVarArgCompoundValue)originalArgs[ei]).getSize();
                        continue;
                    }
                    overflowArea += (long)(expansionLength * 8);
                    continue;
                }
                if (area == LLVMVaListStorage.VarArgArea.FP_AREA) {
                    if (fp + remainingExpLength * 16 <= 0) {
                        fp += 16;
                        continue;
                    }
                    fp = 0;
                    if (remainingExpLength != expansionLength) continue;
                    if (originalArgs[ei] instanceof LLVMVarArgCompoundValue) {
                        overflowArea += ((LLVMVarArgCompoundValue)originalArgs[ei]).getSize();
                        continue;
                    }
                    overflowArea += (long)(expansionLength * 8);
                    continue;
                }
                if (arg instanceof LLVM80BitFloat) {
                    overflowArea += 16L;
                    continue;
                }
                if (arg instanceof LLVMVarArgCompoundValue) {
                    LLVMVarArgCompoundValue obj = (LLVMVarArgCompoundValue)arg;
                    overflowArea += obj.getSize();
                    continue;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw CompilerDirectives.shouldNotReachHere((String)String.valueOf(arg));
            }
            LLVMPointer gpSaveAreaNativePtr = stackAllocationNode.executeWithTarget(64L, frame);
            gpSaveAreaNativePtr = gpSaveAreaNativePtr.increment(64L);
            LLVMPointer fpSaveAreaNativePtr = stackAllocationNode.executeWithTarget(128L, frame);
            fpSaveAreaNativePtr = fpSaveAreaNativePtr.increment(128L);
            LLVMPointer overflowArgAreaBaseNativePtr = stackAllocationNode.executeWithTarget(overflowArea, frame);
            LLVMLinuxAarch64VaListStorage.initNativeVAList(gpOffsetStore, fpOffsetStore, overflowArgAreaStore, gpSaveAreaStore, fpSaveAreaStore, this.nativeVAListPtr, initGPOffset, initFPOffset, overflowArgAreaBaseNativePtr, gpSaveAreaNativePtr, fpSaveAreaNativePtr);
            LLVMLinuxAarch64VaListStorage.initNativeAreas(realArguments, originalArgs, expansions, numberOfExplicitArguments, initGPOffset, initFPOffset, gpSaveAreaNativePtr, fpSaveAreaNativePtr, overflowArgAreaBaseNativePtr, i64RegSaveAreaStore, i32RegSaveAreaStore, fp80bitRegSaveAreaStore, pointerRegSaveAreaStore, i64OverflowArgAreaStore, i32OverflowArgAreaStore, fp80bitOverflowArgAreaStore, pointerOverflowArgAreaStore, memMove);
        }

        @ExportMessage
        public void cleanup(Frame frame) {
        }

        @ExportMessage
        public Object shift(Type type, Frame frame) {
            throw CompilerDirectives.shouldNotReachHere((String)"TODO");
        }

        @ExportMessage
        @ImportStatic(value={LLVMTypes.class, LLVMLinuxAarch64VaListStorage.class})
        static class Copy {
            Copy() {
            }

            @Specialization
            @GenerateAOT.Exclude
            static void copyToManagedObject(NativeVAListWrapper source, LLVMLinuxAarch64VaListStorage dest, Frame frame, @CachedLibrary(value="source") LLVMVaListLibrary vaListLibrary) {
                vaListLibrary.copy(source, new NativeVAListWrapper(dest.vaListStackPtr), frame);
                dest.nativized = true;
            }

            @Specialization
            static void copyToNative(NativeVAListWrapper source, NativeVAListWrapper dest, Frame frame, @Cached.Shared(value="gpOffsetStore") @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode gpOffsetStore, @Cached.Shared(value="fpOffsetStore") @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode fpOffsetStore, @Cached.Shared(value="gpSaveAreaStore") @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode gpSaveAreaStore, @Cached.Shared(value="fpSaveAreaStore") @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode fpSaveAreaStore, @Cached.Shared(value="overflowAreaStore") @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode overflowAreaStore, @Cached.Exclusive @Cached LLVMI32LoadNode.LLVMI32OffsetLoadNode gpOffsetLoad, @Cached.Exclusive @Cached LLVMI32LoadNode.LLVMI32OffsetLoadNode fpOffsetLoad, @Cached.Exclusive @Cached LLVMPointerLoadNode.LLVMPointerOffsetLoadNode gpSaveAreaLoad, @Cached.Exclusive @Cached LLVMPointerLoadNode.LLVMPointerOffsetLoadNode fpSaveAreaLoad, @Cached.Exclusive @Cached LLVMPointerLoadNode.LLVMPointerOffsetLoadNode overflowAreaLoad) {
                int gp = gpOffsetLoad.executeWithTarget(source.nativeVAListPtr, 24L);
                int fp = fpOffsetLoad.executeWithTarget(source.nativeVAListPtr, 28L);
                LLVMPointer gpSaveAreaPtr = gpSaveAreaLoad.executeWithTarget(source.nativeVAListPtr, 8L);
                LLVMPointer fpSaveAreaPtr = fpSaveAreaLoad.executeWithTarget(source.nativeVAListPtr, 16L);
                LLVMPointer overflowSaveAreaPtr = overflowAreaLoad.executeWithTarget(source.nativeVAListPtr, 0L);
                LLVMLinuxAarch64VaListStorage.initNativeVAList(gpOffsetStore, fpOffsetStore, gpSaveAreaStore, fpSaveAreaStore, overflowAreaStore, dest.nativeVAListPtr, gp, fp, overflowSaveAreaPtr, gpSaveAreaPtr, fpSaveAreaPtr);
            }
        }
    }

    @GenerateUncached
    public static abstract class Aarch64VAListPointerWrapperFactory
    extends LLVMVaListStorage.VAListPointerWrapperFactory {
        public abstract Object execute(Object var1);

        @Specialization
        protected Object createNativeWrapper(LLVMNativePointer p) {
            return new NativeVAListWrapper(p);
        }

        @Specialization(guards={"!isManagedVAList(p.getObject())"})
        protected Object createManagedWrapper(LLVMManagedPointer p) {
            return new NativeVAListWrapper(p);
        }

        @Specialization(guards={"isManagedVAList(p.getObject())"})
        protected Object createManagedVAListWrapper(LLVMManagedPointer p) {
            return p.getObject();
        }

        static boolean isManagedVAList(Object o) {
            return o instanceof LLVMLinuxAarch64VaListStorage;
        }
    }

    @ExportMessage
    static class Copy {
        Copy() {
        }

        @Specialization(guards={"!source.isNativized()"})
        static void copyManaged(LLVMLinuxAarch64VaListStorage source, LLVMLinuxAarch64VaListStorage dest, Frame frame, @Cached.Shared(value="stackAllocationNode") @Cached LLVMVaListStorage.StackAllocationNode stackAllocationNode) {
            dest.realArguments = source.realArguments;
            dest.originalArgs = source.originalArgs;
            dest.expansions = source.expansions;
            dest.numberOfExplicitArguments = source.numberOfExplicitArguments;
            dest.fpOffset = source.fpOffset;
            dest.gpOffset = source.gpOffset;
            dest.gpSaveArea = source.gpSaveArea;
            dest.gpSaveAreaPtr = source.gpSaveAreaPtr;
            dest.fpSaveArea = source.fpSaveArea;
            dest.fpSaveAreaPtr = source.fpSaveAreaPtr;
            dest.overflowArgArea = source.overflowArgArea == null ? null : source.overflowArgArea.clone();
            dest.allocateNativeAreas(stackAllocationNode, frame);
        }

        @Specialization(guards={"source.isNativized()", "source.overflowArgArea != null"})
        static void copyNativeToManaged(LLVMLinuxAarch64VaListStorage source, LLVMLinuxAarch64VaListStorage dest, Frame frame, @CachedLibrary(limit="1") LLVMManagedReadLibrary srcReadLib, @CachedLibrary(limit="1") LLVMManagedWriteLibrary writeLib, @Cached.Shared(value="stackAllocationNode") @Cached LLVMVaListStorage.StackAllocationNode stackAllocationNode) {
            Copy.copyManaged(source, dest, frame, stackAllocationNode);
            dest.fpOffset = srcReadLib.readI32(source, 28L);
            dest.gpOffset = srcReadLib.readI32(source, 24L);
            LLVMPointer overflowArgArea = srcReadLib.readPointer(source, 0L);
            LLVMPointer regFpSaveArea = srcReadLib.readPointer(source, 16L);
            LLVMPointer regGpSaveArea = srcReadLib.readPointer(source, 8L);
            dest.nativized = true;
            writeLib.writeI32(dest, 28L, dest.fpOffset);
            writeLib.writeI32(dest, 24L, dest.gpOffset);
            writeLib.writePointer(dest, 0L, overflowArgArea);
            writeLib.writePointer(dest, 16L, regFpSaveArea);
            writeLib.writePointer(dest, 8L, regGpSaveArea);
            if (dest.overflowArgArea != null) {
                dest.overflowArgArea.setOffset(LLVMLinuxAarch64VaListStorage.getArgPtrFromNativePtr(source, srcReadLib));
            }
        }

        @Specialization(guards={"source.isNativized()", "source.overflowArgArea == null"})
        @GenerateAOT.Exclude
        static void copyNative(LLVMLinuxAarch64VaListStorage source, LLVMLinuxAarch64VaListStorage dest, Frame frame, @Cached LLVMVaListStorage.VAListPointerWrapperFactoryDelegate wrapperFactory, @CachedLibrary(limit="1") LLVMVaListLibrary vaListLibrary) {
            vaListLibrary.copy(wrapperFactory.execute(source.vaListStackPtr), dest, frame);
        }

        @Specialization
        @GenerateAOT.Exclude
        static void copyManagedToNative(LLVMLinuxAarch64VaListStorage source, NativeVAListWrapper dest, Frame frame, @CachedLibrary(limit="1") LLVMVaListLibrary vaListLibrary) {
            LLVMLinuxAarch64VaListStorage dummyClone = new LLVMLinuxAarch64VaListStorage(dest.nativeVAListPtr, source.vaListType);
            dummyClone.nativized = true;
            vaListLibrary.initialize(dummyClone, source.realArguments, source.numberOfExplicitArguments, frame);
        }
    }

    @ExportMessage
    static class Initialize {
        Initialize() {
        }

        @Specialization(guards={"!vaList.isNativized()"})
        static void initializeManaged(LLVMLinuxAarch64VaListStorage vaList, Object[] args, int numOfExpArgs, Frame frame, @Cached.Exclusive @Cached(parameters={"UNPACK_32BIT_PRIMITIVES_IN_STRUCTS"}) LLVMVaListStorage.ArgumentListExpander argsExpander, @Cached.Shared(value="stackAllocationNode") @Cached LLVMVaListStorage.StackAllocationNode stackAllocationNode) {
            vaList.originalArgs = args;
            Object[][][] expansionsOutArg = new Object[1][][];
            vaList.realArguments = argsExpander.expand(args, expansionsOutArg);
            vaList.expansions = expansionsOutArg[0];
            vaList.numberOfExplicitArguments = numOfExpArgs;
            assert (numOfExpArgs <= vaList.realArguments.length);
            int gpUsage = LLVMLinuxAarch64VaListStorage.calculateUsedGpArea(vaList.realArguments, numOfExpArgs);
            vaList.gpOffset = gpUsage - 64;
            int fpUsage = LLVMLinuxAarch64VaListStorage.calculateUsedFpArea(vaList.realArguments, numOfExpArgs);
            vaList.fpOffset = fpUsage - 128;
            int[] gpIdx = new int[vaList.realArguments.length];
            Arrays.fill(gpIdx, -1);
            int[] fpIdx = new int[vaList.realArguments.length];
            Arrays.fill(fpIdx, -1);
            int gp = vaList.gpOffset;
            int fp = vaList.fpOffset;
            Object[] overflowArgs = new Object[vaList.realArguments.length];
            long[] overflowAreaArgOffsets = new long[vaList.realArguments.length];
            Arrays.fill(overflowAreaArgOffsets, -1L);
            int ei = -1;
            int expansionStart = 0;
            int expansionLength = 0;
            int remainingExpLength = 0;
            int oi = 0;
            long overflowArea = 0L;
            for (int i = 0; i < vaList.realArguments.length; ++i) {
                Object arg = vaList.realArguments[i];
                if (i >= expansionStart + expansionLength) {
                    expansionStart += expansionLength;
                    remainingExpLength = expansionLength = vaList.expansions == null || vaList.expansions[ei] == null ? 1 : vaList.expansions[++ei].length;
                } else {
                    --remainingExpLength;
                }
                if (i < numOfExpArgs) continue;
                LLVMVaListStorage.VarArgArea area = LLVMVaListStorage.getVarArgArea(arg);
                if (area == LLVMVaListStorage.VarArgArea.GP_AREA) {
                    if (gp + remainingExpLength * 8 <= 0) {
                        gpIdx[(64 + gp) / 8] = i;
                        gp += 8;
                        continue;
                    }
                    if (remainingExpLength != expansionLength) continue;
                    gp = 0;
                    overflowAreaArgOffsets[oi] = overflowArea;
                    overflowArgs[oi++] = args[ei];
                    if (args[ei] instanceof LLVMVarArgCompoundValue) {
                        overflowArea += ((LLVMVarArgCompoundValue)args[ei]).getSize();
                        continue;
                    }
                    overflowArea += (long)(expansionLength * 8);
                    continue;
                }
                if (area == LLVMVaListStorage.VarArgArea.FP_AREA) {
                    if (fp + remainingExpLength * 16 <= 0) {
                        fpIdx[(128 + fp) / 16] = i;
                        fp += 16;
                        continue;
                    }
                    if (remainingExpLength != expansionLength) continue;
                    fp = 0;
                    overflowAreaArgOffsets[oi] = overflowArea;
                    overflowArgs[oi++] = args[ei];
                    if (args[ei] instanceof LLVMVarArgCompoundValue) {
                        overflowArea += ((LLVMVarArgCompoundValue)args[ei]).getSize();
                        continue;
                    }
                    overflowArea += (long)(expansionLength * 8);
                    continue;
                }
                if (area != LLVMVaListStorage.VarArgArea.OVERFLOW_AREA) {
                    overflowAreaArgOffsets[oi] = overflowArea;
                    overflowArea += 8L;
                    overflowArgs[oi++] = arg;
                    continue;
                }
                if (arg instanceof LLVM80BitFloat) {
                    overflowAreaArgOffsets[oi] = overflowArea;
                    overflowArea += 16L;
                    overflowArgs[oi++] = arg;
                    continue;
                }
                if (arg instanceof LLVMVarArgCompoundValue) {
                    LLVMVarArgCompoundValue obj = (LLVMVarArgCompoundValue)arg;
                    overflowAreaArgOffsets[oi] = overflowArea;
                    overflowArea += obj.getSize();
                    overflowArgs[oi++] = arg;
                    continue;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw CompilerDirectives.shouldNotReachHere((String)String.valueOf(arg));
            }
            if (gp == vaList.gpOffset) {
                vaList.gpOffset = 0;
            }
            if (fp == vaList.fpOffset) {
                vaList.fpOffset = 0;
            }
            vaList.gpSaveArea = new RegSaveArea(vaList.realArguments, gpIdx, 8, 64);
            vaList.gpSaveAreaPtr = LLVMManagedPointer.create(vaList.gpSaveArea);
            vaList.fpSaveArea = new RegSaveArea(vaList.realArguments, fpIdx, 16, 128);
            vaList.fpSaveAreaPtr = LLVMManagedPointer.create(vaList.fpSaveArea);
            vaList.overflowArgArea = new OverflowArgArea(overflowArgs, overflowAreaArgOffsets, overflowArea, oi);
            vaList.allocateNativeAreas(stackAllocationNode, frame);
        }

        @Specialization(guards={"vaList.isNativized()"})
        static void initializeNativized(LLVMLinuxAarch64VaListStorage vaList, Object[] realArgs, int numOfExpArgs, Frame frame, @Cached.Shared(value="stackAllocationNode") @Cached LLVMVaListStorage.StackAllocationNode stackAllocationNode, @Cached.Exclusive @Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode i64RegSaveAreaStore, @Cached.Exclusive @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode i32RegSaveAreaStore, @Cached.Exclusive @Cached LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode fp80bitRegSaveAreaStore, @Cached.Exclusive @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode pointerRegSaveAreaStore, @Cached.Exclusive @Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode i64OverflowArgAreaStore, @Cached.Exclusive @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode i32OverflowArgAreaStore, @Cached.Exclusive @Cached LLVM80BitFloatStoreNode.LLVM80BitFloatOffsetStoreNode fp80bitOverflowArgAreaStore, @Cached.Exclusive @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode pointerOverflowArgAreaStore, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode gpOffsetStore, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode fpOffsetStore, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode overflowArgAreaStore, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode gpSaveAreaStore, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode fpSaveAreaStore, @Cached NativeProfiledMemMove memMove, @Cached.Exclusive @Cached(parameters={"UNPACK_32BIT_PRIMITIVES_IN_STRUCTS"}) LLVMVaListStorage.ArgumentListExpander argsExpander) {
            Initialize.initializeManaged(vaList, realArgs, numOfExpArgs, frame, argsExpander, stackAllocationNode);
            LLVMLinuxAarch64VaListStorage.initNativeVAList(gpOffsetStore, fpOffsetStore, overflowArgAreaStore, gpSaveAreaStore, fpSaveAreaStore, vaList.vaListStackPtr, vaList.gpOffset, vaList.fpOffset, vaList.overflowArgAreaBaseNativePtr.increment(vaList.overflowArgArea.getOffset()), vaList.gpSaveAreaNativePtr, vaList.fpSaveAreaNativePtr);
            LLVMLinuxAarch64VaListStorage.initNativeAreas(vaList.realArguments, vaList.originalArgs, vaList.expansions, vaList.numberOfExplicitArguments, vaList.gpOffset, vaList.fpOffset, vaList.gpSaveAreaNativePtr, vaList.fpSaveAreaNativePtr, vaList.overflowArgAreaBaseNativePtr, i64RegSaveAreaStore, i32RegSaveAreaStore, fp80bitRegSaveAreaStore, pointerRegSaveAreaStore, i64OverflowArgAreaStore, i32OverflowArgAreaStore, fp80bitOverflowArgAreaStore, pointerOverflowArgAreaStore, memMove);
            vaList.nativized = true;
        }
    }

    @ExportMessage
    static class WritePointer {
        WritePointer() {
        }

        @Specialization(guards={"!vaList.isNativized()"})
        static void writeManaged(LLVMLinuxAarch64VaListStorage vaList, long offset, LLVMPointer value, @Cached BranchProfile exception, @CachedLibrary(value="vaList") LLVMManagedWriteLibrary self) {
            switch ((int)offset) {
                case 0: {
                    if (!LLVMManagedPointer.isInstance(value) || LLVMManagedPointer.cast(value).getObject() != vaList.overflowArgArea) {
                        exception.enter();
                        throw new LLVMMemoryException((Node)self, "updates to VA_LIST overflowArea pointer can only shift the current argument");
                    }
                    vaList.overflowArgArea.setOffset(LLVMManagedPointer.cast(value).getOffset());
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
        }

        @Specialization(guards={"vaList.isNativized()"})
        @GenerateAOT.Exclude
        static void writeNative(LLVMLinuxAarch64VaListStorage vaList, long offset, LLVMPointer value, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode offsetStore) {
            offsetStore.executeWithTarget(vaList.vaListStackPtr, offset, value);
        }
    }

    @ExportMessage
    static class WriteI32 {
        WriteI32() {
        }

        @Specialization(guards={"!vaList.isNativized()"})
        static void writeManaged(LLVMLinuxAarch64VaListStorage vaList, long offset, int value) {
            switch ((int)offset) {
                case 24: {
                    vaList.gpOffset = value;
                    break;
                }
                case 28: {
                    vaList.fpOffset = value;
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
        }

        @Specialization(guards={"vaList.isNativized()"})
        @GenerateAOT.Exclude
        static void writeNative(LLVMLinuxAarch64VaListStorage vaList, long offset, int value, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode offsetStore) {
            offsetStore.executeWithTarget(vaList.vaListStackPtr, offset, value);
        }
    }

    @ExportMessage
    static class ReadPointer {
        ReadPointer() {
        }

        @Specialization(guards={"!vaList.isNativized()"})
        static LLVMPointer readManagedPointer(LLVMLinuxAarch64VaListStorage vaList, long offset) {
            switch ((int)offset) {
                case 0: {
                    return vaList.overflowArgArea.getCurrentArgPtr();
                }
                case 8: {
                    return vaList.gpSaveAreaPtr;
                }
                case 16: {
                    return vaList.fpSaveAreaPtr;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw CompilerDirectives.shouldNotReachHere((String)("Invalid offset " + offset));
        }

        @Specialization(guards={"vaList.isNativized()"})
        @GenerateAOT.Exclude
        static LLVMPointer readNativePointer(LLVMLinuxAarch64VaListStorage vaList, long offset, @Cached LLVMPointerLoadNode.LLVMPointerOffsetLoadNode offsetLoad) {
            return offsetLoad.executeWithTarget(vaList.vaListStackPtr, offset);
        }
    }

    @ExportMessage
    static class ReadI32 {
        ReadI32() {
        }

        @Specialization(guards={"!vaList.isNativized()"})
        static int readManagedI32(LLVMLinuxAarch64VaListStorage vaList, long offset) {
            switch ((int)offset) {
                case 24: {
                    return vaList.gpOffset;
                }
                case 28: {
                    return vaList.fpOffset;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw CompilerDirectives.shouldNotReachHere((String)("Invalid offset " + offset));
        }

        @Specialization(guards={"vaList.isNativized()"})
        @GenerateAOT.Exclude
        static int readNativeI32(LLVMLinuxAarch64VaListStorage vaList, long offset, @Cached LLVMI32LoadNode.LLVMI32OffsetLoadNode offsetLoad) {
            return offsetLoad.executeWithTarget(vaList.vaListStackPtr, offset);
        }
    }
}

