/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

@NodeChild(type=LLVMExpressionNode.class)
public abstract class LLVMReadCharsetNode
extends LLVMNode {
    @Node.Child
    LLVMReadStringNode readString = LLVMReadStringNodeGen.create();

    public abstract Object execute(VirtualFrame var1);

    @Specialization(guards={"cachedPointer.isSame(pointer)"})
    protected LLVMCharset doCachedPointer(LLVMPointer pointer, @Cached(value="pointer") LLVMPointer cachedPointer, @Cached(value="doGeneric(cachedPointer)") LLVMCharset cachedCharset) {
        return cachedCharset;
    }

    @Specialization(guards={"address == cachedAddress"})
    protected LLVMCharset doCachedOther(Object address, @Cached(value="address") Object cachedAddress, @Cached(value="doGeneric(cachedAddress)") LLVMCharset cachedCharset) {
        return cachedCharset;
    }

    @Specialization(replaces={"doCachedPointer", "doCachedOther"})
    protected LLVMCharset doGeneric(Object strPtr) {
        String string = this.readString.executeWithTarget(strPtr);
        return this.lookup(string);
    }

    @CompilerDirectives.TruffleBoundary
    private LLVMCharset lookup(String str) {
        try {
            return new LLVMCharset(Charset.forName(str));
        }
        catch (Exception e) {
            throw new LLVMPolyglotException((Node)this, "Invalid charset '%s'.", str);
        }
    }

    public static final class LLVMCharset {
        private final Charset charset;
        public final int zeroTerminatorLen;

        private LLVMCharset(Charset charset) {
            this.charset = charset;
            this.zeroTerminatorLen = charset.encode("\u0000").limit();
        }

        @CompilerDirectives.TruffleBoundary
        public ByteBuffer encode(String str) {
            return this.charset.encode(str);
        }

        @CompilerDirectives.TruffleBoundary
        public String decode(byte[] b) {
            return this.charset.decode(ByteBuffer.wrap(b)).toString();
        }
    }
}

