/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMCatchSwitchNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GeneratedBy(value=LLVMCatchSwitchNode.CatchPadEntryNode.class)
final class CatchPadEntryNodeWrapper
extends LLVMCatchSwitchNode.CatchPadEntryNode
implements InstrumentableNode.WrapperNode {
    @Node.Child
    private LLVMCatchSwitchNode.CatchPadEntryNode delegateNode;
    @Node.Child
    private ProbeNode probeNode;

    CatchPadEntryNodeWrapper(LLVMCatchSwitchNode.CatchPadEntryNode node, LLVMCatchSwitchNode.CatchPadEntryNode delegateNode, ProbeNode probeNode) {
        super(node);
        this.delegateNode = delegateNode;
        this.probeNode = probeNode;
    }

    public LLVMCatchSwitchNode.CatchPadEntryNode getDelegateNode() {
        return this.delegateNode;
    }

    public ProbeNode getProbeNode() {
        return this.probeNode;
    }

    public NodeCost getCost() {
        return NodeCost.NONE;
    }

    @Override
    boolean execute(VirtualFrame frame, LLVMStack stack, LLVMPointer thrownObject, LLVMPointer throwInfo, LLVMPointer imageBase, long stackPointer) {
        boolean returnValue;
        while (true) {
            boolean wasOnReturnExecuted = false;
            try {
                this.probeNode.onEnter(frame);
                returnValue = this.delegateNode.execute(frame, stack, thrownObject, throwInfo, imageBase, stackPointer);
                wasOnReturnExecuted = true;
                this.probeNode.onReturnValue(frame, (Object)returnValue);
            }
            catch (Throwable t) {
                Object result;
                if ((result = this.probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted)) == ProbeNode.UNWIND_ACTION_REENTER) continue;
                if (result != null) {
                    returnValue = (Boolean)result;
                    break;
                }
                throw t;
            }
            break;
        }
        return returnValue;
    }
}

