/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.GenerateWrapper;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMBitcodeLibraryFunctions;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.except.LLVMUserException;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMControlFlowNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMCatchReturnNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMCatchReturnNodeWrapper;

@GenerateWrapper
@NodeField(name="successor", type=int.class)
public abstract class LLVMCatchReturnNode
extends LLVMControlFlowNode {
    public static LLVMCatchReturnNode create(int successor, LLVMExpressionNode getStack, LLVMStatementNode phi) {
        return LLVMCatchReturnNodeFactory.LLVMCatchReturnImplNodeGen.create(getStack, phi, successor);
    }

    public InstrumentableNode.WrapperNode createWrapper(ProbeNode probe) {
        return new LLVMCatchReturnNodeWrapper(this, probe);
    }

    public abstract int getSuccessor();

    public abstract void execute(VirtualFrame var1);

    static abstract class LLVMCatchReturnImplNode
    extends LLVMCatchReturnNode {
        @Node.Child
        private LLVMExpressionNode getStack;
        @Node.Child
        private LLVMStatementNode phi;
        @Node.Child
        private LLVMBitcodeLibraryFunctions.SulongEHUnwindWindowsNode unwindNode;

        LLVMCatchReturnImplNode(LLVMExpressionNode getStack, LLVMStatementNode phi) {
            this.getStack = getStack;
            this.phi = phi;
        }

        public LLVMBitcodeLibraryFunctions.SulongEHUnwindWindowsNode getUnwind() {
            if (this.unwindNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.unwindNode = (LLVMBitcodeLibraryFunctions.SulongEHUnwindWindowsNode)this.insert(new LLVMBitcodeLibraryFunctions.SulongEHUnwindWindowsNode(this.getContext()));
            }
            return this.unwindNode;
        }

        @Override
        public String toString() {
            return this.getShortString("successor");
        }

        @Override
        public int getSuccessorCount() {
            return 1;
        }

        @Override
        public LLVMStatementNode getPhiNode(int successorIndex) {
            assert (successorIndex == 0);
            return this.phi;
        }

        @Specialization
        public void doCondition(VirtualFrame frame) {
            LLVMUserException.LLVMUserExceptionWindows exception = (LLVMUserException.LLVMUserExceptionWindows)((LLVMLanguage.LLVMThreadLocalValue)this.getLanguage().contextThreadLocal.get()).popException();
            LLVMStack stack = (LLVMStack)this.getStack.executeGeneric(frame);
            this.getUnwind().unwind(stack, exception.getExceptionObject(), exception.getThrowInfo(), exception.getImageBase());
        }

        @Override
        public final int[] getSuccessors() {
            return new int[]{this.getSuccessor()};
        }
    }
}

