/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.syscall;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.IntValueProfile;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.memory.LLVMSyscallOperationNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMAMD64SyscallArchPrctlNode
extends LLVMSyscallOperationNode {
    private final IntValueProfile profile = IntValueProfile.createIdentityProfile();

    @Override
    public final String getName() {
        return "arch_prctl";
    }

    @Specialization
    protected long doOp(long code, long addr, @Cached LLVMPointerStoreNode store) {
        return this.exec(code, LLVMNativePointer.create(addr), store);
    }

    @Specialization
    protected long doOp(long code, LLVMPointer addr, @Cached LLVMPointerStoreNode store) {
        return this.exec(code, addr, store);
    }

    private long exec(long code, LLVMPointer addr, LLVMPointerStoreNode store) throws AssertionError {
        switch (this.profile.profile((int)code)) {
            case 4098: {
                ((LLVMLanguage.LLVMThreadLocalValue)this.getLanguage().contextThreadLocal.get()).setThreadLocalStorage(addr);
                return 0L;
            }
            case 4099: {
                store.executeWithTarget(addr, (Object)((LLVMLanguage.LLVMThreadLocalValue)this.getLanguage().contextThreadLocal.get()).getThreadLocalStorage());
                return 0L;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw CompilerDirectives.shouldNotReachHere((String)String.format("not implemented: arch_prcntl(0x%04x)", code));
    }
}

