/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64IdivNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteTupelNode;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMAMD64IdivNode.class)
public final class LLVMAMD64IdivNodeFactory {

    @GeneratedBy(value=LLVMAMD64IdivNode.LLVMAMD64IdivqNode.class)
    public static final class LLVMAMD64IdivqNodeGen
    extends LLVMAMD64IdivNode.LLVMAMD64IdivqNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode high_;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private BranchProfile exception_;

        private LLVMAMD64IdivqNodeGen(LLVMAMD64WriteTupelNode out, LLVMExpressionNode high, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(out);
            this.high_ = high;
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            BranchProfile exception__;
            long rightValue_;
            long leftValue_;
            long highValue_;
            int state_0 = this.state_0_;
            try {
                highValue_ = this.high_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object leftValue = this.left_.executeGeneric(frameValue);
                Object rightValue = this.right_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, ex.getResult(), leftValue, rightValue);
                return;
            }
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, highValue_, ex.getResult(), rightValue);
                return;
            }
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeAndSpecialize(frameValue, highValue_, leftValue_, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, highValue_, leftValue_, rightValue_);
                return;
            }
            if ((state_0 & 2) != 0 && (exception__ = this.exception_) != null) {
                this.doOp(frameValue, highValue_, leftValue_, rightValue_, exception__);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, highValue_, leftValue_, rightValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object highValue, Object leftValue, Object rightValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (highValue instanceof Long) {
                long highValue_ = (Long)highValue;
                if (leftValue instanceof Long) {
                    long leftValue_ = (Long)leftValue;
                    if (rightValue instanceof Long) {
                        long rightValue_ = (Long)rightValue;
                        BranchProfile exception__ = BranchProfile.create();
                        Objects.requireNonNull(exception__, "Specialization 'doOp(VirtualFrame, long, long, long, BranchProfile)' cache 'exception' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.exception_ = exception__;
                        this.state_0_ = state_0 |= 2;
                        this.doOp(frameValue, highValue_, leftValue_, rightValue_, exception__);
                        return;
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.high_, this.left_, this.right_}, new Object[]{highValue, leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            BranchProfile exception__ = BranchProfile.create();
            Objects.requireNonNull(exception__, "Specialization 'doOp(VirtualFrame, long, long, long, BranchProfile)' cache 'exception' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.exception_ = exception__;
            this.exception_.disable();
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.exception_.reset();
        }

        @NeverDefault
        public static LLVMAMD64IdivNode.LLVMAMD64IdivqNode create(LLVMAMD64WriteTupelNode out, LLVMExpressionNode high, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64IdivqNodeGen(out, high, left, right);
        }
    }

    @GeneratedBy(value=LLVMAMD64IdivNode.LLVMAMD64IdivlNode.class)
    public static final class LLVMAMD64IdivlNodeGen
    extends LLVMAMD64IdivNode.LLVMAMD64IdivlNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode high_;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMAMD64IdivlNodeGen(LLVMAMD64WriteTupelNode out, LLVMExpressionNode high, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(out);
            this.high_ = high;
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int rightValue_;
            int leftValue_;
            int highValue_;
            int state_0 = this.state_0_;
            try {
                highValue_ = this.high_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object leftValue = this.left_.executeGeneric(frameValue);
                Object rightValue = this.right_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, ex.getResult(), leftValue, rightValue);
                return;
            }
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, highValue_, ex.getResult(), rightValue);
                return;
            }
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeAndSpecialize(frameValue, highValue_, leftValue_, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, highValue_, leftValue_, rightValue_);
                return;
            }
            if ((state_0 & 2) != 0) {
                this.doOp(frameValue, highValue_, leftValue_, rightValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, highValue_, leftValue_, rightValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object highValue, Object leftValue, Object rightValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (highValue instanceof Integer) {
                int highValue_ = (Integer)highValue;
                if (leftValue instanceof Integer) {
                    int leftValue_ = (Integer)leftValue;
                    if (rightValue instanceof Integer) {
                        int rightValue_ = (Integer)rightValue;
                        this.state_0_ = state_0 |= 2;
                        this.doOp(frameValue, highValue_, leftValue_, rightValue_);
                        return;
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.high_, this.left_, this.right_}, new Object[]{highValue, leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64IdivNode.LLVMAMD64IdivlNode create(LLVMAMD64WriteTupelNode out, LLVMExpressionNode high, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64IdivlNodeGen(out, high, left, right);
        }
    }

    @GeneratedBy(value=LLVMAMD64IdivNode.LLVMAMD64IdivwNode.class)
    public static final class LLVMAMD64IdivwNodeGen
    extends LLVMAMD64IdivNode.LLVMAMD64IdivwNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode high_;
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMAMD64IdivwNodeGen(LLVMAMD64WriteTupelNode out, LLVMExpressionNode high, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(out);
            this.high_ = high;
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            short rightValue_;
            short leftValue_;
            short highValue_;
            int state_0 = this.state_0_;
            try {
                highValue_ = this.high_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object leftValue = this.left_.executeGeneric(frameValue);
                Object rightValue = this.right_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, ex.getResult(), leftValue, rightValue);
                return;
            }
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, highValue_, ex.getResult(), rightValue);
                return;
            }
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeAndSpecialize(frameValue, highValue_, leftValue_, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, highValue_, leftValue_, rightValue_);
                return;
            }
            if ((state_0 & 2) != 0) {
                this.doOp(frameValue, highValue_, leftValue_, rightValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, highValue_, leftValue_, rightValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object highValue, Object leftValue, Object rightValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (highValue instanceof Short) {
                short highValue_ = (Short)highValue;
                if (leftValue instanceof Short) {
                    short leftValue_ = (Short)leftValue;
                    if (rightValue instanceof Short) {
                        short rightValue_ = (Short)rightValue;
                        this.state_0_ = state_0 |= 2;
                        this.doOp(frameValue, highValue_, leftValue_, rightValue_);
                        return;
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.high_, this.left_, this.right_}, new Object[]{highValue, leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64IdivNode.LLVMAMD64IdivwNode create(LLVMAMD64WriteTupelNode out, LLVMExpressionNode high, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64IdivwNodeGen(out, high, left, right);
        }
    }

    @GeneratedBy(value=LLVMAMD64IdivNode.LLVMAMD64IdivbNode.class)
    public static final class LLVMAMD64IdivbNodeGen
    extends LLVMAMD64IdivNode.LLVMAMD64IdivbNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode left_;
        @Node.Child
        private LLVMExpressionNode right_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMAMD64IdivbNodeGen(LLVMExpressionNode left, LLVMExpressionNode right) {
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            byte rightValue_;
            short leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doOp(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_);
        }

        @Override
        public short executeI16(VirtualFrame frameValue) {
            byte rightValue_;
            short leftValue_;
            int state_0 = this.state_0_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), rightValue);
            }
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(leftValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(leftValue_, rightValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doOp(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightValue_);
        }

        private short executeAndSpecialize(Object leftValue, Object rightValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof Short) {
                short leftValue_ = (Short)leftValue;
                if (rightValue instanceof Byte) {
                    byte rightValue_ = (Byte)rightValue;
                    this.state_0_ = state_0 |= 2;
                    return this.doOp(leftValue_, rightValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_}, new Object[]{leftValue, rightValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64IdivNode.LLVMAMD64IdivbNode create(LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMAMD64IdivbNodeGen(left, right);
        }
    }
}

