/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.llvm.runtime.floating.LLVM128BitFloat;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.nfi.api.SerializableLibrary;

@GenerateUncached
public abstract class ToFP128
extends ForeignToLLVM {
    private static final InteropLibrary INTEROP = (InteropLibrary)InteropLibrary.getFactory().getUncached();

    @Specialization
    protected LLVM128BitFloat fromInt(int value) {
        return LLVM128BitFloat.fromInt(value);
    }

    @Specialization
    protected LLVM128BitFloat fromChar(char value) {
        return LLVM128BitFloat.fromInt(value);
    }

    @Specialization
    protected LLVM128BitFloat fromByte(byte value) {
        return LLVM128BitFloat.fromInt(value);
    }

    @Specialization
    protected LLVM128BitFloat fromShort(short value) {
        return LLVM128BitFloat.fromInt(value);
    }

    @Specialization
    protected LLVM128BitFloat fromFloat(float value) {
        return LLVM128BitFloat.fromFloat(value);
    }

    @Specialization
    protected LLVM128BitFloat fromLong(long value) {
        return LLVM128BitFloat.fromLong(value);
    }

    @Specialization
    protected LLVM128BitFloat fromDouble(double value) {
        return LLVM128BitFloat.fromDouble(value);
    }

    @Specialization(limit="1", guards={"serialize.isSerializable(value)"})
    protected LLVM128BitFloat from128BitFloat(Object value, @CachedLibrary(value="value") SerializableLibrary serialize) {
        try {
            byte[] buffer = new byte[16];
            LLVMManagedPointer ptr = LLVMManagedPointer.create(buffer).export(new LLVMInteropType.Buffer(true, 16L));
            serialize.serialize(value, (Object)ptr);
            return LLVM128BitFloat.fromBytes(buffer);
        }
        catch (UnsupportedMessageException ex) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static LLVM128BitFloat slowPathPrimitiveConvert(Object value) throws UnsupportedTypeException {
        try {
            if (INTEROP.fitsInLong(value)) {
                return LLVM128BitFloat.fromLong(INTEROP.asLong(value));
            }
            if (INTEROP.fitsInDouble(value)) {
                return LLVM128BitFloat.fromDouble(INTEROP.asDouble(value));
            }
        }
        catch (UnsupportedMessageException unsupportedMessageException) {
            // empty catch block
        }
        throw UnsupportedTypeException.create((Object[])new Object[]{value});
    }
}

