/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.type;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugObject;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugObjectBuilder;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugValue;
import java.util.ArrayList;
import java.util.stream.Collectors;

public final class LLVMSourceStaticMemberType
extends LLVMSourceType {
    private static final LLVMDebugObjectBuilder DEFAULT_VALUE = new LLVMDebugObjectBuilder(){

        @Override
        public LLVMDebugObject getValue(LLVMSourceType type, LLVMSourceLocation declaration) {
            return LLVMDebugObject.create(type, 0L, LLVMDebugValue.UNAVAILABLE, declaration);
        }
    };
    @CompilerDirectives.CompilationFinal
    private LLVMSourceType elementType = null;
    @CompilerDirectives.CompilationFinal
    private LLVMDebugObjectBuilder value = DEFAULT_VALUE;

    public LLVMSourceStaticMemberType(String name, long size, long align, LLVMSourceLocation location) {
        super(() -> name, size, align, 0L, location);
    }

    public LLVMDebugObjectBuilder getValue() {
        CompilerAsserts.neverPartOfCompilation();
        return this.value;
    }

    public void setValue(LLVMDebugObjectBuilder value) {
        CompilerAsserts.neverPartOfCompilation();
        this.value = value;
    }

    public LLVMSourceType getElementType() {
        return this.elementType;
    }

    public void setElementType(LLVMSourceType elementType) {
        CompilerAsserts.neverPartOfCompilation();
        this.elementType = elementType;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return String.format("%s: %s", this.getName(), this.elementType != null ? this.elementType.getName() : null);
    }

    @Override
    public LLVMSourceType getOffset(long newOffset) {
        return this;
    }

    @Override
    public boolean isAggregate() {
        return true;
    }

    @Override
    public int getElementCount() {
        return 1;
    }

    @Override
    public String getElementName(long i) {
        if (i == 0L) {
            return this.getName();
        }
        return null;
    }

    @Override
    public LLVMSourceType getElementType(long i) {
        if (i == 0L) {
            return this.getElementType();
        }
        return null;
    }

    @Override
    public LLVMSourceType getElementType(String name) {
        if (name != null && name.equals(this.getName())) {
            return this.getElementType();
        }
        return null;
    }

    public static class CollectionType
    extends LLVMSourceType {
        static final String MEMBERNAME = "<static>";
        private static final String TYPENAME = "";
        private final ArrayList<LLVMSourceStaticMemberType> members = new ArrayList();

        CollectionType() {
            super(() -> TYPENAME, 0L, 0L, 0L, null);
        }

        @CompilerDirectives.TruffleBoundary
        void addMember(LLVMSourceStaticMemberType member) {
            CompilerAsserts.neverPartOfCompilation();
            this.members.add(member);
        }

        @CompilerDirectives.TruffleBoundary
        public String[] getIdentifiers() {
            return this.members.stream().map(LLVMSourceType::getName).collect(Collectors.toList()).toArray(new String[this.members.size()]);
        }

        public LLVMDebugObjectBuilder getMemberValue(String name) {
            LLVMSourceStaticMemberType member = this.getMember(name);
            return member != null ? member.getValue() : DEFAULT_VALUE;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int getElementCount() {
            return this.members.size();
        }

        @CompilerDirectives.TruffleBoundary
        private LLVMSourceStaticMemberType getMember(long i) {
            if (0L <= i && i < (long)this.members.size()) {
                return this.members.get((int)i);
            }
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        private LLVMSourceStaticMemberType getMember(String name) {
            if (name == null) {
                return null;
            }
            for (LLVMSourceStaticMemberType member : this.members) {
                if (!name.equals(member.getName())) continue;
                return member;
            }
            return null;
        }

        @Override
        public String getElementName(long i) {
            LLVMSourceStaticMemberType member = this.getMember(i);
            return member != null ? member.getName() : null;
        }

        @Override
        public LLVMSourceType getElementType(long i) {
            LLVMSourceStaticMemberType member = this.getMember(i);
            return member != null ? member.getElementType() : null;
        }

        @Override
        public LLVMSourceType getElementType(String name) {
            LLVMSourceStaticMemberType member = this.getMember(name);
            return member != null ? member.getElementType() : null;
        }

        @Override
        public LLVMSourceLocation getElementDeclaration(long i) {
            LLVMSourceStaticMemberType member = this.getMember(i);
            return member != null ? member.getLocation() : null;
        }

        @Override
        public LLVMSourceLocation getElementDeclaration(String name) {
            LLVMSourceStaticMemberType member = this.getMember(name);
            return member != null ? member.getLocation() : null;
        }

        @Override
        public LLVMSourceType getOffset(long newOffset) {
            return this;
        }
    }
}

