/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.enums.Flag;
import com.oracle.truffle.llvm.parser.model.enums.UnaryOperator;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class UnaryOperationInstruction
extends ValueInstruction {
    private final UnaryOperator operator;
    private final Flag[] flags;
    private SymbolImpl operand;

    private UnaryOperationInstruction(Type type, UnaryOperator operator, Flag[] flags) {
        super(type);
        this.operator = operator;
        this.flags = flags;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public Flag[] getFlags() {
        return this.flags;
    }

    public SymbolImpl getOperand() {
        return this.operand;
    }

    public UnaryOperator getOperator() {
        return this.operator;
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        this.operand = replacement;
    }

    public static UnaryOperationInstruction fromSymbols(SymbolTable symbols, Type type, int opcode, int flags, int operand) {
        UnaryOperator operator = UnaryOperator.decode(opcode);
        UnaryOperationInstruction inst = new UnaryOperationInstruction(type, operator, Flag.decode(operator, flags));
        inst.operand = symbols.getForwardReferenced(operand, inst);
        return inst;
    }
}

