/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDName;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;

public final class MDObjCProperty
extends MDName
implements MDBaseNode {
    private final long line;
    private final long attribute;
    private MDBaseNode file;
    private MDBaseNode getterName;
    private MDBaseNode setterName;
    private MDBaseNode type;
    private static final int ARGINDEX_NAME = 1;
    private static final int ARGINDEX_FILE = 2;
    private static final int ARGINDEX_LINE = 3;
    private static final int ARGINDEX_GETTERNAME = 4;
    private static final int ARGINDEX_SETTERNAME = 5;
    private static final int ARGINDEX_ATTRIBUTE = 6;
    private static final int ARGINDEX_TYPE = 7;

    private MDObjCProperty(long line, long attribute) {
        this.line = line;
        this.attribute = attribute;
        this.file = MDVoidNode.INSTANCE;
        this.getterName = MDVoidNode.INSTANCE;
        this.setterName = MDVoidNode.INSTANCE;
        this.type = MDVoidNode.INSTANCE;
    }

    public MDBaseNode getFile() {
        return this.file;
    }

    public long getLine() {
        return this.line;
    }

    public MDBaseNode getGetterName() {
        return this.getterName;
    }

    public MDBaseNode getSetterName() {
        return this.setterName;
    }

    public long getAttribute() {
        return this.attribute;
    }

    public MDBaseNode getType() {
        return this.type;
    }

    @Override
    public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
        super.replace(oldValue, newValue);
        if (this.file == oldValue) {
            this.file = newValue;
        }
        if (this.getterName == oldValue) {
            this.getterName = newValue;
        }
        if (this.setterName == oldValue) {
            this.setterName = newValue;
        }
        if (this.type == oldValue) {
            this.type = newValue;
        }
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    public static MDObjCProperty create38(long[] args, MetadataValueList md) {
        long line = args[3];
        long attribute = args[6];
        MDObjCProperty objCProperty = new MDObjCProperty(line, attribute);
        objCProperty.file = md.getNullable(args[2], objCProperty);
        objCProperty.getterName = md.getNullable(args[4], objCProperty);
        objCProperty.setterName = md.getNullable(args[5], objCProperty);
        objCProperty.type = md.getNullable(args[7], objCProperty);
        objCProperty.setName(md.getNullable(args[1], objCProperty));
        return objCProperty;
    }
}

