/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.factories.inlineasm;

import com.oracle.truffle.llvm.asm.amd64.AsmFactory;
import com.oracle.truffle.llvm.asm.amd64.InlineAssemblyParser;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.inlineasm.InlineAssemblyParserBase;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMInlineAssemblyRootNode;
import com.oracle.truffle.llvm.runtime.types.Type;

public class AMD64InlineAssemblyParser
extends InlineAssemblyParserBase {
    @Override
    public LLVMExpressionNode getInlineAssemblerExpression(NodeFactory nodeFactory, String asmExpression, String asmFlags, LLVMExpressionNode[] args, Type.TypeArrayBuilder argTypes, Type retType) {
        LLVMInlineAssemblyRootNode assemblyRoot;
        DataLayout.StructureTypeOffsets offsets;
        try {
            offsets = nodeFactory.getDataLayout().getStructureTypeOffsets(retType);
        }
        catch (Type.TypeOverflowException ex) {
            return Type.handleOverflowExpression(ex);
        }
        try {
            assemblyRoot = InlineAssemblyParser.parseInlineAssembly(asmExpression, new AsmFactory(nodeFactory.getLanguage(), argTypes, asmFlags, retType, offsets.getTypes(), offsets.getOffsets(), nodeFactory));
        }
        catch (LLVMParserException e) {
            String message = asmExpression + ": " + e.getMessage();
            assemblyRoot = AMD64InlineAssemblyParser.getLazyUnsupportedInlineRootNode(nodeFactory, message);
        }
        return AMD64InlineAssemblyParser.getCallNodeFromAssemblyRoot(assemblyRoot, args, argTypes);
    }
}

