/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.runtime.IDGenerater;
import com.oracle.truffle.llvm.runtime.LLVMElemPtrSymbol;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.LibraryLocator;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceFileReference;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import java.util.List;

public final class LLVMParserRuntime {
    private final LLVMScope fileScope;
    private final LLVMScope publicFileScope;
    private final NodeFactory nodeFactory;
    private final IDGenerater.BitcodeID bitcodeID;
    private final Source source;
    private final String libName;
    private final List<LLVMSourceFileReference> sourceFileReferences;
    private final LibraryLocator locator;

    public LLVMParserRuntime(LLVMScope fileScope, LLVMScope publicFileScope, NodeFactory nodeFactory, IDGenerater.BitcodeID bitcodeID, Source source, String libName, List<LLVMSourceFileReference> sourceFileReferences, LibraryLocator locator) {
        this.fileScope = fileScope;
        this.publicFileScope = publicFileScope;
        this.nodeFactory = nodeFactory;
        this.bitcodeID = bitcodeID;
        this.source = source;
        this.libName = libName;
        this.sourceFileReferences = sourceFileReferences;
        this.locator = locator;
    }

    public boolean isInternal() {
        return this.source.isInternal();
    }

    public String getPath() {
        return this.source.getPath();
    }

    public String getLibraryName() {
        return this.libName;
    }

    public LLVMScope getFileScope() {
        return this.fileScope;
    }

    public LLVMScope getPublicFileScope() {
        return this.publicFileScope;
    }

    public NodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    public IDGenerater.BitcodeID getBitcodeID() {
        return this.bitcodeID;
    }

    public LibraryLocator getLocator() {
        return this.locator;
    }

    public List<LLVMSourceFileReference> getSourceFileReferences() {
        return this.sourceFileReferences;
    }

    public LLVMFunction lookupFunction(String name) {
        LLVMSymbol symbol = this.fileScope.get(name);
        if (symbol != null && symbol.isFunction()) {
            return symbol.asFunction();
        }
        throw new IllegalStateException("Retrieving unknown function symbol in LLVMParserRuntime: " + name);
    }

    public LLVMGlobal lookupGlobal(String name) {
        LLVMSymbol symbol = this.fileScope.get(name);
        if (symbol != null && symbol.isGlobalVariable()) {
            return symbol.asGlobalVariable();
        }
        throw new IllegalStateException("Retrieving unknown global symbol in LLVMParserRuntime: " + name);
    }

    public LLVMElemPtrSymbol lookUpElemPtrExpression(String name) {
        LLVMSymbol symbol = this.fileScope.get(name);
        if (symbol != null && symbol.isElemPtrExpression()) {
            return symbol.asElemPtrExpression();
        }
        throw new IllegalStateException("Retrieving unknown getElementPointer symbol in LLVMParserRuntime: " + name);
    }

    public LLVMSymbol lookupSymbol(String name) {
        LLVMSymbol symbol = this.fileScope.get(name);
        if (symbol != null) {
            return symbol;
        }
        throw new IllegalStateException("Unknown symbol: " + name);
    }
}

