/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.types;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.visitors.TypeVisitor;

public final class PrimitiveType
extends Type {
    public static final PrimitiveType I1 = new PrimitiveType(PrimitiveKind.I1, null);
    public static final PrimitiveType I8 = new PrimitiveType(PrimitiveKind.I8, null);
    public static final PrimitiveType I16 = new PrimitiveType(PrimitiveKind.I16, null);
    public static final PrimitiveType I32 = new PrimitiveType(PrimitiveKind.I32, null);
    public static final PrimitiveType I64 = new PrimitiveType(PrimitiveKind.I64, null);
    public static final PrimitiveType HALF = new PrimitiveType(PrimitiveKind.HALF, null);
    public static final PrimitiveType FLOAT = new PrimitiveType(PrimitiveKind.FLOAT, null);
    public static final PrimitiveType DOUBLE = new PrimitiveType(PrimitiveKind.DOUBLE, null);
    public static final PrimitiveType F128 = new PrimitiveType(PrimitiveKind.F128, null);
    public static final PrimitiveType X86_FP80 = new PrimitiveType(PrimitiveKind.X86_FP80, null);
    public static final PrimitiveType PPC_FP128 = new PrimitiveType(PrimitiveKind.PPC_FP128, null);
    private final PrimitiveKind kind;
    private final Object constant;

    public static PrimitiveType forKind(PrimitiveKind kind) {
        switch (kind) {
            case I1: {
                return I1;
            }
            case I8: {
                return I8;
            }
            case I16: {
                return I16;
            }
            case I32: {
                return I32;
            }
            case I64: {
                return I64;
            }
            case HALF: {
                return HALF;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case F128: {
                return F128;
            }
            case X86_FP80: {
                return X86_FP80;
            }
            case PPC_FP128: {
                return PPC_FP128;
            }
        }
        throw new IllegalStateException("Unknown type");
    }

    PrimitiveType(PrimitiveKind kind, Object constant) {
        this.kind = kind;
        this.constant = constant;
    }

    public boolean isConstant() {
        return this.constant != null;
    }

    public Object getConstant() {
        return this.constant;
    }

    public PrimitiveKind getPrimitiveKind() {
        return this.kind;
    }

    @Override
    public long getBitSize() {
        return this.kind.sizeInBits;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int getAlignment(DataLayout targetDataLayout) {
        if (targetDataLayout != null) {
            return targetDataLayout.getBitAlignment(this) / 8;
        }
        if (this.getBitSize() <= 8L) {
            return 1;
        }
        if (this.getBitSize() <= 16L) {
            return 2;
        }
        if (this.getBitSize() <= 32L) {
            return 4;
        }
        return 8;
    }

    @Override
    public long getSize(DataLayout targetDataLayout) {
        try {
            return targetDataLayout.getSize(this);
        }
        catch (Type.TypeOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        if (Type.isIntegerType(this)) {
            return String.format("i%d", this.getBitSize());
        }
        return this.kind.name().toLowerCase();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.constant == null ? 0 : this.constant.hashCode());
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrimitiveType other = (PrimitiveType)obj;
        if (this.constant == null ? other.constant != null : !this.constant.equals(other.constant)) {
            return false;
        }
        return this.kind == other.kind;
    }

    @Override
    public LLVMExpressionNode createNullConstant(NodeFactory nodeFactory, DataLayout dataLayout, GetStackSpaceFactory stackFactory) {
        switch (this.getPrimitiveKind()) {
            case I1: {
                return CommonNodeFactory.createSimpleConstantNoArray(false, this);
            }
            case I8: {
                return CommonNodeFactory.createSimpleConstantNoArray((byte)0, this);
            }
            case I16: {
                return CommonNodeFactory.createSimpleConstantNoArray((short)0, this);
            }
            case I32: {
                return CommonNodeFactory.createSimpleConstantNoArray(0, this);
            }
            case I64: {
                return CommonNodeFactory.createSimpleConstantNoArray(0L, this);
            }
            case FLOAT: {
                return CommonNodeFactory.createSimpleConstantNoArray(Float.valueOf(0.0f), this);
            }
            case DOUBLE: {
                return CommonNodeFactory.createSimpleConstantNoArray(0.0, this);
            }
            case X86_FP80: {
                return CommonNodeFactory.createSimpleConstantNoArray(null, this);
            }
            case F128: {
                return CommonNodeFactory.createSimpleConstantNoArray(null, this);
            }
        }
        throw new LLVMParserException("Unsupported Type for Zero Constant: " + this);
    }

    public static enum PrimitiveKind {
        I1(1),
        I8(8),
        I16(16),
        I32(32),
        I64(64),
        HALF(16),
        FLOAT(32),
        DOUBLE(64),
        F128(128),
        X86_FP80(80),
        PPC_FP128(128);

        private final int sizeInBits;

        private PrimitiveKind(int sizeInBits) {
            this.sizeInBits = sizeInBits;
        }

        public int getSizeInBits() {
            return this.sizeInBits;
        }
    }
}

