/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.vars;

import com.oracle.truffle.api.ContextThreadLocal;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.IDGenerater;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer;
import com.oracle.truffle.llvm.runtime.memory.LLVMAllocateNode;
import com.oracle.truffle.llvm.runtime.nodes.vars.AggregateLiteralInPlaceNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public class AggregateTLGlobalInPlaceNode
extends RootNode {
    @Node.Child
    private AggregateLiteralInPlaceNode inPlaceNode;
    private final ContextThreadLocal<LLVMLanguage.LLVMThreadLocalValue> contextThreadLocal;
    @Node.Child
    private LLVMAllocateNode allocTLSection;
    private final IDGenerater.BitcodeID bitcodeID;
    private final int globalContainersSize;
    private final long allocationSize;

    public AggregateTLGlobalInPlaceNode(LLVMLanguage llvmLanguage, AggregateLiteralInPlaceNode inPlaceNode, LLVMAllocateNode allocTLSection, IDGenerater.BitcodeID bitcodeID, int globalContainersSize, long allocationSize) {
        super((TruffleLanguage)llvmLanguage);
        this.contextThreadLocal = llvmLanguage.contextThreadLocal;
        this.inPlaceNode = inPlaceNode;
        this.allocTLSection = allocTLSection;
        this.bitcodeID = bitcodeID;
        this.globalContainersSize = globalContainersSize + 1;
        this.allocationSize = allocationSize;
    }

    public Object execute(VirtualFrame frame) {
        assert (frame.getArguments().length > 0);
        assert (frame.getArguments()[0] instanceof Thread);
        this.executeWithThread(frame, (Thread)frame.getArguments()[0]);
        return null;
    }

    public void executeWithThread(VirtualFrame frame, Thread thread) {
        LLVMPointer tlgBase = AggregateTLGlobalInPlaceNode.allocOrNull(this.allocTLSection);
        if (tlgBase != null) {
            assert (this.allocationSize > 0L);
            ((LLVMLanguage.LLVMThreadLocalValue)this.contextThreadLocal.get(thread)).addSection(tlgBase, this.allocationSize, this.bitcodeID);
        }
        LLVMGlobalContainer[] globalContainers = new LLVMGlobalContainer[this.globalContainersSize];
        for (int i = 0; i < this.globalContainersSize; ++i) {
            globalContainers[i] = new LLVMGlobalContainer();
        }
        ((LLVMLanguage.LLVMThreadLocalValue)this.contextThreadLocal.get(thread)).addGlobalContainer(globalContainers, this.bitcodeID);
        this.inPlaceNode.execute(frame, thread);
    }

    private static LLVMPointer allocOrNull(LLVMAllocateNode allocNode) {
        if (allocNode != null) {
            return allocNode.executeWithTarget();
        }
        return null;
    }

    public String getName() {
        return "AggregateThreadLocalGlobalInPlaceNode/" + this.bitcodeID.getId();
    }
}

