/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMOffsetStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMI32StoreNode
extends LLVMStoreNode {
    public abstract void executeWithTarget(LLVMPointer var1, int var2);

    @Specialization(guards={"!isAutoDerefHandle(addr)"})
    protected void doOp(LLVMNativePointer addr, int value) {
        this.getLanguage().getLLVMMemory().putI32((Node)this, addr, value);
    }

    @Specialization(guards={"isAutoDerefHandle(addr)"})
    protected static void doOpDerefHandle(LLVMNativePointer addr, int value, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
        LLVMI32StoreNode.doOpManaged(getReceiver.execute(addr), value, nativeWrite);
    }

    @Specialization(limit="3")
    @GenerateAOT.Exclude
    protected static void doOpManaged(LLVMManagedPointer address, int value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        nativeWrite.writeI32(address.getObject(), address.getOffset(), value);
    }

    public static LLVMI32StoreNode create() {
        return LLVMI32StoreNodeGen.create(null, null);
    }

    @GenerateUncached
    public static abstract class LLVMI32OffsetStoreNode
    extends LLVMOffsetStoreNode {
        public static LLVMI32OffsetStoreNode create() {
            return LLVMI32StoreNodeGen.LLVMI32OffsetStoreNodeGen.create(null, null, null);
        }

        public static LLVMI32OffsetStoreNode create(LLVMExpressionNode value) {
            return LLVMI32StoreNodeGen.LLVMI32OffsetStoreNodeGen.create(null, null, value);
        }

        public abstract void executeWithTarget(LLVMPointer var1, long var2, int var4);

        @Specialization(guards={"!isAutoDerefHandle(addr)"})
        protected void doOp(LLVMNativePointer addr, long offset, int value) {
            this.getLanguage().getLLVMMemory().putI32((Node)this, addr.asNative() + offset, value);
        }

        @Specialization(guards={"isAutoDerefHandle(addr)"})
        protected static void doOpDerefHandle(LLVMNativePointer addr, long offset, int value, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
            LLVMI32OffsetStoreNode.doOpManaged(getReceiver.execute(addr), offset, value, nativeWrite);
        }

        @Specialization(limit="3")
        @GenerateAOT.Exclude
        protected static void doOpManaged(LLVMManagedPointer address, long offset, int value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
            nativeWrite.writeI32(address.getObject(), address.getOffset() + offset, value);
        }
    }
}

