/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.x86_win;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMHasDatalayoutNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVaListLibrary;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVaListStorage;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI16LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMPointerLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMMaybeVaPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;

@ExportLibrary.Repeat(value={@ExportLibrary(value=LLVMVaListLibrary.class, useForAOT=true, useForAOTPriority=2), @ExportLibrary(value=LLVMManagedReadLibrary.class, useForAOT=true, useForAOTPriority=1), @ExportLibrary(value=InteropLibrary.class)})
public final class LLVMX86_64_WinVaListStorage
implements TruffleObject {
    protected LLVMPointer nativeAreaPointer;
    protected WinArgsArea argsArea;
    protected Object[] realArguments;
    protected int numberOfExplicitArguments;
    protected boolean nativized;
    private int consumedBytes;
    public static final String GET_MEMBER = "get";
    public static final String NEXT_MEMBER = "next";

    public boolean isNativized() {
        return this.nativized;
    }

    @ExportMessage(name="isReadable")
    boolean isAccessible() {
        return true;
    }

    @ExportMessage
    public boolean isPointer() {
        return this.isNativized();
    }

    protected static DataLayout findDataLayoutFromCurrentFrame() {
        RootCallTarget callTarget = (RootCallTarget)Truffle.getRuntime().iterateFrames(f -> f.getCallTarget());
        return ((LLVMHasDatalayoutNode)callTarget.getRootNode()).getDatalayout();
    }

    @ExportMessage
    public long asPointer() throws UnsupportedMessageException {
        if (this.isPointer()) {
            return LLVMNativePointer.cast(this.nativeAreaPointer).asNative();
        }
        throw UnsupportedMessageException.create();
    }

    private static void doPrimitiveWrite(LLVMPointer ptr, long offset, LLVMI64StoreNode.LLVMI64OffsetStoreNode storeNode, Object arg) throws AssertionError {
        long value;
        if (arg instanceof Boolean) {
            value = (Boolean)arg != false ? 1L : 0L;
        } else if (arg instanceof Byte) {
            value = Integer.toUnsignedLong(((Byte)arg).byteValue());
        } else if (arg instanceof Short) {
            value = Integer.toUnsignedLong(((Short)arg).shortValue());
        } else if (arg instanceof Integer) {
            value = Integer.toUnsignedLong((Integer)arg);
        } else if (arg instanceof Long) {
            value = (Long)arg;
        } else if (arg instanceof Float) {
            value = Integer.toUnsignedLong(Float.floatToIntBits(((Float)arg).floatValue()));
        } else if (arg instanceof Double) {
            value = Double.doubleToRawLongBits((Double)arg);
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw CompilerDirectives.shouldNotReachHere((String)String.valueOf(arg));
        }
        storeNode.executeWithTarget(ptr, offset, value);
    }

    private static void storeArgument(LLVMPointer ptr, long offset, Object object, LLVMI64StoreNode.LLVMI64OffsetStoreNode storeI64Node, LLVMPointerStoreNode.LLVMPointerOffsetStoreNode storePointerNode) {
        if (object instanceof Number) {
            LLVMX86_64_WinVaListStorage.doPrimitiveWrite(ptr, offset, storeI64Node, object);
        } else if (LLVMPointer.isInstance(object)) {
            storePointerNode.executeWithTarget(ptr, offset, object);
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw CompilerDirectives.shouldNotReachHere((String)String.valueOf(object));
        }
    }

    private static void initNative(Object[] realArgs, int numOfExpArgs, LLVMPointer pointer, LLVMI64StoreNode.LLVMI64OffsetStoreNode storeI64Node, @Cached.Exclusive @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode storePointerNode) {
        int offset = 0;
        for (int i = numOfExpArgs; i < realArgs.length; ++i) {
            LLVMX86_64_WinVaListStorage.storeArgument(pointer, offset, realArgs[i], storeI64Node, storePointerNode);
            offset += 8;
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    void toNative(@Cached.Exclusive @Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode storeI64Node, @Cached.Exclusive @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode storePointerNode, @Cached BranchProfile nativizedProfile) {
        if (this.isNativized()) {
            nativizedProfile.enter();
        }
        this.nativized = true;
        LLVMX86_64_WinVaListStorage.initNative(this.realArguments, this.numberOfExplicitArguments, this.nativeAreaPointer, storeI64Node, storePointerNode);
    }

    @ExportMessage
    public void initialize(Object[] realArgs, int numOfExpArgs, Frame frame, @Cached LLVMVaListStorage.StackAllocationNode stackAllocationNode) {
        this.realArguments = realArgs;
        this.numberOfExplicitArguments = numOfExpArgs;
        this.argsArea = new WinArgsArea(realArgs, numOfExpArgs);
        assert (numOfExpArgs <= realArgs.length);
        this.nativeAreaPointer = stackAllocationNode.executeWithTarget((realArgs.length - numOfExpArgs) * 8, frame);
    }

    @ExportMessage
    void cleanup(Frame frame) {
        throw CompilerDirectives.shouldNotReachHere((String)"should only be called on LLVMMaybeVaPointer");
    }

    @ExportMessage
    void copy(Object dest, Frame frame) {
        throw CompilerDirectives.shouldNotReachHere((String)"should never be called directly");
    }

    @ExportMessage
    Object shift(Type type, Frame frame, @CachedLibrary(limit="1") LLVMManagedReadLibrary readLib) {
        try {
            if (type instanceof PrimitiveType) {
                switch (((PrimitiveType)type).getPrimitiveKind()) {
                    case DOUBLE: {
                        Double d = readLib.readDouble(this, this.consumedBytes);
                        return d;
                    }
                    case FLOAT: {
                        Float f = Float.valueOf(readLib.readFloat(this, this.consumedBytes));
                        return f;
                    }
                    case I1: {
                        Boolean bl = readLib.readI8(this, this.consumedBytes) != 0;
                        return bl;
                    }
                    case I16: {
                        Short s = readLib.readI16(this, this.consumedBytes);
                        return s;
                    }
                    case I32: {
                        Integer n = readLib.readI32(this, this.consumedBytes);
                        return n;
                    }
                    case I64: {
                        Object object = readLib.readGenericI64(this, this.consumedBytes);
                        return object;
                    }
                    case I8: {
                        Byte by = readLib.readI8(this, this.consumedBytes);
                        return by;
                    }
                }
                throw CompilerDirectives.shouldNotReachHere((String)"not implemented");
            }
            if (type instanceof PointerType) {
                LLVMPointer lLVMPointer = readLib.readPointer(this, this.consumedBytes);
                return lLVMPointer;
            }
            throw CompilerDirectives.shouldNotReachHere((String)"not implemented");
        }
        finally {
            this.consumedBytes += 8;
        }
    }

    @ExportMessage
    public boolean hasMembers() {
        return true;
    }

    @ExportMessage
    public Object getMembers(boolean includeInternal) {
        return new VAListMembers();
    }

    @ExportMessage
    public long getArraySize() {
        return this.argsArea.args.length - this.argsArea.numOfExpArgs;
    }

    @ExportMessage
    public boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    public boolean isArrayElementReadable(long index) {
        return index < this.getArraySize();
    }

    @ExportMessage
    Object readArrayElement(long index, @Cached.Shared(value="escapeNode") @Cached LLVMDataEscapeNode.LLVMPointerDataEscapeNode pointerEscapeNode) {
        Object arg = this.argsArea.args[(int)(index + (long)this.argsArea.numOfExpArgs)];
        return pointerEscapeNode.executeWithTarget(arg);
    }

    public static final class WinArgsArea
    extends LLVMVaListStorage.ArgsArea {
        private final int numOfExpArgs;

        WinArgsArea(Object[] args, int numOfExpArgs) {
            super(args);
            this.numOfExpArgs = numOfExpArgs;
        }

        @Override
        protected long offsetToIndex(long offset) {
            if (offset < 0L) {
                return -1L;
            }
            long argIndex = offset / 8L + (long)this.numOfExpArgs;
            long argOffset = offset % 8L;
            return argIndex + (argOffset << 32);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class VAListMembers
    implements TruffleObject {
        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return 2L;
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return index == 0L || index == 1L;
        }

        @ExportMessage
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            if (index == 0L) {
                return LLVMX86_64_WinVaListStorage.GET_MEMBER;
            }
            if (index == 1L) {
                return LLVMX86_64_WinVaListStorage.NEXT_MEMBER;
            }
            throw InvalidArrayIndexException.create((long)index);
        }
    }

    @ExportMessage
    public static class InvokeMember {
        @Specialization(guards={"GET_MEMBER.equals(member)"})
        public static Object get(LLVMX86_64_WinVaListStorage receiver, String member, Object[] arguments, @Cached.Shared(value="escapeNode") @Cached LLVMDataEscapeNode.LLVMPointerDataEscapeNode pointerEscapeNode) throws ArityException, UnsupportedTypeException {
            if (arguments.length != 2) {
                throw ArityException.create((int)2, (int)2, (int)arguments.length);
            }
            if (!(arguments[0] instanceof Integer)) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw UnsupportedTypeException.create((Object[])new Object[]{arguments[0]}, (String)"Index argument must be an integer");
            }
            int i = (Integer)arguments[0];
            if (i >= receiver.realArguments.length - receiver.numberOfExplicitArguments) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new ArrayIndexOutOfBoundsException(i);
            }
            Object arg = receiver.realArguments[receiver.numberOfExplicitArguments + i];
            if (!(arguments[1] instanceof LLVMInteropType.Structured)) {
                return arg;
            }
            LLVMInteropType.Structured type = (LLVMInteropType.Structured)arguments[1];
            if (!LLVMPointer.isInstance(arg)) {
                return arg;
            }
            LLVMPointer ptrArg = LLVMPointer.cast(arg);
            return pointerEscapeNode.executeWithType(ptrArg, type);
        }

        @Specialization(guards={"NEXT_MEMBER.equals(member)"})
        public static Object next(LLVMX86_64_WinVaListStorage receiver, String member, Object[] arguments, @CachedLibrary(value="receiver") LLVMVaListLibrary vaListLib, @Cached.Shared(value="escapeNode") @Cached LLVMDataEscapeNode.LLVMPointerDataEscapeNode pointerEscapeNode) throws ArityException, UnsupportedTypeException {
            Type internalType;
            LLVMInteropType type;
            block17: {
                block16: {
                    if (arguments.length != 1) {
                        throw ArityException.create((int)1, (int)1, (int)arguments.length);
                    }
                    if (!(arguments[0] instanceof LLVMInteropType)) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        throw UnsupportedTypeException.create((Object[])arguments, (String)"LLVMInteropType");
                    }
                    type = (LLVMInteropType)arguments[0];
                    if (!(type instanceof LLVMInteropType.Value)) break block16;
                    switch (((LLVMInteropType.Value)type).kind) {
                        case DOUBLE: {
                            internalType = PrimitiveType.DOUBLE;
                            break block17;
                        }
                        case FLOAT: {
                            internalType = PrimitiveType.FLOAT;
                            break block17;
                        }
                        case I1: {
                            internalType = PrimitiveType.I1;
                            break block17;
                        }
                        case I16: {
                            internalType = PrimitiveType.I16;
                            break block17;
                        }
                        case I32: {
                            internalType = PrimitiveType.I32;
                            break block17;
                        }
                        case I64: {
                            internalType = PrimitiveType.I64;
                            break block17;
                        }
                        case I8: {
                            internalType = PrimitiveType.I8;
                            break block17;
                        }
                        case POINTER: {
                            internalType = new PointerType(PrimitiveType.I64);
                            break block17;
                        }
                        default: {
                            throw CompilerDirectives.shouldNotReachHere((String)"not implemented");
                        }
                    }
                }
                if (type instanceof LLVMInteropType.Structured) {
                    internalType = new PointerType(PrimitiveType.I64);
                } else {
                    throw CompilerDirectives.shouldNotReachHere((String)"not implemented");
                }
            }
            Object result = vaListLib.shift(receiver, internalType, null);
            if (!(type instanceof LLVMInteropType.Structured)) {
                return result;
            }
            if (!LLVMPointer.isInstance(result)) {
                return result;
            }
            LLVMPointer ptrArg = LLVMPointer.cast(result);
            return pointerEscapeNode.executeWithType(ptrArg, (LLVMInteropType.Structured)type);
        }

        @Fallback
        public static Object other(LLVMX86_64_WinVaListStorage receiver, String member, Object[] arguments) throws UnknownIdentifierException {
            throw UnknownIdentifierException.create((String)member);
        }
    }

    @ExportMessage
    public static class IsMemberInvocable {
        @Specialization(guards={"GET_MEMBER.equals(member)"})
        public static boolean get(LLVMX86_64_WinVaListStorage receiver, String member) {
            return true;
        }

        @Specialization(guards={"NEXT_MEMBER.equals(member)"})
        public static boolean next(LLVMX86_64_WinVaListStorage receiver, String member) {
            return true;
        }

        @Fallback
        public static boolean other(LLVMX86_64_WinVaListStorage receiver, String member) {
            return false;
        }
    }

    @GenerateUncached
    public static abstract class PointerWrapperFactory
    extends LLVMVaListStorage.VAListPointerWrapperFactory {
        public abstract Object execute(Object var1);

        @Specialization
        protected Object createNativeWrapper(LLVMNativePointer p) {
            return new NativeVAListWrapper(p);
        }

        @Specialization(guards={"!isManagedVAList(p.getObject())"})
        protected Object createManagedWrapper(LLVMManagedPointer p) {
            return new NativeVAListWrapper(p);
        }

        @Specialization(guards={"isManagedVAList(p.getObject())"})
        protected Object createManagedVAListWrapper(LLVMManagedPointer p) {
            return p.getObject();
        }

        static boolean isManagedVAList(Object o) {
            return o instanceof LLVMMaybeVaPointer;
        }
    }

    @ExportLibrary(value=LLVMVaListLibrary.class, useForAOT=true, useForAOTPriority=0)
    @ImportStatic(value={LLVMX86_64_WinVaListStorage.class})
    public static final class NativeVAListWrapper {
        final LLVMPointer nativeVAListPtr;

        public NativeVAListWrapper(LLVMPointer nativeVAListPtr) {
            this.nativeVAListPtr = nativeVAListPtr;
        }

        @ExportMessage
        public void initialize(Object[] arguments, int numberOfExplicitArguments, Frame frame, @Cached.Exclusive @Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode storeI64Node, @Cached.Exclusive @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode storePointerNode) {
            LLVMX86_64_WinVaListStorage.initNative(arguments, numberOfExplicitArguments, this.nativeVAListPtr, storeI64Node, storePointerNode);
        }

        @ExportMessage
        static void copy(NativeVAListWrapper self, Object destVaList, Frame frame) {
            throw CompilerDirectives.shouldNotReachHere((String)"Should not copy VA directly.");
        }

        @ExportMessage
        public void cleanup(Frame frame) {
        }

        @ExportMessage
        public Object shift(Type type, Frame frame) {
            throw CompilerDirectives.shouldNotReachHere((String)"Should not shift VA directly.");
        }
    }

    @ExportMessage
    static class ReadGenericI64 {
        ReadGenericI64() {
        }

        @Specialization(guards={"va.isNativized()"})
        static Object readI64Native(LLVMX86_64_WinVaListStorage va, long offset, @Cached LLVMI64LoadNode.LLVMI64OffsetLoadNode loadNode) {
            return loadNode.executeWithTargetGeneric(va.nativeAreaPointer, offset);
        }

        @Specialization(guards={"!va.isNativized()"}, limit="1")
        static Object readI64Managed(LLVMX86_64_WinVaListStorage va, long offset, @CachedLibrary(value="va.argsArea") LLVMManagedReadLibrary readLibrary) {
            return readLibrary.readGenericI64(va.argsArea, offset);
        }
    }

    @ExportMessage
    static class ReadPointer {
        ReadPointer() {
        }

        @Specialization(guards={"va.isNativized()"})
        static LLVMPointer readPointerNative(LLVMX86_64_WinVaListStorage va, long offset, @Cached LLVMPointerLoadNode.LLVMPointerOffsetLoadNode loadNode) {
            return loadNode.executeWithTarget(va.nativeAreaPointer, offset);
        }

        @Specialization(guards={"!va.isNativized()"}, limit="1")
        static LLVMPointer readPointerManaged(LLVMX86_64_WinVaListStorage va, long offset, @CachedLibrary(value="va.argsArea") LLVMManagedReadLibrary readLibrary) {
            return readLibrary.readPointer(va.argsArea, offset);
        }
    }

    @ExportMessage
    static class ReadI32 {
        ReadI32() {
        }

        @Specialization(guards={"va.isNativized()"})
        static int readI32Native(LLVMX86_64_WinVaListStorage va, long offset, @Cached LLVMI32LoadNode.LLVMI32OffsetLoadNode loadNode) {
            return loadNode.executeWithTarget(va.nativeAreaPointer, offset);
        }

        @Specialization(guards={"!va.isNativized()"}, limit="1")
        static int readI32Managed(LLVMX86_64_WinVaListStorage va, long offset, @CachedLibrary(value="va.argsArea") LLVMManagedReadLibrary readLibrary) {
            return readLibrary.readI32(va.argsArea, offset);
        }
    }

    @ExportMessage
    static class ReadI16 {
        ReadI16() {
        }

        @Specialization(guards={"va.isNativized()"})
        static short readI16Native(LLVMX86_64_WinVaListStorage va, long offset, @Cached LLVMI16LoadNode.LLVMI16OffsetLoadNode loadNode) {
            return loadNode.executeWithTarget(va.nativeAreaPointer, offset);
        }

        @Specialization(guards={"!va.isNativized()"}, limit="1")
        static short readI16Managed(LLVMX86_64_WinVaListStorage va, long offset, @CachedLibrary(value="va.argsArea") LLVMManagedReadLibrary readLibrary) {
            return readLibrary.readI16(va.argsArea, offset);
        }
    }

    @ExportMessage
    static class ReadI8 {
        ReadI8() {
        }

        @Specialization(guards={"va.isNativized()"})
        static byte readI8Native(LLVMX86_64_WinVaListStorage va, long offset, @Cached LLVMI8LoadNode.LLVMI8OffsetLoadNode loadNode) {
            return loadNode.executeWithTarget(va.nativeAreaPointer, offset);
        }

        @Specialization(guards={"!va.isNativized()"}, limit="1")
        static byte readI8Managed(LLVMX86_64_WinVaListStorage va, long offset, @CachedLibrary(value="va.argsArea") LLVMManagedReadLibrary readLibrary) {
            return readLibrary.readI8(va.argsArea, offset);
        }
    }
}

