/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.typed;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.typed.LLVMArrayTypeIDNode;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMArrayTypeIDNode.class)
public final class LLVMArrayTypeIDNodeGen
extends LLVMArrayTypeIDNode
implements GenerateAOT.Provider {
    @Node.Child
    private LLVMExpressionNode base_;
    @Node.Child
    private LLVMExpressionNode len_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;

    private LLVMArrayTypeIDNodeGen(LLVMExpressionNode base, LLVMExpressionNode len) {
        this.base_ = base;
        this.len_ = len;
    }

    private boolean fallbackGuard_(Object baseValue, Object lenValue) {
        long lenValue_;
        return !(baseValue instanceof LLVMInteropType) || !(lenValue instanceof Long) || (lenValue_ = ((Long)lenValue).longValue()) < 0L;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 4) == 0 && (state_0 & 6) != 0) {
            return this.executeGeneric_long0(state_0, frameValue);
        }
        return this.executeGeneric_generic1(state_0, frameValue);
    }

    private Object executeGeneric_long0(int state_0__, VirtualFrame frameValue) {
        long lenValue_;
        int state_0 = state_0__;
        Object baseValue_ = this.base_.executeGeneric(frameValue);
        try {
            lenValue_ = this.len_.executeI64(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(baseValue_, ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(baseValue_, lenValue_);
        }
        assert ((state_0 & 2) != 0);
        if (baseValue_ instanceof LLVMInteropType) {
            LLVMInteropType baseValue__ = (LLVMInteropType)baseValue_;
            if (lenValue_ >= 0L) {
                return this.doArray(baseValue__, lenValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(baseValue_, lenValue_);
    }

    private Object executeGeneric_generic1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object baseValue_ = this.base_.executeGeneric(frameValue);
        Object lenValue_ = this.len_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(baseValue_, lenValue_);
        }
        if ((state_0 & 6) != 0) {
            if ((state_0 & 2) != 0 && baseValue_ instanceof LLVMInteropType) {
                long lenValue__;
                LLVMInteropType baseValue__ = (LLVMInteropType)baseValue_;
                if (lenValue_ instanceof Long && (lenValue__ = ((Long)lenValue_).longValue()) >= 0L) {
                    return this.doArray(baseValue__, lenValue__);
                }
            }
            if ((state_0 & 4) != 0 && this.fallbackGuard_(baseValue_, lenValue_)) {
                return this.doError(baseValue_, lenValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(baseValue_, lenValue_);
    }

    private Object executeAndSpecialize(Object baseValue, Object lenValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (baseValue instanceof LLVMInteropType) {
            long lenValue_;
            LLVMInteropType baseValue_ = (LLVMInteropType)baseValue;
            if (lenValue instanceof Long && (lenValue_ = ((Long)lenValue).longValue()) >= 0L) {
                this.state_0_ = state_0 |= 2;
                return this.doArray(baseValue_, lenValue_);
            }
        }
        this.state_0_ = state_0 |= 4;
        return this.doError(baseValue, lenValue);
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 6) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 6 & (state_0 & 6) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        if ((this.state_0_ & 1) != 0) {
            return;
        }
        this.state_0_ |= 2;
        this.state_0_ |= 4;
        int state_0 = this.state_0_;
        this.state_0_ = state_0 |= 1;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if ((state_0 & 1) == 0) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMArrayTypeIDNode create(LLVMExpressionNode base, LLVMExpressionNode len) {
        return new LLVMArrayTypeIDNodeGen(base, len);
    }
}

