/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.c;

import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMSyscallNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.c.LLVMSyscallFactory;
import com.oracle.truffle.llvm.runtime.nodes.literals.LLVMSimpleLiteralNodeFactory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMSyscall {
    private LLVMSyscall() {
    }

    public static LLVMExpressionNode create(LLVMExpressionNode[] arguments) {
        int i;
        assert (arguments.length >= 1 && arguments.length <= 7);
        LLVMExpressionNode[] args = new LLVMExpressionNode[7];
        for (i = 0; i < arguments.length; ++i) {
            args[i] = LLVMSyscallFactory.SyscallArgConverterNodeGen.create(arguments[i]);
        }
        for (i = arguments.length; i < args.length; ++i) {
            args[i] = LLVMSimpleLiteralNodeFactory.LLVMI64LiteralNodeGen.create(0L);
        }
        return LLVMSyscallNodeGen.create(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
    }

    @NodeChild(value="value", type=LLVMExpressionNode.class)
    static abstract class SyscallArgConverter
    extends LLVMExpressionNode {
        SyscallArgConverter() {
        }

        @Specialization
        protected static long convert(long value) {
            return value;
        }

        @Specialization
        protected static long convert(int value) {
            return value;
        }

        @Specialization
        protected static long convert(short value) {
            return value;
        }

        @Specialization
        protected static long convert(byte value) {
            return value;
        }

        @Specialization
        protected static LLVMPointer convert(LLVMPointer value) {
            return value;
        }

        @Fallback
        protected static Object convert(Object value) {
            return value;
        }
    }
}

