/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.CountingConditionProfile;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64UpdateFlagsNode;

@NodeChildren(value={@NodeChild(value="left"), @NodeChild(value="right"), @NodeChild(value="cf")})
public abstract class LLVMAMD64AdcNode
extends LLVMExpressionNode {
    @Node.Child
    protected LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode flags;
    protected final CountingConditionProfile noCfProfile = CountingConditionProfile.create();
    protected final CountingConditionProfile smallLeftProfile = CountingConditionProfile.create();
    protected final CountingConditionProfile smallRightProfile = CountingConditionProfile.create();

    private static boolean carry(byte left, byte right) {
        byte result = (byte)(left + right);
        return (left < 0 || right < 0) && result >= 0 || left < 0 && right < 0;
    }

    private static boolean carry(short left, short right) {
        short result = (short)(left + right);
        return (left < 0 || right < 0) && result >= 0 || left < 0 && right < 0;
    }

    private static boolean carry(int left, int right) {
        int result = left + right;
        return (left < 0 || right < 0) && result >= 0 || left < 0 && right < 0;
    }

    private static boolean carry(long left, long right) {
        long result = left + right;
        return (left < 0L || right < 0L) && result >= 0L || left < 0L && right < 0L;
    }

    private static boolean overflow(byte left, byte right) {
        byte result = (byte)(left + right);
        return result < 0 && left > 0 && right > 0 || result >= 0 && left < 0 && right < 0;
    }

    private static boolean overflow(short left, short right) {
        short result = (short)(left + right);
        return result < 0 && left > 0 && right > 0 || result >= 0 && left < 0 && right < 0;
    }

    private static boolean overflow(int left, int right) {
        int result = left + right;
        return result < 0 && left > 0 && right > 0 || result >= 0 && left < 0 && right < 0;
    }

    private static boolean overflow(long left, long right) {
        long result = left + right;
        return result < 0L && left > 0L && right > 0L || result >= 0L && left < 0L && right < 0L;
    }

    private LLVMAMD64AdcNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode flags) {
        this.flags = flags;
    }

    public static abstract class LLVMAMD64AdcqNode
    extends LLVMAMD64AdcNode {
        public LLVMAMD64AdcqNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode flags) {
            super(flags);
        }

        @Specialization
        protected long doI64(VirtualFrame frame, long left, long right, boolean cf) {
            boolean carry;
            boolean overflow;
            long c = cf ? 1L : 0L;
            long result = left + right + c;
            if (this.noCfProfile.profile(!cf)) {
                overflow = result < 0L && left > 0L && right > 0L || result >= 0L && left < 0L && right < 0L;
                carry = (left < 0L || right < 0L) && result >= 0L || left < 0L && right < 0L;
            } else if (this.smallLeftProfile.profile(left != -1L)) {
                overflow = LLVMAMD64AdcNode.overflow(left + 1L, right);
                carry = LLVMAMD64AdcNode.carry(left + 1L, right);
            } else if (this.smallRightProfile.profile(right != -1L)) {
                overflow = LLVMAMD64AdcNode.overflow(left, right + 1L);
                carry = LLVMAMD64AdcNode.carry(left, right + 1L);
            } else {
                overflow = false;
                carry = true;
            }
            this.flags.execute(frame, overflow, carry, result);
            return result;
        }
    }

    public static abstract class LLVMAMD64AdclNode
    extends LLVMAMD64AdcNode {
        public LLVMAMD64AdclNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode flags) {
            super(flags);
        }

        @Specialization
        protected int doI32(VirtualFrame frame, int left, int right, boolean cf) {
            boolean carry;
            boolean overflow;
            int c = cf ? 1 : 0;
            int result = left + right + c;
            if (this.noCfProfile.profile(!cf)) {
                overflow = result < 0 && left > 0 && right > 0 || result >= 0 && left < 0 && right < 0;
                carry = (left < 0 || right < 0) && result >= 0 || left < 0 && right < 0;
            } else if (this.smallLeftProfile.profile(left != -1)) {
                overflow = LLVMAMD64AdcNode.overflow(left + 1, right);
                carry = LLVMAMD64AdcNode.carry(left + 1, right);
            } else if (this.smallRightProfile.profile(right != -1)) {
                overflow = LLVMAMD64AdcNode.overflow(left, right + 1);
                carry = LLVMAMD64AdcNode.carry(left, right + 1);
            } else {
                overflow = false;
                carry = true;
            }
            this.flags.execute(frame, overflow, carry, result);
            return result;
        }
    }

    public static abstract class LLVMAMD64AdcwNode
    extends LLVMAMD64AdcNode {
        public LLVMAMD64AdcwNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode flags) {
            super(flags);
        }

        @Specialization
        protected short doI16(VirtualFrame frame, short left, short right, boolean cf) {
            boolean carry;
            boolean overflow;
            short c = cf ? (byte)1 : 0;
            short result = (short)(left + right + c);
            if (this.noCfProfile.profile(!cf)) {
                overflow = result < 0 && left > 0 && right > 0 || result >= 0 && left < 0 && right < 0;
                carry = (left < 0 || right < 0) && result >= 0 || left < 0 && right < 0;
            } else if (this.smallLeftProfile.profile(left != -1)) {
                overflow = LLVMAMD64AdcNode.overflow((short)(left + 1), right);
                carry = LLVMAMD64AdcNode.carry((short)(left + 1), right);
            } else if (this.smallRightProfile.profile(right != -1)) {
                overflow = LLVMAMD64AdcNode.overflow(left, (short)(right + 1));
                carry = LLVMAMD64AdcNode.carry(left, (short)(right + 1));
            } else {
                overflow = false;
                carry = true;
            }
            this.flags.execute(frame, overflow, carry, result);
            return result;
        }
    }

    public static abstract class LLVMAMD64AdcbNode
    extends LLVMAMD64AdcNode {
        public LLVMAMD64AdcbNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode flags) {
            super(flags);
        }

        @Specialization
        protected byte doI8(VirtualFrame frame, byte left, byte right, boolean cf) {
            boolean carry;
            boolean overflow;
            byte c = cf ? (byte)1 : 0;
            byte result = (byte)(left + right + c);
            if (this.noCfProfile.profile(!cf)) {
                overflow = result < 0 && left > 0 && right > 0 || result >= 0 && left < 0 && right < 0;
                carry = (left < 0 || right < 0) && result >= 0 || left < 0 && right < 0;
            } else if (this.smallLeftProfile.profile(left != -1)) {
                overflow = LLVMAMD64AdcNode.overflow((byte)(left + 1), right);
                carry = LLVMAMD64AdcNode.carry((byte)(left + 1), right);
            } else if (this.smallRightProfile.profile(right != -1)) {
                overflow = LLVMAMD64AdcNode.overflow(left, (byte)(right + 1));
                carry = LLVMAMD64AdcNode.carry(left, (byte)(right + 1));
            } else {
                overflow = false;
                carry = true;
            }
            this.flags.execute(frame, overflow, carry, result);
            return result;
        }
    }
}

